-- 基础信息
local base_info = {
	group_id = 133002311
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 311001, monster_id = 21010301, pos = { x = 2004.809, y = 226.087, z = -693.393 }, rot = { x = 0.000, y = 76.593, z = 0.000 }, level = 15, drop_tag = "丘丘人", pose_id = 9012, area_id = 3 },
	{ config_id = 311002, monster_id = 21010301, pos = { x = 2008.099, y = 226.084, z = -694.904 }, rot = { x = 0.000, y = 330.321, z = 0.000 }, level = 15, drop_tag = "丘丘人", pose_id = 9012, area_id = 3 },
	{ config_id = 311005, monster_id = 21030201, pos = { x = 2002.493, y = 225.387, z = -695.938 }, rot = { x = 0.000, y = 79.274, z = 0.000 }, level = 15, drop_tag = "丘丘萨满", pose_id = 9012, area_id = 3 },
	{ config_id = 311006, monster_id = 21010201, pos = { x = 2007.202, y = 226.460, z = -690.771 }, rot = { x = 0.000, y = 194.133, z = 0.000 }, level = 15, drop_tag = "丘丘人", pose_id = 9011, area_id = 3 },
	{ config_id = 311007, monster_id = 21020101, pos = { x = 2010.189, y = 226.685, z = -690.755 }, rot = { x = 0.000, y = 239.313, z = 0.000 }, level = 15, drop_tag = "丘丘暴徒", pose_id = 401, area_id = 3 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 311003, gadget_id = 70310006, pos = { x = 2006.709, y = 226.157, z = -693.049 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311008, gadget_id = 70220014, pos = { x = 2005.757, y = 225.277, z = -698.429 }, rot = { x = 0.000, y = 303.664, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311009, gadget_id = 70220014, pos = { x = 2004.693, y = 225.326, z = -697.514 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311010, gadget_id = 70220013, pos = { x = 2012.389, y = 226.817, z = -693.329 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311011, gadget_id = 70220026, pos = { x = 2002.189, y = 225.942, z = -693.352 }, rot = { x = 0.000, y = 26.913, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311012, gadget_id = 70220026, pos = { x = 2012.515, y = 226.595, z = -695.281 }, rot = { x = 0.000, y = 47.467, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 311014, gadget_id = 70500000, pos = { x = 2010.858, y = 226.402, z = -695.021 }, rot = { x = 0.000, y = 104.673, z = 0.000 }, level = 10, point_type = 9105, isOneoff = true, area_id = 3 },
	{ config_id = 311025, gadget_id = 70500000, pos = { x = 2011.004, y = 226.640, z = -693.298 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311026, gadget_id = 70500000, pos = { x = 2011.007, y = 226.547, z = -693.895 }, rot = { x = 0.000, y = 31.056, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311027, gadget_id = 70500000, pos = { x = 2005.483, y = 225.477, z = -697.105 }, rot = { x = 0.000, y = 206.761, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311028, gadget_id = 70500000, pos = { x = 2006.280, y = 225.464, z = -697.597 }, rot = { x = 21.531, y = 129.563, z = 337.244 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311029, gadget_id = 70500000, pos = { x = 2007.492, y = 226.219, z = -692.974 }, rot = { x = 0.000, y = 86.576, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311030, gadget_id = 70500000, pos = { x = 2006.078, y = 226.042, z = -693.663 }, rot = { x = 0.000, y = 74.119, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311031, gadget_id = 70500000, pos = { x = 2003.626, y = 226.055, z = -693.397 }, rot = { x = 0.000, y = 118.370, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311032, gadget_id = 70500000, pos = { x = 2002.778, y = 225.884, z = -693.815 }, rot = { x = 0.000, y = 183.777, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 },
	{ config_id = 311033, gadget_id = 70500000, pos = { x = 2002.759, y = 225.800, z = -694.213 }, rot = { x = 0.000, y = 57.766, z = 0.000 }, level = 10, point_type = 9104, area_id = 3 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	{ config_id = 1311004, name = "ANY_MONSTER_DIE_311004", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_311004", action = "action_EVENT_ANY_MONSTER_DIE_311004", trigger_count = 0 },
	{ config_id = 1311013, name = "ANY_MONSTER_DIE_311013", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "", action = "action_EVENT_ANY_MONSTER_DIE_311013" },
	{ config_id = 1311015, name = "QUEST_START_311015", event = EventType.EVENT_QUEST_START, source = "2006114", condition = "condition_EVENT_QUEST_START_311015", action = "action_EVENT_QUEST_START_311015" },
	{ config_id = 1311016, name = "QUEST_START_311016", event = EventType.EVENT_QUEST_START, source = "2006114", condition = "condition_EVENT_QUEST_START_311016", action = "action_EVENT_QUEST_START_311016" },
	{ config_id = 1311017, name = "QUEST_FINISH_311017", event = EventType.EVENT_QUEST_FINISH, source = "2006112", condition = "condition_EVENT_QUEST_FINISH_311017", action = "action_EVENT_QUEST_FINISH_311017", trigger_count = 0 },
	{ config_id = 1311018, name = "QUEST_FINISH_311018", event = EventType.EVENT_QUEST_FINISH, source = "2006104", condition = "", action = "action_EVENT_QUEST_FINISH_311018", trigger_count = 0 },
	{ config_id = 1311019, name = "QUEST_FINISH_311019", event = EventType.EVENT_QUEST_FINISH, source = "2006113", condition = "condition_EVENT_QUEST_FINISH_311019", action = "action_EVENT_QUEST_FINISH_311019", trigger_count = 0 },
	{ config_id = 1311020, name = "QUEST_START_311020", event = EventType.EVENT_QUEST_START, source = "2006114", condition = "condition_EVENT_QUEST_START_311020", action = "action_EVENT_QUEST_START_311020" }
}

-- 变量
variables = {
	{ config_id = 1, name = "monster_killed", value = 0, no_refresh = false },
	{ config_id = 2, name = "can_refresh", value = 0, no_refresh = true }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "QUEST_FINISH_311017", "QUEST_FINISH_311018", "QUEST_FINISH_311019" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = suite_2,
		monsters = { 311001, 311002, 311005, 311006, 311007 },
		gadgets = { 311003, 311008, 311009, 311010, 311011, 311012, 311025, 311026, 311027, 311028, 311029, 311030, 311031, 311032, 311033 },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_311004", "ANY_MONSTER_DIE_311013", "QUEST_START_311015", "QUEST_FINISH_311018", "QUEST_START_311020" },
		rand_weight = 100,
		ban_refresh = true
	},
	{
		-- suite_id = 3,
		-- description = suite_3,
		monsters = { 311001, 311002, 311005, 311006, 311007 },
		gadgets = { 311003, 311008, 311009, 311010, 311011, 311012, 311014, 311025, 311026, 311027, 311028, 311029, 311030, 311031, 311032, 311033 },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_311004", "ANY_MONSTER_DIE_311013", "QUEST_START_311016", "QUEST_FINISH_311018", "QUEST_START_311020" },
		rand_weight = 100,
		ban_refresh = true
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_311004(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_311004(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1330023111") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_311013(context, evt)
	-- 将本组内变量名为 "monster_killed" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "monster_killed", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_QUEST_START_311015(context, evt)
	-- 判断变量"monster_killed"为1
	if ScriptLib.GetGroupVariableValue(context, "monster_killed") ~= 1 then
			return false
	end
	
	-- 判断变量"can_refresh"为1
	if ScriptLib.GetGroupVariableValue(context, "can_refresh") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_QUEST_START_311015(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133002311, suite = 2 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	-- 变量"can_refresh"赋值为0
	ScriptLib.SetGroupVariableValue(context, "can_refresh", 0)
	
	-- 变量"monster_killed"赋值为0
	ScriptLib.SetGroupVariableValue(context, "monster_killed", 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_QUEST_START_311016(context, evt)
	-- 判断变量"monster_killed"为1
	if ScriptLib.GetGroupVariableValue(context, "monster_killed") ~= 1 then
			return false
	end
	
	-- 判断变量"can_refresh"为1
	if ScriptLib.GetGroupVariableValue(context, "can_refresh") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_QUEST_START_311016(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133002311, suite = 3 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	-- 变量"can_refresh"赋值为0
	ScriptLib.SetGroupVariableValue(context, "can_refresh", 0)
	
	-- 变量"monster_killed"赋值为0
	ScriptLib.SetGroupVariableValue(context, "monster_killed", 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_QUEST_FINISH_311017(context, evt)
	-- 判断变量"can_refresh"为1
	if ScriptLib.GetGroupVariableValue(context, "can_refresh") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_QUEST_FINISH_311017(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133002311, suite = 2 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_311018(context, evt)
	-- 将本组内变量名为 "can_refresh" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "can_refresh", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 变量"monster_killed"赋值为0
	ScriptLib.SetGroupVariableValue(context, "monster_killed", 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_QUEST_FINISH_311019(context, evt)
	-- 判断变量"can_refresh"为1
	if ScriptLib.GetGroupVariableValue(context, "can_refresh") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_QUEST_FINISH_311019(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133002311, suite = 3 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_QUEST_START_311020(context, evt)
	-- 判断变量"can_refresh"为1
	if ScriptLib.GetGroupVariableValue(context, "can_refresh") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_QUEST_START_311020(context, evt)
	-- 变量"can_refresh"赋值为0
	ScriptLib.SetGroupVariableValue(context, "can_refresh", 0)
	
	return 0
end