-- 基础信息
local base_info = {
	group_id = 133002374
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 374001, monster_id = 20011201, pos = { x = 1960.607, y = 264.017, z = -555.928 }, rot = { x = 0.635, y = 191.879, z = 358.632 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374002, monster_id = 20011201, pos = { x = 1969.261, y = 265.404, z = -559.439 }, rot = { x = 1.416, y = 236.859, z = 359.481 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374003, monster_id = 20011001, pos = { x = 1993.989, y = 252.256, z = -456.867 }, rot = { x = 0.896, y = 191.983, z = 12.263 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374004, monster_id = 20011001, pos = { x = 1998.277, y = 251.528, z = -453.851 }, rot = { x = 352.007, y = 236.209, z = 9.374 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374005, monster_id = 20010801, pos = { x = 1915.734, y = 247.303, z = -379.534 }, rot = { x = 8.935, y = 237.003, z = 1.767 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374006, monster_id = 20010801, pos = { x = 1913.913, y = 246.729, z = -384.916 }, rot = { x = 8.935, y = 237.003, z = 1.767 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374030, monster_id = 20010501, pos = { x = 1884.849, y = 232.630, z = -306.306 }, rot = { x = 7.989, y = 237.049, z = 352.764 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374031, monster_id = 20010501, pos = { x = 1886.253, y = 232.790, z = -309.320 }, rot = { x = 7.989, y = 237.049, z = 352.764 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374070, monster_id = 20011201, pos = { x = 1965.627, y = 265.308, z = -555.425 }, rot = { x = 0.635, y = 191.879, z = 358.632 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374071, monster_id = 20010501, pos = { x = 1995.963, y = 252.217, z = -451.409 }, rot = { x = 352.007, y = 236.209, z = 9.374 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374074, monster_id = 20010501, pos = { x = 1991.737, y = 252.851, z = -454.026 }, rot = { x = 352.007, y = 236.209, z = 9.374 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374075, monster_id = 20010801, pos = { x = 1913.604, y = 246.880, z = -382.125 }, rot = { x = 8.935, y = 237.003, z = 1.767 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374077, monster_id = 20011401, pos = { x = 1881.853, y = 232.480, z = -306.417 }, rot = { x = 7.989, y = 237.049, z = 352.764 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 },
	{ config_id = 374078, monster_id = 20011401, pos = { x = 1883.330, y = 232.549, z = -309.799 }, rot = { x = 7.989, y = 237.049, z = 352.764 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 3 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 374007, gadget_id = 70360005, pos = { x = 1885.710, y = 248.021, z = -605.353 }, rot = { x = 2.663, y = 359.834, z = 352.875 }, level = 1, area_id = 3 },
	{ config_id = 374008, gadget_id = 70360025, pos = { x = 1796.562, y = 212.551, z = -271.112 }, rot = { x = 354.063, y = 0.646, z = 2.218 }, level = 1, area_id = 3 },
	{ config_id = 374009, gadget_id = 70350085, pos = { x = 1964.201, y = 264.776, z = -558.588 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374010, gadget_id = 70300114, pos = { x = 1964.129, y = 263.822, z = -558.611 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374011, gadget_id = 70350085, pos = { x = 1995.557, y = 252.050, z = -454.975 }, rot = { x = 356.615, y = 0.351, z = 348.173 }, level = 1, area_id = 3 },
	{ config_id = 374012, gadget_id = 70300114, pos = { x = 1995.546, y = 251.429, z = -454.989 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374013, gadget_id = 70350085, pos = { x = 1916.628, y = 247.029, z = -383.127 }, rot = { x = 353.661, y = 359.637, z = 6.552 }, level = 1, area_id = 3 },
	{ config_id = 374014, gadget_id = 70300114, pos = { x = 1916.609, y = 247.027, z = -383.128 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374015, gadget_id = 70350085, pos = { x = 1796.568, y = 212.414, z = -271.098 }, rot = { x = 354.063, y = 0.646, z = 2.218 }, level = 1, area_id = 3 },
	{ config_id = 374016, gadget_id = 70350085, pos = { x = 1885.833, y = 248.804, z = -605.312 }, rot = { x = 2.663, y = 359.834, z = 352.875 }, level = 1, area_id = 3 },
	{ config_id = 374017, gadget_id = 70710126, pos = { x = 1964.201, y = 264.776, z = -558.588 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374018, gadget_id = 70710126, pos = { x = 1995.557, y = 252.050, z = -454.975 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374019, gadget_id = 70710126, pos = { x = 1916.628, y = 247.029, z = -383.127 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374032, gadget_id = 70350085, pos = { x = 1883.662, y = 232.571, z = -307.989 }, rot = { x = 1.632, y = 0.842, z = 10.640 }, level = 1, area_id = 3 },
	{ config_id = 374033, gadget_id = 70300114, pos = { x = 1883.643, y = 232.571, z = -307.989 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374034, gadget_id = 70710126, pos = { x = 1883.662, y = 232.571, z = -307.989 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374037, gadget_id = 70690001, pos = { x = 1860.507, y = 229.829, z = -298.303 }, rot = { x = 0.000, y = 295.628, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374038, gadget_id = 70690001, pos = { x = 1854.355, y = 229.829, z = -295.352 }, rot = { x = 0.000, y = 295.628, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374039, gadget_id = 70690001, pos = { x = 1845.355, y = 229.829, z = -291.034 }, rot = { x = 0.000, y = 295.628, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374040, gadget_id = 70690001, pos = { x = 1836.085, y = 229.829, z = -286.587 }, rot = { x = 0.000, y = 295.628, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374041, gadget_id = 70690001, pos = { x = 1898.863, y = 244.808, z = -346.669 }, rot = { x = 0.000, y = 339.599, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374044, gadget_id = 70690001, pos = { x = 2000.120, y = 268.602, z = -535.751 }, rot = { x = 0.000, y = 25.731, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374045, gadget_id = 70690001, pos = { x = 2005.741, y = 267.573, z = -524.088 }, rot = { x = 0.000, y = 25.731, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374046, gadget_id = 70690001, pos = { x = 2012.495, y = 266.579, z = -508.074 }, rot = { x = 0.000, y = 8.756, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374047, gadget_id = 70690001, pos = { x = 2014.206, y = 265.324, z = -490.003 }, rot = { x = 0.000, y = 354.954, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374048, gadget_id = 70220011, pos = { x = 1988.490, y = 254.589, z = -442.558 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374049, gadget_id = 70690001, pos = { x = 1980.169, y = 258.816, z = -438.798 }, rot = { x = 0.000, y = 305.857, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374050, gadget_id = 70690001, pos = { x = 1970.294, y = 258.062, z = -431.660 }, rot = { x = 0.000, y = 305.857, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374051, gadget_id = 70690001, pos = { x = 1957.813, y = 256.713, z = -422.640 }, rot = { x = 0.000, y = 305.857, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374058, gadget_id = 70690001, pos = { x = 1952.372, y = 256.713, z = -418.708 }, rot = { x = 0.000, y = 305.857, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374059, gadget_id = 70690001, pos = { x = 1947.118, y = 256.713, z = -414.911 }, rot = { x = 0.000, y = 305.857, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 374060, gadget_id = 70690001, pos = { x = 1906.479, y = 244.808, z = -367.147 }, rot = { x = 0.000, y = 339.599, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374061, gadget_id = 70690001, pos = { x = 1904.194, y = 244.808, z = -361.005 }, rot = { x = 0.000, y = 339.599, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374062, gadget_id = 70690001, pos = { x = 1902.075, y = 244.808, z = -355.308 }, rot = { x = 0.000, y = 339.599, z = 0.000 }, level = 10, area_id = 3 },
	{ config_id = 374076, gadget_id = 70220004, pos = { x = 1919.280, y = 247.583, z = -380.321 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 }
}

-- 区域
regions = {
	{ config_id = 374023, shape = RegionShape.SPHERE, radius = 2, pos = { x = 1796.435, y = 212.394, z = -271.243 }, area_id = 3 },
	{ config_id = 374024, shape = RegionShape.SPHERE, radius = 7, pos = { x = 1964.177, y = 264.009, z = -558.571 }, area_id = 3 },
	{ config_id = 374026, shape = RegionShape.SPHERE, radius = 7, pos = { x = 1995.546, y = 251.429, z = -454.989 }, area_id = 3 },
	{ config_id = 374028, shape = RegionShape.SPHERE, radius = 7, pos = { x = 1916.609, y = 247.027, z = -383.128 }, area_id = 3 },
	{ config_id = 374035, shape = RegionShape.SPHERE, radius = 7, pos = { x = 1883.643, y = 232.571, z = -307.989 }, area_id = 3 }
}

-- 触发器
triggers = {
	{ config_id = 1374020, name = "GADGET_STATE_CHANGE_374020", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_374020", action = "action_EVENT_GADGET_STATE_CHANGE_374020", trigger_count = 0 },
	{ config_id = 1374021, name = "CHALLENGE_SUCCESS_374021", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_374021", trigger_count = 0 },
	{ config_id = 1374022, name = "CHALLENGE_FAIL_374022", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_374022", trigger_count = 0 },
	{ config_id = 1374023, name = "ENTER_REGION_374023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_374023", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1374024, name = "ENTER_REGION_374024", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_374024", action = "action_EVENT_ENTER_REGION_374024" },
	{ config_id = 1374025, name = "ANY_MONSTER_DIE_374025", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_374025", action = "action_EVENT_ANY_MONSTER_DIE_374025" },
	{ config_id = 1374026, name = "ENTER_REGION_374026", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_374026", action = "action_EVENT_ENTER_REGION_374026" },
	{ config_id = 1374027, name = "ANY_MONSTER_DIE_374027", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_374027", action = "action_EVENT_ANY_MONSTER_DIE_374027" },
	{ config_id = 1374028, name = "ENTER_REGION_374028", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_374028", action = "action_EVENT_ENTER_REGION_374028" },
	{ config_id = 1374029, name = "ANY_MONSTER_DIE_374029", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_374029", action = "action_EVENT_ANY_MONSTER_DIE_374029" },
	{ config_id = 1374035, name = "ENTER_REGION_374035", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_374035", action = "action_EVENT_ENTER_REGION_374035" },
	{ config_id = 1374036, name = "ANY_MONSTER_DIE_374036", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_374036", action = "action_EVENT_ANY_MONSTER_DIE_374036" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 374007, 374016 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_374020", "CHALLENGE_SUCCESS_374021", "CHALLENGE_FAIL_374022" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 374008, 374015, 374037, 374038, 374039, 374040 },
		regions = { 374023 },
		triggers = { "ENTER_REGION_374023" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { 374001, 374002, 374070 },
		gadgets = { 374009, 374010, 374017 },
		regions = { 374024 },
		triggers = { "ENTER_REGION_374024", "ANY_MONSTER_DIE_374025" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { 374003, 374004, 374071, 374074 },
		gadgets = { 374011, 374012, 374018, 374044, 374045, 374046, 374047 },
		regions = { 374026 },
		triggers = { "ENTER_REGION_374026", "ANY_MONSTER_DIE_374027" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { 374005, 374006, 374075 },
		gadgets = { 374013, 374014, 374019, 374049, 374050, 374051, 374058, 374059, 374076 },
		regions = { 374028 },
		triggers = { "ENTER_REGION_374028", "ANY_MONSTER_DIE_374029" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 节点4,
		monsters = { 374030, 374031, 374077, 374078 },
		gadgets = { 374032, 374033, 374034, 374041, 374060, 374061, 374062 },
		regions = { 374035 },
		triggers = { "ENTER_REGION_374035", "ANY_MONSTER_DIE_374036" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_374020(context, evt)
	if 374007 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasStarted"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_374020(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为207的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 207, 70, 4, 888, 8) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133002374, 4)
	
	-- 将configid为 374016 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374016, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_374021(context, evt)
	-- 将configid为 374007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 2)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 7)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133002374, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374048 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_374022(context, evt)
	-- 将configid为 374007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 374016 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374016, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 7)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374048 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_374023(context, evt)
	if evt.param1 ~= 374023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_374024(context, evt)
	if evt.param1 ~= 374024 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_374024(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 374010 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374010, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_374025(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_374025(context, evt)
	-- 将configid为 374010 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374010, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133002374, 5)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 4)
	
	-- 创建id为374048的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 374048 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_374026(context, evt)
	if evt.param1 ~= 374026 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_374026(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374011 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374018 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 374012 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374012, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_374027(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_374027(context, evt)
	-- 将configid为 374012 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374012, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133002374, 6)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_374028(context, evt)
	if evt.param1 ~= 374028 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_374028(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 374014 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374014, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_374029(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_374029(context, evt)
	-- 将configid为 374014 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374014, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133002374, 7)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_374035(context, evt)
	if evt.param1 ~= 374035 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_374035(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374032 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 374034 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 374033 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374033, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_374036(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_374036(context, evt)
	-- 将configid为 374033 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 374033, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133002374, 2)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133002374, 7)
	
	return 0
end