-- 基础信息
local base_info = {
	group_id = 133008298
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 298001, gadget_id = 70690010, pos = { x = 1109.564, y = 343.594, z = -1085.817 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298002, gadget_id = 70690001, pos = { x = 1096.311, y = 430.212, z = -1089.881 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298003, gadget_id = 70690001, pos = { x = 1083.799, y = 430.212, z = -1089.881 }, rot = { x = 356.668, y = 265.000, z = 332.342 }, level = 32, area_id = 10 },
	{ config_id = 298004, gadget_id = 70690001, pos = { x = 1070.258, y = 430.212, z = -1089.890 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298005, gadget_id = 70690001, pos = { x = 1061.643, y = 430.212, z = -1089.890 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298006, gadget_id = 70690001, pos = { x = 1044.961, y = 430.212, z = -1089.647 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298007, gadget_id = 70690001, pos = { x = 1031.174, y = 430.212, z = -1089.643 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298008, gadget_id = 70690001, pos = { x = 1014.632, y = 430.212, z = -1089.650 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298009, gadget_id = 70690001, pos = { x = 1004.007, y = 430.212, z = -1089.649 }, rot = { x = 0.000, y = 265.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298010, gadget_id = 70690001, pos = { x = 997.145, y = 430.212, z = -1089.651 }, rot = { x = 0.000, y = 280.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298011, gadget_id = 70690001, pos = { x = 991.398, y = 430.212, z = -1088.309 }, rot = { x = 0.000, y = 300.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298012, gadget_id = 70690001, pos = { x = 985.818, y = 430.212, z = -1085.037 }, rot = { x = 0.000, y = 300.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298013, gadget_id = 70690001, pos = { x = 975.831, y = 430.212, z = -1077.322 }, rot = { x = 0.000, y = 310.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298014, gadget_id = 70690001, pos = { x = 937.229, y = 444.000, z = -1062.742 }, rot = { x = 0.000, y = 290.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298015, gadget_id = 70690011, pos = { x = 952.940, y = 420.000, z = -1058.172 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298016, gadget_id = 70690001, pos = { x = 927.391, y = 444.000, z = -1058.384 }, rot = { x = 0.000, y = 314.721, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298017, gadget_id = 70690001, pos = { x = 920.807, y = 444.000, z = -1049.673 }, rot = { x = 0.000, y = 341.688, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298018, gadget_id = 70690001, pos = { x = 916.412, y = 444.000, z = -1037.943 }, rot = { x = 25.000, y = 306.463, z = 14.279 }, level = 32, area_id = 10 },
	{ config_id = 298019, gadget_id = 70690001, pos = { x = 912.236, y = 442.034, z = -1034.019 }, rot = { x = 25.000, y = 304.987, z = 14.279 }, level = 32, area_id = 10 },
	{ config_id = 298020, gadget_id = 70690001, pos = { x = 906.629, y = 439.144, z = -1029.895 }, rot = { x = 25.000, y = 304.987, z = 14.279 }, level = 32, area_id = 10 },
	{ config_id = 298021, gadget_id = 70690001, pos = { x = 901.627, y = 436.938, z = -1025.874 }, rot = { x = 25.000, y = 304.987, z = 14.279 }, level = 32, area_id = 10 },
	{ config_id = 298022, gadget_id = 70690001, pos = { x = 894.015, y = 432.796, z = -1020.359 }, rot = { x = 5.000, y = 304.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298023, gadget_id = 70690001, pos = { x = 887.743, y = 431.541, z = -1015.846 }, rot = { x = 5.000, y = 304.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298024, gadget_id = 70690001, pos = { x = 880.406, y = 430.931, z = -1010.813 }, rot = { x = 25.000, y = 304.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298025, gadget_id = 70690001, pos = { x = 864.644, y = 422.346, z = -997.937 }, rot = { x = 10.000, y = 327.075, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298026, gadget_id = 70690001, pos = { x = 859.376, y = 420.273, z = -991.625 }, rot = { x = 20.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298027, gadget_id = 70690001, pos = { x = 854.080, y = 417.642, z = -983.797 }, rot = { x = 30.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298028, gadget_id = 70690001, pos = { x = 848.962, y = 413.717, z = -975.600 }, rot = { x = 35.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298029, gadget_id = 70690001, pos = { x = 841.151, y = 407.933, z = -965.296 }, rot = { x = 45.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298030, gadget_id = 70690001, pos = { x = 834.366, y = 398.820, z = -955.614 }, rot = { x = 45.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298031, gadget_id = 70690001, pos = { x = 828.049, y = 389.952, z = -946.284 }, rot = { x = 60.000, y = 327.000, z = 7.951 }, level = 32, area_id = 10 },
	{ config_id = 298032, gadget_id = 70690001, pos = { x = 824.927, y = 358.802, z = -937.494 }, rot = { x = 89.980, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298033, gadget_id = 70690001, pos = { x = 824.927, y = 349.962, z = -937.494 }, rot = { x = 90.000, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298034, gadget_id = 70690001, pos = { x = 824.927, y = 335.193, z = -937.494 }, rot = { x = 89.980, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298035, gadget_id = 70690001, pos = { x = 824.927, y = 324.256, z = -937.494 }, rot = { x = 90.000, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298036, gadget_id = 70690001, pos = { x = 824.927, y = 314.697, z = -937.494 }, rot = { x = 89.980, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298037, gadget_id = 70690001, pos = { x = 824.927, y = 304.360, z = -937.494 }, rot = { x = 90.000, y = 317.334, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298038, gadget_id = 70220011, pos = { x = 1110.587, y = 343.789, z = -1086.556 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, area_id = 10 },
	{ config_id = 298045, gadget_id = 70360025, pos = { x = 823.985, y = 290.701, z = -933.974 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 }
}

-- 区域
regions = {
	{ config_id = 298039, shape = RegionShape.SPHERE, radius = 25, pos = { x = 888.138, y = 290.623, z = -985.727 }, area_id = 10 },
	{ config_id = 298041, shape = RegionShape.SPHERE, radius = 3, pos = { x = 823.985, y = 290.701, z = -933.974 }, area_id = 10 },
	{ config_id = 298044, shape = RegionShape.SPHERE, radius = 30, pos = { x = 824.927, y = 306.579, z = -937.494 }, area_id = 10 }
}

-- 触发器
triggers = {
	{ config_id = 1298039, name = "ENTER_REGION_298039", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_298039", action = "action_EVENT_ENTER_REGION_298039" },
	{ config_id = 1298040, name = "ANY_GADGET_DIE_298040", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "", action = "action_EVENT_ANY_GADGET_DIE_298040" },
	{ config_id = 1298041, name = "ENTER_REGION_298041", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_298041", action = "action_EVENT_ENTER_REGION_298041", tag = "8888" },
	{ config_id = 1298042, name = "CHALLENGE_SUCCESS_298042", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "6666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_298042" },
	{ config_id = 1298043, name = "CHALLENGE_FAIL_298043", event = EventType.EVENT_CHALLENGE_FAIL, source = "6666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_298043" },
	{ config_id = 1298044, name = "ENTER_REGION_298044", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_298044", action = "action_EVENT_ENTER_REGION_298044" }
}

-- 变量
variables = {
}

-- 废弃数据
garbages = {
	triggers = {
		{ config_id = 298046, name = "GADGET_CREATE_298046", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_298046", action = "" }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 298038 },
		regions = { 298039 },
		triggers = { "ENTER_REGION_298039", "ANY_GADGET_DIE_298040" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 298001, 298002, 298003, 298004, 298005, 298006, 298007, 298008, 298009, 298010, 298011, 298012, 298013, 298014, 298015, 298016, 298017, 298018, 298019, 298020, 298021, 298022, 298023, 298024, 298025, 298026, 298027, 298028, 298029, 298030, 298031, 298032, 298033, 298034, 298035, 298036, 298037, 298045 },
		regions = { 298041, 298044 },
		triggers = { "ENTER_REGION_298041", "CHALLENGE_SUCCESS_298042", "CHALLENGE_FAIL_298043", "ENTER_REGION_298044" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_298039(context, evt)
	if evt.param1 ~= 298039 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_298039(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "4121219") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_298040(context, evt)
	-- 创建编号为6666（该挑战的识别id),挑战内容为184的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 6666, 184, 90, 4, 8888, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "4121213") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133008298, 2)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_298041(context, evt)
	if evt.param1 ~= 298041 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_298041(context, evt)
	-- 终止识别id为6666的挑战，并判定成功
		ScriptLib.StopChallenge(context, 6666, 1)
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133008298, EntityType.GADGET, 298045 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_298042(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "4121211") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_298043(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "4121299") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133008298, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_298044(context, evt)
	if evt.param1 ~= 298044 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_298044(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "4121212") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end