-- 基础信息
local base_info = {
	group_id = 133103572
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 572003, monster_id = 20011101, pos = { x = 584.111, y = 230.700, z = 1665.067 }, rot = { x = 0.000, y = 120.399, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572004, monster_id = 20011101, pos = { x = 618.352, y = 230.700, z = 1628.427 }, rot = { x = 0.000, y = 287.851, z = 0.000 }, level = 35, drop_id = 1000100, affix = { 6106 }, isElite = true, area_id = 6 },
	{ config_id = 572005, monster_id = 20011101, pos = { x = 581.694, y = 230.700, z = 1664.764 }, rot = { x = 0.000, y = 120.399, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572006, monster_id = 20011101, pos = { x = 614.942, y = 230.700, z = 1628.198 }, rot = { x = 0.000, y = 317.608, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572007, monster_id = 20011001, pos = { x = 617.231, y = 230.700, z = 1628.812 }, rot = { x = 0.000, y = 300.433, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572008, monster_id = 20011001, pos = { x = 614.438, y = 230.700, z = 1625.102 }, rot = { x = 0.000, y = 330.360, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572010, monster_id = 20011001, pos = { x = 617.209, y = 230.700, z = 1631.940 }, rot = { x = 0.000, y = 304.679, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572012, monster_id = 26060201, pos = { x = 580.310, y = 230.700, z = 1667.280 }, rot = { x = 0.000, y = 123.755, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572013, monster_id = 26060201, pos = { x = 581.720, y = 230.700, z = 1668.821 }, rot = { x = 0.000, y = 123.755, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572014, monster_id = 26060201, pos = { x = 579.547, y = 230.700, z = 1665.043 }, rot = { x = 0.000, y = 123.755, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572015, monster_id = 26060201, pos = { x = 582.606, y = 230.700, z = 1666.817 }, rot = { x = 0.000, y = 123.755, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572016, monster_id = 26060201, pos = { x = 578.861, y = 230.700, z = 1665.927 }, rot = { x = 0.000, y = 114.195, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572017, monster_id = 26060201, pos = { x = 579.709, y = 230.700, z = 1666.890 }, rot = { x = 0.000, y = 114.195, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572026, monster_id = 20010601, pos = { x = 617.363, y = 230.700, z = 1630.851 }, rot = { x = 0.000, y = 300.050, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572027, monster_id = 20010401, pos = { x = 601.667, y = 230.700, z = 1673.560 }, rot = { x = 0.000, y = 175.567, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572028, monster_id = 20010601, pos = { x = 613.596, y = 230.700, z = 1627.091 }, rot = { x = 0.000, y = 339.506, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572029, monster_id = 26010201, pos = { x = 605.724, y = 230.700, z = 1670.879 }, rot = { x = 0.000, y = 197.983, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572030, monster_id = 20010401, pos = { x = 605.245, y = 230.700, z = 1671.099 }, rot = { x = 0.000, y = 236.342, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572031, monster_id = 20011101, pos = { x = 614.145, y = 230.700, z = 1626.511 }, rot = { x = 0.000, y = 312.141, z = 0.000 }, level = 35, drop_id = 1000100, isElite = true, area_id = 6 },
	{ config_id = 572033, monster_id = 26010201, pos = { x = 603.685, y = 230.700, z = 1671.528 }, rot = { x = 0.000, y = 197.983, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572034, monster_id = 26010201, pos = { x = 582.404, y = 230.700, z = 1666.294 }, rot = { x = 0.000, y = 117.400, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572036, monster_id = 26010201, pos = { x = 583.115, y = 230.700, z = 1662.502 }, rot = { x = 0.000, y = 117.400, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572038, monster_id = 26010201, pos = { x = 609.782, y = 230.700, z = 1633.028 }, rot = { x = 0.000, y = 303.266, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572042, monster_id = 26010201, pos = { x = 599.818, y = 230.700, z = 1673.934 }, rot = { x = 0.000, y = 150.874, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572043, monster_id = 26010201, pos = { x = 604.633, y = 230.700, z = 1669.176 }, rot = { x = 0.000, y = 180.201, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 },
	{ config_id = 572045, monster_id = 26010201, pos = { x = 601.882, y = 230.700, z = 1670.742 }, rot = { x = 0.000, y = 167.196, z = 0.000 }, level = 35, drop_id = 1000100, area_id = 6 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 572001, gadget_id = 70350087, pos = { x = 602.636, y = 230.452, z = 1650.535 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 35, area_id = 6 },
	{ config_id = 572021, gadget_id = 70350086, pos = { x = 602.545, y = 230.700, z = 1650.565 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 35, area_id = 6 },
	{ config_id = 572040, gadget_id = 70300118, pos = { x = 602.636, y = 232.237, z = 1650.535 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	{ config_id = 1572002, name = "ANY_MONSTER_DIE_572002", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572002", action = "action_EVENT_ANY_MONSTER_DIE_572002", trigger_count = 0 },
	{ config_id = 1572018, name = "GADGET_CREATE_572018", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_572018", action = "action_EVENT_GADGET_CREATE_572018", trigger_count = 0 },
	{ config_id = 1572019, name = "SELECT_OPTION_572019", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_572019", action = "action_EVENT_SELECT_OPTION_572019", trigger_count = 0 },
	{ config_id = 1572020, name = "ANY_MONSTER_LIVE_572020", event = EventType.EVENT_ANY_MONSTER_LIVE, source = "", condition = "condition_EVENT_ANY_MONSTER_LIVE_572020", action = "action_EVENT_ANY_MONSTER_LIVE_572020", trigger_count = 0 },
	{ config_id = 1572022, name = "ANY_MONSTER_DIE_572022", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572022", action = "action_EVENT_ANY_MONSTER_DIE_572022", trigger_count = 0 },
	{ config_id = 1572023, name = "CHALLENGE_FAIL_572023", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_572023", trigger_count = 0 },
	{ config_id = 1572024, name = "CHALLENGE_SUCCESS_572024", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_572024", trigger_count = 0 },
	{ config_id = 1572025, name = "ANY_MONSTER_DIE_572025", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572025", action = "action_EVENT_ANY_MONSTER_DIE_572025", trigger_count = 0 },
	{ config_id = 1572035, name = "ANY_MONSTER_DIE_572035", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572035", action = "action_EVENT_ANY_MONSTER_DIE_572035", trigger_count = 0 },
	{ config_id = 1572039, name = "ANY_MONSTER_DIE_572039", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572039", action = "action_EVENT_ANY_MONSTER_DIE_572039" },
	{ config_id = 1572041, name = "SELECT_OPTION_572041", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_572041", action = "action_EVENT_SELECT_OPTION_572041", trigger_count = 0 },
	{ config_id = 1572046, name = "ANY_MONSTER_DIE_572046", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_572046", action = "action_EVENT_ANY_MONSTER_DIE_572046" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 2,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 572001, 572040 },
		regions = { },
		triggers = { "GADGET_CREATE_572018", "SELECT_OPTION_572019", "CHALLENGE_FAIL_572023", "CHALLENGE_SUCCESS_572024", "SELECT_OPTION_572041" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { 572006, 572007, 572008, 572010 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_LIVE_572020", "ANY_MONSTER_DIE_572022" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { 572003, 572004, 572005, 572031 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_572002" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { 572012, 572013, 572014, 572015, 572016, 572017 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_572025" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { 572026, 572027, 572028, 572030 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_572035" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = ,
		monsters = { },
		gadgets = { 572021 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { 572042, 572043, 572045 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_572046" },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = ,
		monsters = { 572029, 572033, 572034, 572036, 572038 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_572039" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572002(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572002(context, evt)
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 4)
	
	-- 添加suite9的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 9)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_572018(context, evt)
	if 572001 ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_572018(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133103572, 572001, {2902}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_572019(context, evt)
	-- 判断是gadgetid 572001 option_id 2902
	if 572001 ~= evt.param1 then
		return false	
	end
	
	if 2902 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_572019(context, evt)
	-- 将configid为 572001 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 572001, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 3)
	
	-- 删除指定group： 133103572 ；指定config：572001；物件身上指定option：2902；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133103572, 572001, 2902) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103572, EntityType.GADGET, 572040 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_LIVE_572020(context, evt)
	if 572006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_LIVE_572020(context, evt)
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 7)
	
	-- 创建编号为666（该挑战的识别id),挑战内容为222的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 222, 133103572, 26, 572021, 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572022(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572022(context, evt)
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 3)
	
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 8)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_572023(context, evt)
	-- 将configid为 572001 的物件更改为状态 GadgetState.GearAction2
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 572001, GadgetState.GearAction2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 3)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 5)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133103572, 6)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 7)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 8)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 9)
	
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133103572, 572001, {2902}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	-- 创建id为572040的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 572040 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 将本组内变量名为 "challenge2" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValueByGroup(context, "challenge2", 1, 133103578) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable_by_group")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_572024(context, evt)
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 3)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 5)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133103572, 6)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 7)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 8)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 9)
	
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将configid为 572001 的物件更改为状态 GadgetState.GearAction1
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 572001, GadgetState.GearAction1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1331035721") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572025(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572025(context, evt)
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 5)
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572035(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572035(context, evt)
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 6)
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572039(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572039(context, evt)
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 9)
	
	-- 终止识别id为666的挑战，并判定成功
		ScriptLib.StopChallenge(context, 666, 1)
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_572041(context, evt)
	-- 判断是gadgetid 572001 option_id 2902
	if 572001 ~= evt.param1 then
		return false	
	end
	
	if 2902 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_572041(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=600,y=230,z=1651}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021011, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1331035723") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_572046(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_572046(context, evt)
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103572, 8)
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103572, 5)
	
	return 0
end