-- 基础信息
local base_info = {
	group_id = 133103579
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 579001, gadget_id = 70690006, pos = { x = 1015.026, y = 319.813, z = 1559.970 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑1
	{ config_id = 579002, gadget_id = 70900009, pos = { x = 919.649, y = 352.031, z = 1528.088 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标1
	{ config_id = 579003, gadget_id = 70900201, pos = { x = 919.653, y = 354.047, z = 1528.146 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579004, gadget_id = 70310020, pos = { x = 918.878, y = 344.091, z = 1550.131 }, rot = { x = 0.000, y = 336.140, z = 0.000 }, level = 24, route_id = 310300205, start_route = false, area_id = 6 },
	-- 方碑2
	{ config_id = 579005, gadget_id = 70900064, pos = { x = 918.362, y = 344.790, z = 1551.236 }, rot = { x = 0.000, y = 341.933, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标2
	{ config_id = 579006, gadget_id = 70900201, pos = { x = 918.436, y = 346.577, z = 1551.201 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑3
	{ config_id = 579007, gadget_id = 70900009, pos = { x = 949.603, y = 370.850, z = 1647.549 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标3
	{ config_id = 579008, gadget_id = 70900201, pos = { x = 949.675, y = 372.728, z = 1647.540 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579009, gadget_id = 70690001, pos = { x = 924.821, y = 317.982, z = 1687.830 }, rot = { x = 0.000, y = 333.814, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579010, gadget_id = 70690001, pos = { x = 927.744, y = 318.917, z = 1681.886 }, rot = { x = 0.000, y = 333.814, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579011, gadget_id = 70690001, pos = { x = 941.059, y = 363.955, z = 1599.202 }, rot = { x = 27.107, y = 357.642, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579012, gadget_id = 70690001, pos = { x = 920.853, y = 317.282, z = 1695.899 }, rot = { x = 0.000, y = 333.814, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579013, gadget_id = 70310013, pos = { x = 746.760, y = 407.111, z = 1815.105 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579014, gadget_id = 70690001, pos = { x = 940.249, y = 353.884, z = 1618.860 }, rot = { x = 27.107, y = 357.642, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579015, gadget_id = 70360046, pos = { x = 936.201, y = 321.419, z = 1672.499 }, rot = { x = 0.000, y = 18.529, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑4
	{ config_id = 579016, gadget_id = 70900009, pos = { x = 936.166, y = 322.261, z = 1673.229 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标4
	{ config_id = 579017, gadget_id = 70900201, pos = { x = 936.030, y = 324.026, z = 1673.303 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579018, gadget_id = 70360046, pos = { x = 902.319, y = 297.229, z = 1735.805 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑5
	{ config_id = 579019, gadget_id = 70900009, pos = { x = 902.641, y = 298.104, z = 1735.652 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标5
	{ config_id = 579020, gadget_id = 70900201, pos = { x = 902.645, y = 299.937, z = 1735.650 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579021, gadget_id = 70690006, pos = { x = 907.282, y = 300.066, z = 1719.939 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579022, gadget_id = 70360046, pos = { x = 913.922, y = 340.980, z = 1715.350 }, rot = { x = 0.000, y = 29.885, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579023, gadget_id = 70360046, pos = { x = 913.997, y = 340.980, z = 1721.972 }, rot = { x = 0.000, y = 342.593, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579024, gadget_id = 70360046, pos = { x = 909.904, y = 340.980, z = 1727.158 }, rot = { x = 0.000, y = 307.478, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579025, gadget_id = 70360046, pos = { x = 902.796, y = 340.980, z = 1727.640 }, rot = { x = 0.000, y = 271.583, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579026, gadget_id = 70360046, pos = { x = 897.853, y = 340.980, z = 1722.745 }, rot = { x = 0.000, y = 221.168, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579027, gadget_id = 70360046, pos = { x = 897.845, y = 340.980, z = 1715.987 }, rot = { x = 0.000, y = 169.930, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579028, gadget_id = 70360046, pos = { x = 902.426, y = 340.980, z = 1711.264 }, rot = { x = 0.000, y = 118.409, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579029, gadget_id = 70360046, pos = { x = 909.167, y = 340.980, z = 1710.880 }, rot = { x = 0.000, y = 78.025, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑6
	{ config_id = 579030, gadget_id = 70900009, pos = { x = 873.858, y = 358.382, z = 1669.279 }, rot = { x = 0.000, y = 305.371, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标6
	{ config_id = 579031, gadget_id = 70900201, pos = { x = 874.044, y = 360.279, z = 1669.424 }, rot = { x = 0.000, y = 345.191, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑7
	{ config_id = 579032, gadget_id = 70900009, pos = { x = 953.758, y = 351.008, z = 1741.522 }, rot = { x = 0.000, y = 342.585, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标7
	{ config_id = 579033, gadget_id = 70900201, pos = { x = 953.818, y = 352.757, z = 1741.490 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579034, gadget_id = 70350061, pos = { x = 885.050, y = 343.863, z = 1732.874 }, rot = { x = 308.357, y = 128.499, z = 178.314 }, level = 24, area_id = 6 },
	{ config_id = 579035, gadget_id = 70350061, pos = { x = 864.603, y = 347.522, z = 1748.296 }, rot = { x = 305.228, y = 128.658, z = 178.187 }, level = 24, area_id = 6 },
	{ config_id = 579036, gadget_id = 70310020, pos = { x = 819.861, y = 351.594, z = 1777.275 }, rot = { x = 0.000, y = 28.503, z = 0.000 }, level = 24, route_id = 310300206, area_id = 6 },
	-- 方碑8
	{ config_id = 579037, gadget_id = 70900064, pos = { x = 820.281, y = 352.163, z = 1777.158 }, rot = { x = 0.000, y = 25.106, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579038, gadget_id = 70690010, pos = { x = 846.858, y = 339.501, z = 1763.827 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579039, gadget_id = 70690001, pos = { x = 846.994, y = 382.230, z = 1763.945 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579040, gadget_id = 70690001, pos = { x = 846.994, y = 390.285, z = 1763.945 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑9
	{ config_id = 579041, gadget_id = 70900064, pos = { x = 755.578, y = 394.471, z = 1789.618 }, rot = { x = 0.000, y = 83.909, z = 0.000 }, level = 24, area_id = 6 },
	-- 方碑10
	{ config_id = 579042, gadget_id = 70900009, pos = { x = 662.925, y = 439.762, z = 1844.099 }, rot = { x = 0.000, y = 319.043, z = 0.000 }, level = 24, area_id = 6 },
	-- 目标10
	{ config_id = 579043, gadget_id = 70900201, pos = { x = 662.994, y = 441.568, z = 1844.154 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579044, gadget_id = 70690006, pos = { x = 751.940, y = 386.357, z = 1810.954 }, rot = { x = 0.000, y = 290.987, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579045, gadget_id = 70310013, pos = { x = 770.797, y = 404.996, z = 1797.288 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579046, gadget_id = 70310013, pos = { x = 766.079, y = 405.591, z = 1800.785 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579047, gadget_id = 70310013, pos = { x = 761.251, y = 406.121, z = 1804.364 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579048, gadget_id = 70310013, pos = { x = 756.372, y = 406.554, z = 1807.980 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579049, gadget_id = 70310013, pos = { x = 751.662, y = 406.914, z = 1811.471 }, rot = { x = 0.000, y = 36.546, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579050, gadget_id = 70690006, pos = { x = 907.282, y = 309.718, z = 1719.939 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 24, area_id = 6 },
	{ config_id = 579051, gadget_id = 70690001, pos = { x = 1008.005, y = 351.096, z = 1562.524 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579052, gadget_id = 70690001, pos = { x = 997.598, y = 351.096, z = 1558.820 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579053, gadget_id = 70690001, pos = { x = 986.742, y = 351.096, z = 1554.957 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579054, gadget_id = 70690001, pos = { x = 972.252, y = 351.096, z = 1549.800 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579055, gadget_id = 70690001, pos = { x = 957.146, y = 351.096, z = 1544.424 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579056, gadget_id = 70690001, pos = { x = 946.084, y = 351.096, z = 1540.487 }, rot = { x = 0.000, y = 250.411, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 579057, gadget_id = 70310020, pos = { x = 755.610, y = 393.878, z = 1789.736 }, rot = { x = 0.000, y = 34.855, z = 0.000 }, level = 1, route_id = 310300216, area_id = 6 }
}

-- 区域
regions = {
	{ config_id = 579058, shape = RegionShape.SPHERE, radius = 15.9, pos = { x = 937.020, y = 328.152, z = 1650.983 }, area_id = 6 }
}

-- 触发器
triggers = {
	{ config_id = 1579058, name = "ENTER_REGION_579058", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_579058", action = "action_EVENT_ENTER_REGION_579058" },
	{ config_id = 1579059, name = "QUEST_FINISH_579059", event = EventType.EVENT_QUEST_FINISH, source = "1103004", condition = "", action = "action_EVENT_QUEST_FINISH_579059", trigger_count = 0 },
	{ config_id = 1579060, name = "GADGET_CREATE_579060", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_579060", action = "action_EVENT_GADGET_CREATE_579060", trigger_count = 0 },
	{ config_id = 1579061, name = "TIMER_EVENT_579061", event = EventType.EVENT_TIMER_EVENT, source = "platform1", condition = "", action = "action_EVENT_TIMER_EVENT_579061", trigger_count = 0 },
	{ config_id = 1579062, name = "GADGET_CREATE_579062", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_579062", action = "action_EVENT_GADGET_CREATE_579062", trigger_count = 0 },
	{ config_id = 1579063, name = "TIMER_EVENT_579063", event = EventType.EVENT_TIMER_EVENT, source = "platform2", condition = "", action = "action_EVENT_TIMER_EVENT_579063", trigger_count = 0 },
	{ config_id = 1579064, name = "GADGET_STATE_CHANGE_579064", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579064", action = "action_EVENT_GADGET_STATE_CHANGE_579064", tag = "666" },
	{ config_id = 1579065, name = "GADGET_STATE_CHANGE_579065", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579065", action = "action_EVENT_GADGET_STATE_CHANGE_579065", tag = "666" },
	{ config_id = 1579066, name = "GADGET_STATE_CHANGE_579066", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579066", action = "action_EVENT_GADGET_STATE_CHANGE_579066", tag = "666" },
	{ config_id = 1579067, name = "VARIABLE_CHANGE_579067", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579067", action = "action_EVENT_VARIABLE_CHANGE_579067" },
	{ config_id = 1579068, name = "GADGET_STATE_CHANGE_579068", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579068", action = "action_EVENT_GADGET_STATE_CHANGE_579068", tag = "666" },
	{ config_id = 1579069, name = "GADGET_STATE_CHANGE_579069", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579069", action = "action_EVENT_GADGET_STATE_CHANGE_579069", tag = "666" },
	{ config_id = 1579070, name = "VARIABLE_CHANGE_579070", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579070", action = "action_EVENT_VARIABLE_CHANGE_579070" },
	{ config_id = 1579071, name = "GADGET_STATE_CHANGE_579071", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579071", action = "action_EVENT_GADGET_STATE_CHANGE_579071", tag = "666" },
	{ config_id = 1579072, name = "GADGET_STATE_CHANGE_579072", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579072", action = "action_EVENT_GADGET_STATE_CHANGE_579072", tag = "666" },
	{ config_id = 1579073, name = "VARIABLE_CHANGE_579073", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579073", action = "action_EVENT_VARIABLE_CHANGE_579073" },
	{ config_id = 1579074, name = "VARIABLE_CHANGE_579074", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579074", action = "action_EVENT_VARIABLE_CHANGE_579074" },
	{ config_id = 1579075, name = "GADGET_STATE_CHANGE_579075", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579075", action = "action_EVENT_GADGET_STATE_CHANGE_579075", tag = "666" },
	{ config_id = 1579076, name = "GADGET_STATE_CHANGE_579076", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579076", action = "action_EVENT_GADGET_STATE_CHANGE_579076", tag = "666" },
	{ config_id = 1579077, name = "GADGET_STATE_CHANGE_579077", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_579077", action = "action_EVENT_GADGET_STATE_CHANGE_579077", tag = "666" },
	{ config_id = 1579078, name = "VARIABLE_CHANGE_579078", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579078", action = "action_EVENT_VARIABLE_CHANGE_579078" },
	{ config_id = 1579079, name = "CHALLENGE_SUCCESS_579079", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_579079", trigger_count = 0 },
	{ config_id = 1579080, name = "CHALLENGE_FAIL_579080", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_579080", trigger_count = 0 },
	{ config_id = 1579081, name = "QUEST_FINISH_579081", event = EventType.EVENT_QUEST_FINISH, source = "1103010", condition = "", action = "action_EVENT_QUEST_FINISH_579081", trigger_count = 0 },
	{ config_id = 1579082, name = "VARIABLE_CHANGE_579082", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_579082", action = "action_EVENT_VARIABLE_CHANGE_579082" }
}

-- 变量
variables = {
	{ config_id = 1, name = "group1", value = 0, no_refresh = false },
	{ config_id = 2, name = "group2", value = 0, no_refresh = false },
	{ config_id = 3, name = "group3", value = 0, no_refresh = false },
	{ config_id = 4, name = "bridge1", value = 0, no_refresh = false },
	{ config_id = 5, name = "group4", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 2,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 初始空suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "QUEST_FINISH_579059", "CHALLENGE_SUCCESS_579079", "CHALLENGE_FAIL_579080", "QUEST_FINISH_579081" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 579001, 579002, 579003, 579004, 579005, 579006, 579007, 579008, 579051, 579052, 579053, 579054, 579055, 579056 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_579064", "GADGET_STATE_CHANGE_579065", "GADGET_STATE_CHANGE_579066", "VARIABLE_CHANGE_579067" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 579045, 579047, 579049 },
		regions = { },
		triggers = { "GADGET_CREATE_579060", "TIMER_EVENT_579061" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "GADGET_CREATE_579062", "TIMER_EVENT_579063" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { },
		gadgets = { 579011, 579014, 579015, 579016, 579017, 579018, 579019, 579020 },
		regions = { 579058 },
		triggers = { "ENTER_REGION_579058", "GADGET_STATE_CHANGE_579068", "GADGET_STATE_CHANGE_579069", "VARIABLE_CHANGE_579070" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = ,
		monsters = { },
		gadgets = { 579021, 579022, 579023, 579024, 579025, 579026, 579027, 579028, 579029, 579030, 579031, 579032, 579033, 579034, 579035, 579050 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_579071", "GADGET_STATE_CHANGE_579072", "VARIABLE_CHANGE_579073", "VARIABLE_CHANGE_579074", "VARIABLE_CHANGE_579082" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { },
		gadgets = { 579036, 579037, 579039, 579040, 579041, 579042, 579043, 579057 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_579075", "GADGET_STATE_CHANGE_579076", "GADGET_STATE_CHANGE_579077", "VARIABLE_CHANGE_579078" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_579058(context, evt)
	if evt.param1 ~= 579058 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	-- 判断变量"challenge1"为0
	if ScriptLib.GetGroupVariableValueByGroup(context, "challenge1", 133103578) ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_579058(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=937,y=328,z=1651}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021008, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_579059(context, evt)
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_579060(context, evt)
	if 579045 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_579060(context, evt)
	-- 延迟3.5秒后,向groupId为：133103571的对象,请求一次调用,并将string参数："platform1" 传递过去
	if 0 ~= ScriptLib.CreateGroupTimerEvent(context, 133103571, "platform1", 3.5) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_timerevent_by_group")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_TIMER_EVENT_579061(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579045 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579047 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579049 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 创建id为579046的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579046 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579048的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579048 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579013的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579013 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_579062(context, evt)
	if 579046 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_579062(context, evt)
	-- 延迟3.5秒后,向groupId为：133103571的对象,请求一次调用,并将string参数："platform2" 传递过去
	if 0 ~= ScriptLib.CreateGroupTimerEvent(context, 133103571, "platform2", 3.5) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_timerevent_by_group")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_TIMER_EVENT_579063(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579046 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579048 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 创建id为579045的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579045 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579047的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579047 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579049的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579049 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579064(context, evt)
	if 579002 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579064(context, evt)
	-- 针对当前group内变量名为 "group1" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group1", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579003 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579065(context, evt)
	if 579005 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579065(context, evt)
	-- 针对当前group内变量名为 "group1" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group1", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579006 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 579004) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579066(context, evt)
	if 579007 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579066(context, evt)
	-- 针对当前group内变量名为 "group1" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group1", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579008 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579067(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"group1"为3
	if ScriptLib.GetGroupVariableValue(context, "group1") ~= 3 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579067(context, evt)
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 6)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579045 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579046 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579047 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579048 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579049 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 571059 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 571060 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 571061 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579068(context, evt)
	if 579016 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579068(context, evt)
	-- 创建id为579009的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579009 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579010的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579010 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 创建id为579012的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579012 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579017 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 针对当前group内变量名为 "group2" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group2", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 针对当前group内变量名为 "bridge" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "bridge", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579069(context, evt)
	if 579019 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579069(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579020 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 针对当前group内变量名为 "group2" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group2", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 针对当前group内变量名为 "bridge" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "bridge", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579070(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"group2"为2
	if ScriptLib.GetGroupVariableValue(context, "group2") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579070(context, evt)
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 3)
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 7)
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579009 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579010 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579012 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579071(context, evt)
	if 579032 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579071(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579033 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 针对当前group内变量名为 "group3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 针对当前group内变量名为 "bridge1" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "bridge1", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579072(context, evt)
	if 579030 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579072(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579031 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 针对当前group内变量名为 "group3" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group3", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 针对当前group内变量名为 "bridge1" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "bridge1", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579073(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"bridge1"为2
	if ScriptLib.GetGroupVariableValue(context, "bridge1") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579073(context, evt)
	-- 将configid为 579034 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 579034, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 579035 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 579035, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579074(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"group3"为2
	if ScriptLib.GetGroupVariableValue(context, "group3") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579074(context, evt)
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 6)
	
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 8)
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 4)
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103571, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579075(context, evt)
	if 579037 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579075(context, evt)
	-- 将configid为 579036 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 579036, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为579038的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579038 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 针对当前group内变量名为 "group4" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group4", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 7)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579076(context, evt)
	if 579041 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579076(context, evt)
	-- 创建id为579044的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 579044 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 针对当前group内变量名为 "group4" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group4", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 将configid为 579057 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 579057, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_579077(context, evt)
	if 579042 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_579077(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579043 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 针对当前group内变量名为 "group4" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "group4", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579078(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"group4"为3
	if ScriptLib.GetGroupVariableValue(context, "group4") ~= 3 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579078(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133103571, EntityType.GADGET, 579044 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 7)
	
	-- 终止识别id为888的挑战，并判定成功
		ScriptLib.StopChallenge(context, 888, 1)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103571, 5)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579046 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 579048 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_579079(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1331035711") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133103571, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_579080(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1331035712") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133103571, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_579081(context, evt)
	-- 创建编号为888（该挑战的识别id),挑战内容为210的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 210, 240, 7, 666, 10) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_579082(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"bridge1"为2
	if ScriptLib.GetGroupVariableValue(context, "bridge1") ~= 2 then
			return false
	end
	
	-- 判断变量"challenge1"为0
	if ScriptLib.GetGroupVariableValueByGroup(context, "challenge1", 133103578) ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_579082(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=898,y=341,z=1722}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 31021009, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	-- 将本组内变量名为 "challenge1" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValueByGroup(context, "challenge1", 0, 133103578) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable_by_group")
	  return -1
	end
	
	return 0
end