-- 基础信息
local base_info = {
	group_id = 133103639
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 639001, monster_id = 20011201, pos = { x = 148.991, y = 185.542, z = 1276.310 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639002, monster_id = 20011201, pos = { x = 146.395, y = 185.862, z = 1270.618 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639003, monster_id = 20011301, pos = { x = 152.777, y = 185.788, z = 1270.243 }, rot = { x = 0.000, y = 199.772, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639004, monster_id = 20011101, pos = { x = 146.373, y = 185.568, z = 1274.749 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639005, monster_id = 20011001, pos = { x = 148.137, y = 186.068, z = 1268.375 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639006, monster_id = 20011001, pos = { x = 153.782, y = 185.580, z = 1272.866 }, rot = { x = 0.000, y = 158.246, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639007, monster_id = 20010501, pos = { x = 148.485, y = 186.011, z = 1268.919 }, rot = { x = 0.000, y = 279.020, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639008, monster_id = 20010501, pos = { x = 148.208, y = 185.516, z = 1274.509 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639009, monster_id = 20010601, pos = { x = 152.801, y = 185.533, z = 1273.089 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639010, monster_id = 20010901, pos = { x = 149.680, y = 185.512, z = 1275.689 }, rot = { x = 0.000, y = 74.056, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639011, monster_id = 20010801, pos = { x = 152.289, y = 185.752, z = 1270.740 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639012, monster_id = 20010801, pos = { x = 147.524, y = 185.914, z = 1270.088 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639013, monster_id = 20011401, pos = { x = 151.019, y = 185.965, z = 1268.854 }, rot = { x = 0.000, y = 236.865, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639014, monster_id = 20011501, pos = { x = 147.060, y = 185.604, z = 1272.814 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 },
	{ config_id = 639015, monster_id = 20011401, pos = { x = 151.418, y = 185.471, z = 1274.845 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 6 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 639016, gadget_id = 70690006, pos = { x = 175.126, y = 246.616, z = 1281.975 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639017, gadget_id = 70310013, pos = { x = 160.749, y = 269.684, z = 1264.225 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639018, gadget_id = 70690006, pos = { x = 143.975, y = 183.521, z = 1279.800 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639019, gadget_id = 70360025, pos = { x = 160.768, y = 270.395, z = 1264.307 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639020, gadget_id = 70350085, pos = { x = 164.097, y = 210.118, z = 1275.232 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639021, gadget_id = 70220042, pos = { x = 150.401, y = 185.484, z = 1274.647 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639022, gadget_id = 70350085, pos = { x = 160.545, y = 228.235, z = 1292.203 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639023, gadget_id = 70360001, pos = { x = 149.516, y = 186.616, z = 1272.582 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, persistent = true, area_id = 6 },
	{ config_id = 639024, gadget_id = 70350085, pos = { x = 174.546, y = 250.257, z = 1283.938 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639025, gadget_id = 70350085, pos = { x = 160.768, y = 265.842, z = 1264.307 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639026, gadget_id = 70690006, pos = { x = 159.478, y = 219.804, z = 1297.803 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639027, gadget_id = 70710126, pos = { x = 164.097, y = 210.118, z = 1275.232 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639028, gadget_id = 70710126, pos = { x = 160.545, y = 228.235, z = 1292.203 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639029, gadget_id = 70710126, pos = { x = 174.546, y = 250.257, z = 1283.938 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639030, gadget_id = 70690006, pos = { x = 169.047, y = 205.114, z = 1274.058 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639031, gadget_id = 70310013, pos = { x = 163.874, y = 209.095, z = 1275.287 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639032, gadget_id = 70310013, pos = { x = 160.417, y = 227.524, z = 1292.446 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639033, gadget_id = 70310013, pos = { x = 174.344, y = 249.546, z = 1284.146 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 6 },
	{ config_id = 639034, gadget_id = 70350083, pos = { x = 149.518, y = 185.608, z = 1272.457 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, persistent = true, area_id = 6 }
}

-- 区域
regions = {
	{ config_id = 639040, shape = RegionShape.SPHERE, radius = 2, pos = { x = 160.768, y = 270.006, z = 1264.307 }, area_id = 6 },
	{ config_id = 639041, shape = RegionShape.SPHERE, radius = 2, pos = { x = 164.186, y = 209.729, z = 1275.003 }, area_id = 6 },
	{ config_id = 639042, shape = RegionShape.SPHERE, radius = 2, pos = { x = 160.545, y = 227.846, z = 1292.203 }, area_id = 6 },
	{ config_id = 639043, shape = RegionShape.SPHERE, radius = 2, pos = { x = 174.878, y = 250.285, z = 1284.350 }, area_id = 6 }
}

-- 触发器
triggers = {
	{ config_id = 1639035, name = "GADGET_CREATE_639035", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_639035", action = "action_EVENT_GADGET_CREATE_639035", trigger_count = 0 },
	{ config_id = 1639036, name = "CHALLENGE_SUCCESS_639036", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "874", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_639036" },
	{ config_id = 1639037, name = "CHALLENGE_FAIL_639037", event = EventType.EVENT_CHALLENGE_FAIL, source = "874", condition = "", action = "action_EVENT_CHALLENGE_FAIL_639037", trigger_count = 0 },
	{ config_id = 1639038, name = "SELECT_OPTION_639038", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_639038", action = "action_EVENT_SELECT_OPTION_639038", trigger_count = 0 },
	{ config_id = 1639039, name = "GADGET_STATE_CHANGE_639039", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_639039", action = "action_EVENT_GADGET_STATE_CHANGE_639039", trigger_count = 0 },
	{ config_id = 1639040, name = "ENTER_REGION_639040", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_639040", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1639041, name = "ENTER_REGION_639041", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_639041", action = "action_EVENT_ENTER_REGION_639041" },
	{ config_id = 1639042, name = "ENTER_REGION_639042", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_639042", action = "action_EVENT_ENTER_REGION_639042" },
	{ config_id = 1639043, name = "ENTER_REGION_639043", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_639043", action = "action_EVENT_ENTER_REGION_639043" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 8,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 639023, 639034 },
		regions = { },
		triggers = { "GADGET_CREATE_639035", "CHALLENGE_SUCCESS_639036", "CHALLENGE_FAIL_639037", "SELECT_OPTION_639038" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 639017, 639019 },
		regions = { 639040 },
		triggers = { "ENTER_REGION_639040" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { 639034 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { },
		gadgets = { 639018, 639020, 639027, 639031 },
		regions = { 639041 },
		triggers = { "ENTER_REGION_639041" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { },
		gadgets = { 639022, 639028, 639030, 639032 },
		regions = { 639042 },
		triggers = { "ENTER_REGION_639042" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { },
		gadgets = { 639024, 639026, 639029, 639033 },
		regions = { 639043 },
		triggers = { "ENTER_REGION_639043" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = ,
		monsters = { },
		gadgets = { 639016, 639025 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_639039" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_CREATE_639035(context, evt)
	if 639023 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_639035(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133103639, 639023, {40}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_639036(context, evt)
	-- 将configid为 639034 的物件更改为状态 GadgetState.GearStop
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 639034, GadgetState.GearStop) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 2)
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133103639, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 7)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133103639, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_639037(context, evt)
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 2)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133103639, 7)
	
	-- 将configid为 639034 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 639034, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为639023的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 639023 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133103639, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_639038(context, evt)
	-- 判断是gadgetid 639023 option_id 40
	if 639023 ~= evt.param1 then
		return false	
	end
	
	if 40 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_639038(context, evt)
	-- 删除指定group： 133103639 ；指定config：639023；物件身上指定option：40；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133103639, 639023, 40) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639023 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 639034 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 639034, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建编号为874（该挑战的识别id),挑战内容为205的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 874, 205, 20, 4, 888, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 创建编号为1（该怪物潮的识别id)的怪物潮，创建怪物总数为15，场上怪物最少3只，最多3只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 1, 133103639, {639001,639002,639003,639005,639006,639004,639007,639008,639009,639011,639012,639010,639013,639015,639014}, 15, 3, 3) then
		return -1
	end
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_639039(context, evt)
	if 639021 ~= evt.param2 or GadgetState.ChestOpened ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_639039(context, evt)
	-- 添加suite1的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 1)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_639040(context, evt)
	if evt.param1 ~= 639040 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_639041(context, evt)
	if evt.param1 ~= 639041 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_639041(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639020 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639027 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_639042(context, evt)
	if evt.param1 ~= 639042 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_639042(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639022 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639028 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_639043(context, evt)
	if evt.param1 ~= 639043 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_639043(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639024 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 639029 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133103639, 7)
	
	return 0
end

require "TreasureMapEvent"