-- 基础信息
local base_info = {
	group_id = 133105038
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 38006, monster_id = 28020305, pos = { x = 889.152, y = 348.828, z = -786.295 }, rot = { x = 359.049, y = 348.776, z = 359.985 }, level = 1, drop_id = 1000100, ban_excel_drop = true, affix = { 5114 }, climate_area_id = 1, area_id = 10 },
	{ config_id = 38009, monster_id = 21010201, pos = { x = 902.773, y = 348.103, z = -793.910 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, climate_area_id = 1, area_id = 10 },
	{ config_id = 38010, monster_id = 21010201, pos = { x = 905.021, y = 348.949, z = -790.947 }, rot = { x = 0.000, y = 296.992, z = 0.000 }, level = 1, drop_id = 1000100, climate_area_id = 1, area_id = 10 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 38002, gadget_id = 70360102, pos = { x = 911.339, y = 347.973, z = -795.759 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38003, gadget_id = 70310082, pos = { x = 1094.688, y = 412.967, z = -708.565 }, rot = { x = 348.610, y = 113.754, z = 359.246 }, level = 1, area_id = 10 },
	{ config_id = 38005, gadget_id = 70350004, pos = { x = 891.607, y = 349.091, z = -786.141 }, rot = { x = 0.000, y = 258.185, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38007, gadget_id = 70350004, pos = { x = 885.312, y = 348.828, z = -785.928 }, rot = { x = 0.000, y = 284.933, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38008, gadget_id = 70360005, pos = { x = 911.310, y = 347.964, z = -795.912 }, rot = { x = 347.777, y = 359.142, z = 8.005 }, level = 1, area_id = 10 },
	{ config_id = 38014, gadget_id = 70310082, pos = { x = 923.874, y = 363.199, z = -768.424 }, rot = { x = 328.201, y = 23.622, z = 352.667 }, level = 1, area_id = 10 },
	{ config_id = 38017, gadget_id = 70310089, pos = { x = 1077.716, y = 408.783, z = -703.488 }, rot = { x = 356.504, y = 101.786, z = 357.569 }, level = 1, area_id = 10 },
	{ config_id = 38018, gadget_id = 70310082, pos = { x = 900.737, y = 349.605, z = -790.659 }, rot = { x = 0.000, y = 147.378, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38019, gadget_id = 70310082, pos = { x = 893.858, y = 350.279, z = -786.473 }, rot = { x = 0.000, y = 85.378, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38020, gadget_id = 70310082, pos = { x = 944.772, y = 365.653, z = -689.321 }, rot = { x = 14.170, y = 351.204, z = 1.694 }, level = 1, area_id = 10 },
	{ config_id = 38021, gadget_id = 70310089, pos = { x = 1032.896, y = 392.937, z = -692.225 }, rot = { x = 335.985, y = 109.893, z = 359.180 }, level = 1, area_id = 10 },
	{ config_id = 38022, gadget_id = 70310082, pos = { x = 996.764, y = 378.826, z = -683.539 }, rot = { x = 341.100, y = 109.898, z = 1.205 }, level = 1, area_id = 10 },
	{ config_id = 38023, gadget_id = 70310082, pos = { x = 975.228, y = 370.032, z = -675.196 }, rot = { x = 345.234, y = 115.562, z = 15.250 }, level = 1, area_id = 10 },
	{ config_id = 38024, gadget_id = 70310082, pos = { x = 952.598, y = 358.564, z = -664.966 }, rot = { x = 343.688, y = 92.689, z = 4.053 }, level = 1, area_id = 10 },
	{ config_id = 38025, gadget_id = 70310082, pos = { x = 941.741, y = 357.994, z = -669.255 }, rot = { x = 17.702, y = 351.313, z = 1.724 }, level = 1, area_id = 10 },
	{ config_id = 38026, gadget_id = 70310082, pos = { x = 947.559, y = 366.512, z = -716.130 }, rot = { x = 0.000, y = 355.815, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38027, gadget_id = 70310082, pos = { x = 927.292, y = 367.485, z = -757.687 }, rot = { x = 346.425, y = 18.267, z = 350.865 }, level = 1, area_id = 10 },
	{ config_id = 38028, gadget_id = 70310082, pos = { x = 922.569, y = 354.254, z = -786.707 }, rot = { x = 335.271, y = 30.700, z = 354.538 }, level = 1, area_id = 10 },
	{ config_id = 38030, gadget_id = 70310082, pos = { x = 905.668, y = 348.780, z = -796.366 }, rot = { x = 0.000, y = 129.602, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38032, gadget_id = 70310082, pos = { x = 918.177, y = 349.603, z = -796.330 }, rot = { x = 0.000, y = 274.841, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38033, gadget_id = 70310082, pos = { x = 916.656, y = 351.032, z = -792.530 }, rot = { x = 343.299, y = 59.368, z = 344.484 }, level = 1, area_id = 10 },
	{ config_id = 38044, gadget_id = 70310082, pos = { x = 919.374, y = 349.450, z = -802.057 }, rot = { x = 350.293, y = 45.753, z = 357.268 }, level = 1, area_id = 10 },
	{ config_id = 38045, gadget_id = 70310082, pos = { x = 912.211, y = 348.057, z = -801.757 }, rot = { x = 0.000, y = 118.580, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38046, gadget_id = 70310082, pos = { x = 940.623, y = 367.069, z = -738.807 }, rot = { x = 0.000, y = 28.768, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38048, gadget_id = 70310015, pos = { x = 903.812, y = 347.678, z = -798.714 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, state = GadgetState.GearStart, area_id = 10 },
	{ config_id = 38049, gadget_id = 70360005, pos = { x = 922.823, y = 348.990, z = -798.958 }, rot = { x = 340.040, y = 0.516, z = 21.480 }, level = 1, area_id = 10 },
	{ config_id = 38050, gadget_id = 70360102, pos = { x = 920.923, y = 351.935, z = -789.268 }, rot = { x = 339.823, y = 5.052, z = 5.989 }, level = 1, area_id = 10 },
	{ config_id = 38051, gadget_id = 70360005, pos = { x = 898.624, y = 349.348, z = -786.654 }, rot = { x = 342.780, y = 0.000, z = 13.527 }, level = 1, area_id = 10 },
	{ config_id = 38052, gadget_id = 70360102, pos = { x = 922.814, y = 349.112, z = -798.412 }, rot = { x = 330.090, y = 0.002, z = 28.398 }, level = 1, area_id = 10 },
	{ config_id = 38053, gadget_id = 70360005, pos = { x = 920.857, y = 351.847, z = -789.409 }, rot = { x = 337.896, y = 356.913, z = 15.710 }, level = 1, area_id = 10 },
	{ config_id = 38054, gadget_id = 70360102, pos = { x = 898.405, y = 349.536, z = -786.182 }, rot = { x = 348.759, y = 352.792, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38055, gadget_id = 70310015, pos = { x = 1090.431, y = 409.612, z = -710.249 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, state = GadgetState.GearStart, area_id = 10 },
	{ config_id = 38056, gadget_id = 70310015, pos = { x = 1091.064, y = 408.357, z = -700.559 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, state = GadgetState.GearStart, area_id = 10 },
	{ config_id = 38057, gadget_id = 70310015, pos = { x = 1103.639, y = 411.330, z = -710.184 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, state = GadgetState.GearStart, area_id = 10 },
	{ config_id = 38059, gadget_id = 70230002, pos = { x = 901.771, y = 350.567, z = -798.989 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38060, gadget_id = 70230002, pos = { x = 901.126, y = 350.632, z = -798.564 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38061, gadget_id = 70230002, pos = { x = 900.460, y = 350.712, z = -797.658 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38062, gadget_id = 70230002, pos = { x = 899.864, y = 350.793, z = -797.217 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 10 },
	{ config_id = 38064, gadget_id = 70310015, pos = { x = 1101.567, y = 410.174, z = -698.649 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, state = GadgetState.GearStart, area_id = 10 },
	{ config_id = 38068, gadget_id = 70710501, pos = { x = 889.152, y = 348.828, z = -786.295 }, rot = { x = 359.049, y = 348.776, z = 359.985 }, level = 1, area_id = 10 }
}

-- 区域
regions = {
	-- 原来这里是来源reminder
	{ config_id = 38029, shape = RegionShape.SPHERE, radius = 5, pos = { x = 893.908, y = 348.862, z = -786.619 }, area_id = 10 },
	-- 气味乱了reminder
	{ config_id = 38047, shape = RegionShape.SPHERE, radius = 8, pos = { x = 919.859, y = 349.834, z = -793.085 }, area_id = 10 }
}

-- 触发器
triggers = {
	-- 第一个重压板 set t=1 c=1
	{ config_id = 1038011, name = "GADGET_STATE_CHANGE_38011", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38011", action = "action_EVENT_GADGET_STATE_CHANGE_38011", trigger_count = 0 },
	{ config_id = 1038012, name = "QUEST_FINISH_38012", event = EventType.EVENT_QUEST_FINISH, source = "7050001", condition = "", action = "action_EVENT_QUEST_FINISH_38012", trigger_count = 0 },
	{ config_id = 1038013, name = "QUEST_FINISH_38013", event = EventType.EVENT_QUEST_FINISH, source = "7050003", condition = "", action = "action_EVENT_QUEST_FINISH_38013", trigger_count = 0 },
	-- 第二个重压板 t+1
	{ config_id = 1038015, name = "GADGET_STATE_CHANGE_38015", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38015", action = "action_EVENT_GADGET_STATE_CHANGE_38015", trigger_count = 0 },
	-- 第三个重压板 t+1
	{ config_id = 1038016, name = "GADGET_STATE_CHANGE_38016", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38016", action = "action_EVENT_GADGET_STATE_CHANGE_38016", trigger_count = 0 },
	-- 原来这里是来源reminder
	{ config_id = 1038029, name = "ENTER_REGION_38029", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_38029", action = "action_EVENT_ENTER_REGION_38029" },
	-- 第四个重压板 t+1
	{ config_id = 1038031, name = "GADGET_STATE_CHANGE_38031", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38031", action = "action_EVENT_GADGET_STATE_CHANGE_38031", trigger_count = 0 },
	{ config_id = 1038034, name = "QUEST_START_38034", event = EventType.EVENT_QUEST_START, source = "7050002", condition = "", action = "action_EVENT_QUEST_START_38034", trigger_count = 0 },
	{ config_id = 1038035, name = "ANY_GADGET_DIE_38035", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_38035", action = "action_EVENT_ANY_GADGET_DIE_38035", trigger_count = 0 },
	-- 第二个重压板 c+1
	{ config_id = 1038036, name = "GADGET_STATE_CHANGE_38036", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38036", action = "action_EVENT_GADGET_STATE_CHANGE_38036", trigger_count = 0 },
	-- 第三个重压板 c+1
	{ config_id = 1038037, name = "GADGET_STATE_CHANGE_38037", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38037", action = "action_EVENT_GADGET_STATE_CHANGE_38037", trigger_count = 0 },
	-- 第四个重压板 c+1
	{ config_id = 1038038, name = "GADGET_STATE_CHANGE_38038", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38038", action = "action_EVENT_GADGET_STATE_CHANGE_38038", trigger_count = 0 },
	{ config_id = 1038039, name = "ANY_GADGET_DIE_38039", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_38039", action = "action_EVENT_ANY_GADGET_DIE_38039", trigger_count = 0 },
	{ config_id = 1038040, name = "ANY_GADGET_DIE_38040", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_38040", action = "action_EVENT_ANY_GADGET_DIE_38040", trigger_count = 0 },
	{ config_id = 1038041, name = "ANY_GADGET_DIE_38041", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_38041", action = "action_EVENT_ANY_GADGET_DIE_38041", trigger_count = 0 },
	-- 顺序对开门
	{ config_id = 1038042, name = "VARIABLE_CHANGE_38042", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_38042", action = "action_EVENT_VARIABLE_CHANGE_38042", trigger_count = 0 },
	-- 顺序错误重置
	{ config_id = 1038043, name = "VARIABLE_CHANGE_38043", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_38043", action = "action_EVENT_VARIABLE_CHANGE_38043", trigger_count = 0 },
	-- 气味乱了reminder
	{ config_id = 1038047, name = "ENTER_REGION_38047", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_38047", action = "action_EVENT_ENTER_REGION_38047" },
	-- 击杀猪完成任务
	{ config_id = 1038058, name = "ANY_MONSTER_DIE_38058", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_38058", action = "action_EVENT_ANY_MONSTER_DIE_38058", trigger_count = 0 },
	-- 第一个重压板 镜头
	{ config_id = 1038063, name = "GADGET_STATE_CHANGE_38063", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38063", action = "action_EVENT_GADGET_STATE_CHANGE_38063" },
	-- 第二个重压板 镜头
	{ config_id = 1038065, name = "GADGET_STATE_CHANGE_38065", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38065", action = "action_EVENT_GADGET_STATE_CHANGE_38065" },
	-- 第三个重压板 镜头
	{ config_id = 1038066, name = "GADGET_STATE_CHANGE_38066", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38066", action = "action_EVENT_GADGET_STATE_CHANGE_38066" },
	-- 第四个重压板 镜头
	{ config_id = 1038067, name = "GADGET_STATE_CHANGE_38067", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_38067", action = "action_EVENT_GADGET_STATE_CHANGE_38067" }
}

-- 变量
variables = {
	{ config_id = 1, name = "times", value = 0, no_refresh = false },
	{ config_id = 2, name = "correct", value = 0, no_refresh = false },
	{ config_id = 3, name = "camera", value = 0, no_refresh = false }
}

-- 废弃数据
garbages = {
	triggers = {
		{ config_id = 1038001, name = "QUEST_START_38001", event = EventType.EVENT_QUEST_START, source = "7050004", condition = "", action = "action_EVENT_QUEST_START_38001", trigger_count = 0 }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	io_type = 1,
	suite = 1,
	end_suite = 5,
	rand_suite = false,
	father_quest = 70500,
	quest_config = {
		[7050001] = {
			{
				state = 2,
				suite = 1
			}
		},
		[7050002] = {
			{
				state = 2,
				suite = 2
			}
		},
		[7050003] = {
			{
				state = 2,
				suite = 3
			}
		},
		[7050004] = {
			{
				state = 2,
				suite = 4
			}
		},
		[7050005] = {
			{
				state = 3,
				suite = 5
			}
		}
	}
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suite_disk = {
	[1] = {
		gadgets = {
			{ config_id = 38002, state = 0 },
			{ config_id = 38005, state = 0 },
			{ config_id = 38007, state = 0 },
			{ config_id = 38048, state = 201 },
			{ config_id = 38050, state = 0 },
			{ config_id = 38052, state = 0 },
			{ config_id = 38054, state = 0 },
			{ config_id = 38055, state = 201 },
			{ config_id = 38056, state = 201 },
			{ config_id = 38057, state = 201 },
			{ config_id = 38064, state = 201 },
			{ config_id = 38068, state = 0 }
		},
		monsters = {
		},
		regions = { },
		triggers = { "QUEST_FINISH_38012", "ANY_GADGET_DIE_38035", "ANY_GADGET_DIE_38039", "ANY_GADGET_DIE_38040", "ANY_GADGET_DIE_38041" },
		npcs = { },
		variables = {
			{ config_id = 1, name = "times", value = 0, no_refresh = false },
			{ config_id = 2, name = "correct", value = 0, no_refresh = false },
			{ config_id = 3, name = "camera", value = 0, no_refresh = false }
		}
	},
	[2] = {
		gadgets = {
			{ config_id = 38002, state = 0 },
			{ config_id = 38003, state = 0 },
			{ config_id = 38005, state = 0 },
			{ config_id = 38007, state = 0 },
			{ config_id = 38014, state = 0 },
			{ config_id = 38017, state = 0 },
			{ config_id = 38018, state = 0 },
			{ config_id = 38019, state = 0 },
			{ config_id = 38020, state = 0 },
			{ config_id = 38021, state = 0 },
			{ config_id = 38022, state = 0 },
			{ config_id = 38023, state = 0 },
			{ config_id = 38024, state = 0 },
			{ config_id = 38025, state = 0 },
			{ config_id = 38026, state = 0 },
			{ config_id = 38027, state = 0 },
			{ config_id = 38028, state = 0 },
			{ config_id = 38030, state = 0 },
			{ config_id = 38032, state = 0 },
			{ config_id = 38033, state = 0 },
			{ config_id = 38044, state = 0 },
			{ config_id = 38045, state = 0 },
			{ config_id = 38046, state = 0 },
			{ config_id = 38048, state = 201 },
			{ config_id = 38050, state = 0 },
			{ config_id = 38052, state = 0 },
			{ config_id = 38054, state = 0 },
			{ config_id = 38055, state = 201 },
			{ config_id = 38056, state = 201 },
			{ config_id = 38057, state = 201 },
			{ config_id = 38059, state = 0 },
			{ config_id = 38060, state = 0 },
			{ config_id = 38061, state = 0 },
			{ config_id = 38062, state = 0 },
			{ config_id = 38064, state = 201 },
			{ config_id = 38068, state = 0 }
		},
		monsters = {
		},
		regions = { 38029, 38047 },
		triggers = { "GADGET_STATE_CHANGE_38011", "GADGET_STATE_CHANGE_38015", "GADGET_STATE_CHANGE_38016", "ENTER_REGION_38029", "GADGET_STATE_CHANGE_38031", "QUEST_START_38034", "ANY_GADGET_DIE_38035", "GADGET_STATE_CHANGE_38036", "GADGET_STATE_CHANGE_38037", "GADGET_STATE_CHANGE_38038", "ANY_GADGET_DIE_38039", "ANY_GADGET_DIE_38040", "ANY_GADGET_DIE_38041", "VARIABLE_CHANGE_38042", "VARIABLE_CHANGE_38043", "ENTER_REGION_38047", "ANY_MONSTER_DIE_38058", "GADGET_STATE_CHANGE_38063", "GADGET_STATE_CHANGE_38065", "GADGET_STATE_CHANGE_38066", "GADGET_STATE_CHANGE_38067" },
		npcs = { },
		variables = {
			{ config_id = 1, name = "times", value = 0, no_refresh = false },
			{ config_id = 2, name = "correct", value = 0, no_refresh = false },
			{ config_id = 3, name = "camera", value = 0, no_refresh = false }
		}
	},
	[3] = {
		gadgets = {
			{ config_id = 38005, state = 201 },
			{ config_id = 38007, state = 201 },
			{ config_id = 38008, state = 0 },
			{ config_id = 38048, state = 201 },
			{ config_id = 38049, state = 0 },
			{ config_id = 38051, state = 0 },
			{ config_id = 38053, state = 0 },
			{ config_id = 38055, state = 201 },
			{ config_id = 38056, state = 201 },
			{ config_id = 38057, state = 201 },
			{ config_id = 38064, state = 201 }
		},
		monsters = {
			{ config_id = 38009 },
			{ config_id = 38010 }
		},
		regions = { },
		triggers = { "QUEST_FINISH_38013" },
		npcs = { },
		variables = {
			{ config_id = 1, name = "times", value = 0, no_refresh = false },
			{ config_id = 2, name = "correct", value = 0, no_refresh = false },
			{ config_id = 3, name = "camera", value = 0, no_refresh = false }
		}
	},
	[4] = {
		gadgets = {
			{ config_id = 38005, state = 201 },
			{ config_id = 38007, state = 201 },
			{ config_id = 38008, state = 0 },
			{ config_id = 38048, state = 201 },
			{ config_id = 38049, state = 0 },
			{ config_id = 38051, state = 0 },
			{ config_id = 38053, state = 0 },
			{ config_id = 38055, state = 201 },
			{ config_id = 38056, state = 201 },
			{ config_id = 38057, state = 201 },
			{ config_id = 38064, state = 201 }
		},
		monsters = {
		},
		regions = { },
		triggers = { },
		npcs = { },
		variables = {
			{ config_id = 1, name = "times", value = 0, no_refresh = false },
			{ config_id = 2, name = "correct", value = 0, no_refresh = false },
			{ config_id = 3, name = "camera", value = 0, no_refresh = false }
		}
	},
	[5] = {
		gadgets = {
			{ config_id = 38008, state = 0 },
			{ config_id = 38048, state = 201 },
			{ config_id = 38049, state = 0 },
			{ config_id = 38051, state = 0 },
			{ config_id = 38053, state = 0 },
			{ config_id = 38055, state = 201 },
			{ config_id = 38056, state = 201 },
			{ config_id = 38057, state = 201 },
			{ config_id = 38064, state = 201 }
		},
		monsters = {
		},
		regions = { },
		triggers = { },
		npcs = { },
		variables = {
			{ config_id = 1, name = "times", value = 0, no_refresh = false },
			{ config_id = 2, name = "correct", value = 0, no_refresh = false },
			{ config_id = 3, name = "camera", value = 0, no_refresh = false }
		}
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38011(context, evt)
	if 38053 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38011(context, evt)
	-- 将本组内变量名为 "times" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "times", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将本组内变量名为 "correct" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "correct", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将configid为 38060 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38060, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38061 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38061, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38062 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38062, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38059 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38059, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_38012(context, evt)
		-- 将指定flowGroup的进度和要素属性都改为目标suite（缺的创建，多的移除）
	  ScriptLib.GoToFlowSuite(context, 133105038, 2)
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_FINISH_38013(context, evt)
		-- 将指定flowGroup的进度和要素属性都改为目标suite（缺的创建，多的移除）
	  ScriptLib.GoToFlowSuite(context, 133105038, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38015(context, evt)
	if 38008 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38015(context, evt)
	-- 针对当前group内变量名为 "times" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "times", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 将configid为 38060 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38060, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38016(context, evt)
	if 38049 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38016(context, evt)
	-- 针对当前group内变量名为 "times" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "times", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 将configid为 38061 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38061, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_38029(context, evt)
	if evt.param1 ~= 38029 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_38029(context, evt)
	-- 调用提示id为 70500071 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500071) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38031(context, evt)
	if 38051 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38031(context, evt)
	-- 针对当前group内变量名为 "times" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "times", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 将configid为 38062 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38062, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_START_38034(context, evt)
	-- 将本组内变量名为 "times" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "times", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将本组内变量名为 "correct" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "correct", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_38035(context, evt)
	if 38002 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_38035(context, evt)
	-- 创建id为38008的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 38008 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38036(context, evt)
	if 38008 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"times"为1
	if ScriptLib.GetGroupVariableValue(context, "times") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38036(context, evt)
	-- 针对当前group内变量名为 "correct" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "correct", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38037(context, evt)
	if 38049 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"times"为2
	if ScriptLib.GetGroupVariableValue(context, "times") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38037(context, evt)
	-- 针对当前group内变量名为 "correct" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "correct", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38038(context, evt)
	if 38051 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"times"为3
	if ScriptLib.GetGroupVariableValue(context, "times") ~= 3 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38038(context, evt)
	-- 针对当前group内变量名为 "correct" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "correct", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_38039(context, evt)
	if 38050 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_38039(context, evt)
	-- 创建id为38053的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 38053 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_38040(context, evt)
	if 38052 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_38040(context, evt)
	-- 创建id为38049的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 38049 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_38041(context, evt)
	if 38054 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_38041(context, evt)
	-- 创建id为38051的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 38051 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_38042(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"times"为4
	if ScriptLib.GetGroupVariableValue(context, "times") ~= 4 then
			return false
	end
	
	-- 判断变量"correct"为4
	if ScriptLib.GetGroupVariableValue(context, "correct") ~= 4 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_38042(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 38006, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	-- 触发镜头注目，注目位置为坐标（888，348，-786），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=888, y=348, z=-786}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 将configid为 38005 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38005, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38007 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38007, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 调用提示id为 70500031 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500031) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133105038, EntityType.GADGET, 38068 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_38043(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"times"为4
	if ScriptLib.GetGroupVariableValue(context, "times") ~= 4 then
			return false
	end
	
	-- 判断变量"correct"不为4
	if ScriptLib.GetGroupVariableValue(context, "correct") >= 4 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_38043(context, evt)
	-- 调用提示id为 70500021 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500021) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 将本组内变量名为 "times" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "times", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将本组内变量名为 "correct" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "correct", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将configid为 38059 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38059, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38060 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38060, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38061 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38061, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 38062 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 38062, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_38047(context, evt)
	if evt.param1 ~= 38047 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_38047(context, evt)
	-- 调用提示id为 70500011 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500011) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_38058(context, evt)
	if 38006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_38058(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "7050002finish") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 将指定flowGroup的进度和要素属性都改为目标suite（缺的创建，多的移除）
	  ScriptLib.GoToFlowSuite(context, 133105038, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38063(context, evt)
	if 38053 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"camera"为0
	if ScriptLib.GetGroupVariableValue(context, "camera") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38063(context, evt)
	-- 调用提示id为 70500061 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500061) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 触发镜头注目，注目位置为坐标（901.7714，350.5666，-798.9892），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=901.7714, y=350.5666, z=-798.9892}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 将本组内变量名为 "camera" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "camera", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38065(context, evt)
	if 38008 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"camera"为0
	if ScriptLib.GetGroupVariableValue(context, "camera") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38065(context, evt)
	-- 调用提示id为 70500061 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500061) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 触发镜头注目，注目位置为坐标（901.126，350.6323，-798.5636），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=901.126, y=350.6323, z=-798.5636}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 将本组内变量名为 "camera" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "camera", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38066(context, evt)
	if 38049 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"camera"为0
	if ScriptLib.GetGroupVariableValue(context, "camera") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38066(context, evt)
	-- 调用提示id为 70500061 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500061) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 触发镜头注目，注目位置为坐标（900.4602，350.7121，-797.658），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=900.4602, y=350.7121, z=-797.658}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 将本组内变量名为 "camera" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "camera", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_38067(context, evt)
	if 38051 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"camera"为0
	if ScriptLib.GetGroupVariableValue(context, "camera") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_38067(context, evt)
	-- 调用提示id为 70500061 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 70500061) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 触发镜头注目，注目位置为坐标（899.8642，350.7925，-797.217），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=899.8642, y=350.7925, z=-797.217}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 将本组内变量名为 "camera" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "camera", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end