-- 基础信息
local base_info = {
	group_id = 133105257
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 257001, monster_id = 21011001, pos = { x = 556.922, y = 202.663, z = -627.596 }, rot = { x = 0.000, y = 324.886, z = 0.000 }, level = 1, drop_tag = "远程丘丘人", disableWander = true, affix = { 1411 }, pose_id = 32, area_id = 9 },
	{ config_id = 257002, monster_id = 21011001, pos = { x = 553.060, y = 202.684, z = -630.610 }, rot = { x = 0.000, y = 335.692, z = 0.000 }, level = 1, drop_tag = "远程丘丘人", disableWander = true, affix = { 1411 }, pose_id = 32, area_id = 9 },
	{ config_id = 257003, monster_id = 22010101, pos = { x = 552.767, y = 202.725, z = -620.190 }, rot = { x = 0.000, y = 33.560, z = 0.000 }, level = 1, drop_tag = "深渊法师", affix = { 1411 }, area_id = 9 },
	{ config_id = 257004, monster_id = 21010601, pos = { x = 549.753, y = 202.722, z = -624.823 }, rot = { x = 0.000, y = 239.263, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, pose_id = 9011, area_id = 9 },
	{ config_id = 257005, monster_id = 21010201, pos = { x = 554.039, y = 202.687, z = -613.386 }, rot = { x = 0.000, y = 267.367, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, area_id = 9 },
	{ config_id = 257006, monster_id = 21010201, pos = { x = 552.344, y = 202.718, z = -615.124 }, rot = { x = 0.000, y = 180.082, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, area_id = 9 },
	{ config_id = 257007, monster_id = 21010601, pos = { x = 546.802, y = 202.743, z = -615.336 }, rot = { x = 0.000, y = 33.560, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, pose_id = 32, area_id = 9 },
	{ config_id = 257008, monster_id = 21010301, pos = { x = 552.698, y = 202.682, z = -630.466 }, rot = { x = 0.000, y = 33.560, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, area_id = 9 },
	{ config_id = 257009, monster_id = 21010301, pos = { x = 555.702, y = 202.688, z = -626.776 }, rot = { x = 0.000, y = 33.560, z = 0.000 }, level = 1, drop_tag = "丘丘人", affix = { 1411 }, area_id = 9 },
	{ config_id = 257010, monster_id = 21010501, pos = { x = 544.160, y = 202.747, z = -616.262 }, rot = { x = 0.000, y = 332.501, z = 0.000 }, level = 1, drop_tag = "远程丘丘人", disableWander = true, affix = { 1411 }, pose_id = 32, area_id = 9 },
	{ config_id = 257011, monster_id = 21010501, pos = { x = 552.657, y = 202.724, z = -612.415 }, rot = { x = 0.000, y = 239.075, z = 0.000 }, level = 1, drop_tag = "远程丘丘人", disableWander = true, affix = { 1411 }, pose_id = 32, area_id = 9 },
	{ config_id = 257012, monster_id = 21030301, pos = { x = 556.892, y = 202.685, z = -627.688 }, rot = { x = 0.000, y = 340.617, z = 0.000 }, level = 1, drop_tag = "丘丘萨满", affix = { 1411 }, area_id = 9 },
	{ config_id = 257013, monster_id = 21030301, pos = { x = 547.485, y = 202.725, z = -615.106 }, rot = { x = 0.000, y = 158.069, z = 0.000 }, level = 1, drop_tag = "丘丘萨满", affix = { 1411 }, area_id = 9 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 257014, gadget_id = 70220014, pos = { x = 540.639, y = 202.872, z = -628.667 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257015, gadget_id = 70220014, pos = { x = 541.795, y = 202.746, z = -623.436 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257016, gadget_id = 70220014, pos = { x = 541.959, y = 202.773, z = -625.898 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257017, gadget_id = 70220013, pos = { x = 541.810, y = 202.766, z = -629.535 }, rot = { x = 0.000, y = 314.234, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257018, gadget_id = 70220013, pos = { x = 541.631, y = 202.748, z = -618.460 }, rot = { x = 0.000, y = 350.879, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257019, gadget_id = 70220013, pos = { x = 542.113, y = 202.851, z = -627.415 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257020, gadget_id = 70220013, pos = { x = 558.397, y = 202.724, z = -615.358 }, rot = { x = 0.000, y = 343.292, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257021, gadget_id = 70300101, pos = { x = 546.932, y = 202.681, z = -626.551 }, rot = { x = 0.000, y = 64.627, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257022, gadget_id = 70300086, pos = { x = 540.138, y = 202.745, z = -618.736 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257023, gadget_id = 70300086, pos = { x = 560.651, y = 202.661, z = -621.548 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257024, gadget_id = 70220025, pos = { x = 543.325, y = 202.868, z = -626.419 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257025, gadget_id = 70220025, pos = { x = 542.325, y = 202.748, z = -621.451 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257028, gadget_id = 70220025, pos = { x = 543.552, y = 202.814, z = -623.516 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257029, gadget_id = 70220016, pos = { x = 559.832, y = 203.262, z = -621.088 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257030, gadget_id = 70220016, pos = { x = 548.777, y = 203.357, z = -632.800 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257031, gadget_id = 70220025, pos = { x = 552.874, y = 202.901, z = -620.243 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257032, gadget_id = 70220025, pos = { x = 551.725, y = 202.790, z = -621.354 }, rot = { x = 270.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257033, gadget_id = 70220025, pos = { x = 558.158, y = 202.828, z = -618.562 }, rot = { x = 270.346, y = 79.009, z = 283.327 }, level = 1, area_id = 9 },
	{ config_id = 257034, gadget_id = 70220025, pos = { x = 556.830, y = 202.789, z = -616.972 }, rot = { x = 270.346, y = 79.009, z = 283.327 }, level = 1, area_id = 9 },
	{ config_id = 257037, gadget_id = 70300081, pos = { x = 559.180, y = 202.666, z = -628.999 }, rot = { x = 0.000, y = 63.980, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 257038, gadget_id = 70300081, pos = { x = 553.284, y = 202.687, z = -632.401 }, rot = { x = 0.000, y = 60.451, z = 0.000 }, level = 1, area_id = 9 }
}

-- 区域
regions = {
	{ config_id = 257035, shape = RegionShape.SPHERE, radius = 19.9, pos = { x = 551.755, y = 202.686, z = -622.903 }, area_id = 9 }
}

-- 触发器
triggers = {
	{ config_id = 1257026, name = "ANY_MONSTER_DIE_257026", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_257026", action = "action_EVENT_ANY_MONSTER_DIE_257026" },
	{ config_id = 1257027, name = "ANY_MONSTER_DIE_257027", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_257027", action = "action_EVENT_ANY_MONSTER_DIE_257027" },
	{ config_id = 1257035, name = "ENTER_REGION_257035", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_257035", action = "action_EVENT_ENTER_REGION_257035" }
}

-- 变量
variables = {
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { 257001, 257002, 257004, 257005, 257010, 257011 },
		gadgets = { 257014, 257015, 257016, 257017, 257018, 257019, 257020, 257021, 257022, 257023, 257024, 257025, 257028, 257029, 257030, 257031, 257032, 257033, 257034, 257037, 257038 },
		regions = { 257035 },
		triggers = { "ANY_MONSTER_DIE_257026", "ENTER_REGION_257035" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = suite_2,
		monsters = { 257006, 257007, 257008, 257009 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_257027" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = suite_3,
		monsters = { 257003, 257012, 257013 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_257026(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_257026(context, evt)
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133105257, 2)
	
	-- play_type含义：1·代表开始播放； 2·代表停止播放
	-- 在指定位置播放或停止音效资源
		local pos = {x=549, y=202, z=-624}
	    if 0 ~= ScriptLib.ScenePlaySound(context, {play_pos = pos, sound_name = "LevelHornSound001", play_type= 1, is_broadcast = false }) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_soundplay")
					return -1
		end 
	
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=549,y=202,z=-624}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 400004, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_257027(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_257027(context, evt)
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133105257, 3)
	
	-- play_type含义：1·代表开始播放； 2·代表停止播放
	-- 在指定位置播放或停止音效资源
		local pos = {x=549, y=202, z=-624}
	    if 0 ~= ScriptLib.ScenePlaySound(context, {play_pos = pos, sound_name = "LevelHornSound001", play_type= 1, is_broadcast = false }) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_soundplay")
					return -1
		end 
	
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=549,y=202,z=-624}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 400004, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_257035(context, evt)
	if evt.param1 ~= 257035 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_257035(context, evt)
	-- 在指定位置对应半径范围播放reminder
	local pos = {x=551,y=202,z=-622}
	if 0 ~= ScriptLib.ShowReminderRadius(context, 1110086, pos, 50) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui_bypos")
		return -1
	end
	
	return 0
end