-- 基础信息
local base_info = {
	group_id = 133106069
}

-- Trigger变量
local defs = {
	group_id = 133106069,
	gadget_riddle_hint = 69001,
	gadget_riddle_1 = 69002,
	gadget_riddle_2 = 69003,
	gadget_riddle_3 = 69004,
	gadget_riddle_4 = 69005,
	gadget_chest = 69006
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 69001, gadget_id = 70310012, pos = { x = -871.211, y = 159.611, z = 1352.222 }, rot = { x = 0.000, y = 204.240, z = 0.000 }, level = 32, persistent = true, area_id = 8 },
	{ config_id = 69002, gadget_id = 70310011, pos = { x = -864.643, y = 161.543, z = 1349.898 }, rot = { x = 0.244, y = 276.094, z = 357.045 }, level = 32, persistent = true, area_id = 8 },
	{ config_id = 69003, gadget_id = 70310011, pos = { x = -875.842, y = 156.376, z = 1345.016 }, rot = { x = 353.347, y = 317.502, z = 359.969 }, level = 32, persistent = true, area_id = 8 },
	{ config_id = 69004, gadget_id = 70310011, pos = { x = -877.822, y = 166.466, z = 1355.372 }, rot = { x = 0.000, y = 257.600, z = 0.000 }, level = 32, persistent = true, area_id = 8 },
	{ config_id = 69005, gadget_id = 70310011, pos = { x = -864.597, y = 162.280, z = 1366.090 }, rot = { x = 0.059, y = 14.101, z = 2.548 }, level = 32, persistent = true, area_id = 8 },
	{ config_id = 69006, gadget_id = 70211112, pos = { x = -871.153, y = 160.060, z = 1352.087 }, rot = { x = 0.000, y = 284.640, z = 0.000 }, level = 26, drop_tag = "解谜中级璃月", state = GadgetState.ChestLocked, isOneoff = true, persistent = true, explore = { name = "chest", exp = 1 }, area_id = 8 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	{ config_id = 1069007, name = "GADGET_STATE_CHANGE_69007", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_69007", action = "action_EVENT_GADGET_STATE_CHANGE_69007", trigger_count = 0 },
	{ config_id = 1069008, name = "VARIABLE_CHANGE_69008", event = EventType.EVENT_VARIABLE_CHANGE, source = "State_Flag", condition = "condition_EVENT_VARIABLE_CHANGE_69008", action = "action_EVENT_VARIABLE_CHANGE_69008", trigger_count = 0 },
	{ config_id = 1069009, name = "GROUP_LOAD_69009", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_EVENT_GROUP_LOAD_69009", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "State_Flag", value = 0, no_refresh = true }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = suite_1,
		monsters = { },
		gadgets = { 69001, 69002, 69003, 69004, 69005, 69006 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_69007", "VARIABLE_CHANGE_69008", "GROUP_LOAD_69009" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_69007(context, evt)
	if evt.param2 ~= defs.gadget_riddle_1 and evt.param2 ~= defs.gadget_riddle_2 and evt.param2 ~= defs.gadget_riddle_3 and evt.param2 ~= defs.gadget_riddle_4 then
	return false 
	end
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_69007(context, evt)
	if evt.param1 == GadgetState.GearStart then
	ScriptLib.ChangeGroupVariableValue(context, "State_Flag", 1)
	if 0 == ScriptLib.GetCurTriggerCount(context) then
	ScriptLib.MarkPlayerAction(context, 1003, 1, 1)
	end 
	elseif evt.param1 == GadgetState.Default then
	ScriptLib.ChangeGroupVariableValue(context, "State_Flag", -1)
	end
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_69008(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	if evt.param1 < 0 or evt.param1 > 4 then
	return false
	end
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_69008(context, evt)
	if evt.param1 == 0 then
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_hint, GadgetState.Default)
	elseif evt.param1 == 1 then
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_hint, GadgetState.Action01)
	ScriptLib.MarkPlayerAction(context, 1003, 2, 2) 
	elseif evt.param1 == 2 then
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_hint, GadgetState.Action02)
	ScriptLib.MarkPlayerAction(context, 1003, 2, 3) 
	elseif evt.param1 == 3 then
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_hint, GadgetState.Action03)
	ScriptLib.MarkPlayerAction(context, 1003, 2, 4) 
	elseif evt.param1 == 4 then
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_hint, GadgetState.GearStart)
	ScriptLib.MarkPlayerAction(context, 1003, 3, 5) 
	ScriptLib.SetGroupGadgetStateByConfigId(context, defs.group_id, defs.gadget_chest, GadgetState.Default)
	end
	return 0
end

-- 触发操作
function action_EVENT_GROUP_LOAD_69009(context, evt)
	local sum = 0
	if ScriptLib.GetGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_1) == GadgetState.GearStart then
	sum = sum + 1
	end
	if ScriptLib.GetGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_2) == GadgetState.GearStart then
	sum = sum + 1
	end
	if ScriptLib.GetGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_3) == GadgetState.GearStart then
	sum = sum + 1
	end
	if ScriptLib.GetGadgetStateByConfigId(context, defs.group_id, defs.gadget_riddle_4) == GadgetState.GearStart then
	sum = sum + 1
	end
	ScriptLib.SetGroupVariableValue(context, "State_Flag", sum)
	return 0
end