-- 基础信息
local base_info = {
	group_id = 133108003
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 3001, gadget_id = 70690006, pos = { x = -272.429, y = 200.000, z = -602.484 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 3002, gadget_id = 70690001, pos = { x = -267.352, y = 226.091, z = -599.791 }, rot = { x = 356.663, y = 70.870, z = 0.296 }, level = 32, area_id = 7 },
	{ config_id = 3003, gadget_id = 70690001, pos = { x = -253.307, y = 226.917, z = -593.387 }, rot = { x = 358.670, y = 69.350, z = 0.273 }, level = 32, area_id = 7 },
	{ config_id = 3004, gadget_id = 70690001, pos = { x = -239.434, y = 227.429, z = -586.767 }, rot = { x = 357.257, y = 51.997, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3005, gadget_id = 70690001, pos = { x = -227.807, y = 229.215, z = -577.151 }, rot = { x = 3.170, y = 44.227, z = 359.876 }, level = 32, area_id = 7 },
	{ config_id = 3006, gadget_id = 70690001, pos = { x = -216.595, y = 227.899, z = -567.233 }, rot = { x = 3.112, y = 51.997, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3007, gadget_id = 70690001, pos = { x = -205.083, y = 224.826, z = -557.665 }, rot = { x = 2.730, y = 46.190, z = 359.908 }, level = 32, area_id = 7 },
	{ config_id = 3008, gadget_id = 70690001, pos = { x = -193.275, y = 223.331, z = -548.439 }, rot = { x = 0.914, y = 51.997, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3009, gadget_id = 70690001, pos = { x = -181.107, y = 222.576, z = -539.647 }, rot = { x = 0.914, y = 51.997, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3010, gadget_id = 70690001, pos = { x = -169.832, y = 220.545, z = -528.413 }, rot = { x = 14.045, y = 39.031, z = 356.802 }, level = 32, area_id = 7 },
	{ config_id = 3011, gadget_id = 70690001, pos = { x = -161.299, y = 215.524, z = -514.021 }, rot = { x = 24.539, y = 29.861, z = 359.624 }, level = 32, area_id = 7 },
	{ config_id = 3018, gadget_id = 70690006, pos = { x = -142.117, y = 200.000, z = -415.475 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 3030, gadget_id = 70690001, pos = { x = -140.523, y = 224.994, z = -405.646 }, rot = { x = 343.171, y = 355.854, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3031, gadget_id = 70690001, pos = { x = -141.742, y = 228.227, z = -389.477 }, rot = { x = 340.248, y = 359.586, z = 1.202 }, level = 32, area_id = 7 },
	{ config_id = 3032, gadget_id = 70690001, pos = { x = -142.757, y = 231.894, z = -374.823 }, rot = { x = 338.515, y = 355.854, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3033, gadget_id = 70690001, pos = { x = -143.947, y = 235.017, z = -358.404 }, rot = { x = 0.493, y = 355.854, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3034, gadget_id = 70690001, pos = { x = -145.122, y = 234.695, z = -342.202 }, rot = { x = 0.493, y = 355.854, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3035, gadget_id = 70690001, pos = { x = -146.224, y = 232.268, z = -326.991 }, rot = { x = 3.517, y = 355.854, z = 0.000 }, level = 32, area_id = 7 },
	{ config_id = 3036, gadget_id = 70690001, pos = { x = -147.380, y = 228.691, z = -311.055 }, rot = { x = 0.484, y = 344.804, z = 359.906 }, level = 32, area_id = 7 },
	{ config_id = 3037, gadget_id = 70690001, pos = { x = -152.924, y = 226.169, z = -294.548 }, rot = { x = 0.479, y = 342.091, z = 359.883 }, level = 19, area_id = 7 },
	{ config_id = 3038, gadget_id = 70690001, pos = { x = -155.968, y = 224.165, z = -282.815 }, rot = { x = 2.405, y = 355.854, z = 0.000 }, level = 19, area_id = 7 },
	{ config_id = 3039, gadget_id = 70690001, pos = { x = -157.166, y = 221.388, z = -269.206 }, rot = { x = 0.493, y = 355.854, z = 0.000 }, level = 19, area_id = 7 },
	{ config_id = 3040, gadget_id = 70690001, pos = { x = -158.822, y = 217.614, z = -249.929 }, rot = { x = 0.454, y = 18.962, z = 0.194 }, level = 19, area_id = 7 },
	{ config_id = 3041, gadget_id = 70690001, pos = { x = -152.972, y = 214.714, z = -233.911 }, rot = { x = 4.865, y = 354.784, z = 359.991 }, level = 18, area_id = 7 },
	{ config_id = 3042, gadget_id = 70690001, pos = { x = -153.742, y = 210.582, z = -217.208 }, rot = { x = 23.369, y = 355.854, z = 0.000 }, level = 18, area_id = 7 }
}

-- 区域
regions = {
	-- 第一段挑战触发
	{ config_id = 3012, shape = RegionShape.SPHERE, radius = 5, pos = { x = -274.433, y = 200.000, z = -605.160 }, area_id = 7 },
	{ config_id = 3015, shape = RegionShape.SPHERE, radius = 50, pos = { x = -157.581, y = 202.147, z = -469.959 }, area_id = 7 },
	{ config_id = 3017, shape = RegionShape.SPHERE, radius = 5, pos = { x = -143.940, y = 200.000, z = -416.515 }, area_id = 7 },
	{ config_id = 3022, shape = RegionShape.SPHERE, radius = 50, pos = { x = -130.781, y = 200.944, z = -174.984 }, area_id = 7 }
}

-- 触发器
triggers = {
	-- 第一段挑战触发
	{ config_id = 1003012, name = "ENTER_REGION_3012", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_3012", action = "action_EVENT_ENTER_REGION_3012", trigger_count = 0 },
	{ config_id = 1003013, name = "CHALLENGE_SUCCESS_3013", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "" },
	{ config_id = 1003014, name = "CHALLENGE_FAIL_3014", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_3014", trigger_count = 0 },
	{ config_id = 1003015, name = "ENTER_REGION_3015", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_3015", action = "", tag = "888" },
	{ config_id = 1003016, name = "CHALLENGE_FAIL_3016", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_3016", trigger_count = 0 },
	{ config_id = 1003017, name = "ENTER_REGION_3017", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_3017", action = "action_EVENT_ENTER_REGION_3017", trigger_count = 0 },
	{ config_id = 1003019, name = "CHALLENGE_SUCCESS_3019", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "333", condition = "", action = "" },
	{ config_id = 1003020, name = "CHALLENGE_FAIL_3020", event = EventType.EVENT_CHALLENGE_FAIL, source = "333", condition = "", action = "action_EVENT_CHALLENGE_FAIL_3020", trigger_count = 0 },
	{ config_id = 1003021, name = "CHALLENGE_FAIL_3021", event = EventType.EVENT_CHALLENGE_FAIL, source = "333", condition = "", action = "action_EVENT_CHALLENGE_FAIL_3021", trigger_count = 0 },
	{ config_id = 1003022, name = "ENTER_REGION_3022", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_3022", action = "", tag = "999" },
	-- group加载的时候刷新1
	{ config_id = 1003023, name = "GROUP_LOAD_3023", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_EVENT_GROUP_LOAD_3023" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted01", value = 0, no_refresh = false },
	{ config_id = 2, name = "hasStarted02", value = 0, no_refresh = false }
}

-- 废弃数据
garbages = {
	triggers = {
		{ config_id = 1003024, name = "GROUP_LOAD_3024", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_EVENT_GROUP_LOAD_3024" }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 3001, 3002, 3003, 3004, 3005, 3006, 3007, 3008, 3009, 3010, 3011, 3039, 3040, 3041, 3042 },
		regions = { 3012, 3015 },
		triggers = { "ENTER_REGION_3012", "CHALLENGE_SUCCESS_3013", "CHALLENGE_FAIL_3014", "ENTER_REGION_3015", "CHALLENGE_FAIL_3016", "GROUP_LOAD_3023" },
		rand_weight = 100,
		ban_refresh = true
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 3018, 3030, 3031, 3032, 3033, 3034, 3035, 3036, 3037, 3038, 3039, 3040, 3041, 3042 },
		regions = { 3017, 3022 },
		triggers = { "ENTER_REGION_3017", "CHALLENGE_SUCCESS_3019", "CHALLENGE_FAIL_3020", "CHALLENGE_FAIL_3021", "ENTER_REGION_3022" },
		rand_weight = 100,
		ban_refresh = true
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_3012(context, evt)
	if evt.param1 ~= 3012 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	-- 判断变量"hasStarted01"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted01") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_3012(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为110185的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 110185, 30, 4, 888, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 将本组内变量名为 "hasStarted01" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted01", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_3014(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "200205") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_3015(context, evt)
	if evt.param1 ~= 3015 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_3016(context, evt)
	-- 将本组内变量名为 "hasStarted01" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted01", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_3017(context, evt)
	if evt.param1 ~= 3017 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	-- 判断变量"hasStarted02"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted02") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_3017(context, evt)
	-- 创建编号为333（该挑战的识别id),挑战内容为110186的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 333, 110186, 30, 4, 999, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 将本组内变量名为 "hasStarted02" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted02", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_3020(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "200207") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_3021(context, evt)
	-- 将本组内变量名为 "hasStarted02" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted02", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_3022(context, evt)
	if evt.param1 ~= 3022 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GROUP_LOAD_3023(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133108003, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end