-- 基础信息
local base_info = {
	group_id = 133108112
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 112001, monster_id = 20011201, pos = { x = -33.465, y = 265.795, z = -32.531 }, rot = { x = 0.000, y = 327.299, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112002, monster_id = 20011201, pos = { x = -38.029, y = 265.796, z = -30.836 }, rot = { x = 0.000, y = 45.800, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112003, monster_id = 20010501, pos = { x = -91.865, y = 255.511, z = -83.247 }, rot = { x = 0.000, y = 9.824, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112004, monster_id = 20010501, pos = { x = -96.213, y = 255.075, z = -82.296 }, rot = { x = 0.000, y = 68.256, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112005, monster_id = 20010801, pos = { x = -145.178, y = 251.210, z = -99.725 }, rot = { x = 0.000, y = 342.797, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112006, monster_id = 20010801, pos = { x = -147.167, y = 251.210, z = -99.664 }, rot = { x = 0.000, y = 94.866, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112035, monster_id = 20011401, pos = { x = -218.374, y = 239.472, z = -105.424 }, rot = { x = 0.000, y = 286.005, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112036, monster_id = 20011401, pos = { x = -219.708, y = 239.013, z = -107.767 }, rot = { x = 0.000, y = 344.829, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112042, monster_id = 20010801, pos = { x = -69.431, y = 200.000, z = -173.518 }, rot = { x = 0.000, y = 342.223, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112043, monster_id = 20010801, pos = { x = -66.464, y = 200.000, z = -169.634 }, rot = { x = 0.000, y = 307.274, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112044, monster_id = 20010801, pos = { x = -146.212, y = 251.210, z = -98.204 }, rot = { x = 0.000, y = 94.866, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112045, monster_id = 20011201, pos = { x = -36.932, y = 265.833, z = -34.968 }, rot = { x = 0.000, y = 7.086, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112049, monster_id = 20010501, pos = { x = -92.429, y = 255.199, z = -80.355 }, rot = { x = 0.000, y = 68.256, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112051, monster_id = 20011401, pos = { x = -217.255, y = 238.869, z = -108.074 }, rot = { x = 0.000, y = 344.829, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112052, monster_id = 20010801, pos = { x = -70.930, y = 200.000, z = -168.993 }, rot = { x = 0.000, y = 307.274, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 },
	{ config_id = 112055, monster_id = 20010401, pos = { x = -68.707, y = 200.000, z = -171.108 }, rot = { x = 0.000, y = 94.866, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 7 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 112007, gadget_id = 70360005, pos = { x = -47.671, y = 264.713, z = 17.141 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112008, gadget_id = 70360025, pos = { x = -33.808, y = 202.375, z = -194.301 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112009, gadget_id = 70350085, pos = { x = -36.702, y = 265.817, z = -33.728 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112010, gadget_id = 70300114, pos = { x = -36.700, y = 264.816, z = -33.700 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112011, gadget_id = 70350085, pos = { x = -94.493, y = 255.383, z = -84.000 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112012, gadget_id = 70300114, pos = { x = -94.518, y = 255.382, z = -84.005 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112013, gadget_id = 70350085, pos = { x = -145.388, y = 251.210, z = -101.322 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112014, gadget_id = 70300114, pos = { x = -145.409, y = 251.210, z = -101.382 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112015, gadget_id = 70350085, pos = { x = -33.800, y = 202.400, z = -194.300 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112016, gadget_id = 70350085, pos = { x = -47.671, y = 265.622, z = 17.141 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112017, gadget_id = 70710126, pos = { x = -36.700, y = 265.800, z = -33.700 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112018, gadget_id = 70710126, pos = { x = -94.518, y = 255.382, z = -84.005 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112019, gadget_id = 70710126, pos = { x = -145.409, y = 251.210, z = -101.382 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112030, gadget_id = 70350085, pos = { x = -219.048, y = 238.977, z = -107.508 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112031, gadget_id = 70300114, pos = { x = -219.000, y = 239.000, z = -107.500 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112032, gadget_id = 70710126, pos = { x = -219.000, y = 239.000, z = -107.500 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112037, gadget_id = 70350085, pos = { x = -68.246, y = 200.000, z = -171.564 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112038, gadget_id = 70300114, pos = { x = -68.200, y = 200.000, z = -171.600 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112039, gadget_id = 70710126, pos = { x = -68.200, y = 200.000, z = -171.600 }, rot = { x = 0.000, y = 147.847, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112046, gadget_id = 70690001, pos = { x = -49.175, y = 263.596, z = -48.449 }, rot = { x = 0.000, y = 226.923, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112047, gadget_id = 70690001, pos = { x = -68.606, y = 262.720, z = -66.618 }, rot = { x = 0.000, y = 226.923, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112048, gadget_id = 70690001, pos = { x = -174.471, y = 224.858, z = -151.237 }, rot = { x = 10.979, y = 134.120, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112053, gadget_id = 70690001, pos = { x = -139.939, y = 209.906, z = -172.953 }, rot = { x = 0.000, y = 84.175, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112054, gadget_id = 70690001, pos = { x = -108.703, y = 209.906, z = -169.766 }, rot = { x = 0.000, y = 84.175, z = 0.000 }, level = 1, area_id = 7 },
	{ config_id = 112056, gadget_id = 70690001, pos = { x = -178.316, y = 248.704, z = -101.138 }, rot = { x = 2.726, y = 268.436, z = 3.998 }, level = 1, area_id = 7 },
	{ config_id = 112057, gadget_id = 70690001, pos = { x = -204.323, y = 236.975, z = -137.578 }, rot = { x = 19.048, y = 122.878, z = 0.000 }, level = 1, area_id = 7 }
}

-- 区域
regions = {
	{ config_id = 112023, shape = RegionShape.SPHERE, radius = 2, pos = { x = -33.800, y = 202.400, z = -194.300 }, area_id = 7 },
	{ config_id = 112024, shape = RegionShape.SPHERE, radius = 7, pos = { x = -36.700, y = 265.800, z = -33.700 }, area_id = 7 },
	{ config_id = 112026, shape = RegionShape.SPHERE, radius = 7, pos = { x = -94.518, y = 255.382, z = -84.005 }, area_id = 7 },
	{ config_id = 112028, shape = RegionShape.SPHERE, radius = 7, pos = { x = -145.409, y = 251.210, z = -101.382 }, area_id = 7 },
	{ config_id = 112033, shape = RegionShape.SPHERE, radius = 7, pos = { x = -219.000, y = 239.000, z = -107.500 }, area_id = 7 },
	{ config_id = 112040, shape = RegionShape.SPHERE, radius = 7, pos = { x = -68.200, y = 200.000, z = -171.600 }, area_id = 7 }
}

-- 触发器
triggers = {
	{ config_id = 1112020, name = "GADGET_STATE_CHANGE_112020", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_112020", action = "action_EVENT_GADGET_STATE_CHANGE_112020", trigger_count = 0 },
	{ config_id = 1112021, name = "CHALLENGE_SUCCESS_112021", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_112021", trigger_count = 0 },
	{ config_id = 1112022, name = "CHALLENGE_FAIL_112022", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_112022", trigger_count = 0 },
	{ config_id = 1112023, name = "ENTER_REGION_112023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112023", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1112024, name = "ENTER_REGION_112024", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112024", action = "action_EVENT_ENTER_REGION_112024" },
	{ config_id = 1112025, name = "ANY_MONSTER_DIE_112025", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112025", action = "action_EVENT_ANY_MONSTER_DIE_112025", trigger_count = 0 },
	{ config_id = 1112026, name = "ENTER_REGION_112026", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112026", action = "action_EVENT_ENTER_REGION_112026" },
	{ config_id = 1112027, name = "ANY_MONSTER_DIE_112027", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112027", action = "action_EVENT_ANY_MONSTER_DIE_112027" },
	{ config_id = 1112028, name = "ENTER_REGION_112028", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112028", action = "action_EVENT_ENTER_REGION_112028" },
	{ config_id = 1112029, name = "ANY_MONSTER_DIE_112029", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112029", action = "action_EVENT_ANY_MONSTER_DIE_112029" },
	{ config_id = 1112033, name = "ENTER_REGION_112033", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112033", action = "action_EVENT_ENTER_REGION_112033" },
	{ config_id = 1112034, name = "ANY_MONSTER_DIE_112034", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112034", action = "action_EVENT_ANY_MONSTER_DIE_112034" },
	{ config_id = 1112040, name = "ENTER_REGION_112040", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_112040", action = "action_EVENT_ENTER_REGION_112040" },
	{ config_id = 1112041, name = "ANY_MONSTER_DIE_112041", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112041", action = "action_EVENT_ANY_MONSTER_DIE_112041" },
	{ config_id = 1112050, name = "ANY_MONSTER_DIE_112050", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_112050", action = "action_EVENT_ANY_MONSTER_DIE_112050" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 112007, 112016 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_112020", "CHALLENGE_SUCCESS_112021", "CHALLENGE_FAIL_112022" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 112008, 112015 },
		regions = { 112023 },
		triggers = { "ENTER_REGION_112023" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { 112001, 112002, 112045 },
		gadgets = { 112009, 112010, 112017 },
		regions = { 112024 },
		triggers = { "ENTER_REGION_112024", "ANY_MONSTER_DIE_112025" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { 112003, 112004, 112049 },
		gadgets = { 112011, 112012, 112018, 112046, 112047 },
		regions = { 112026 },
		triggers = { "ENTER_REGION_112026", "ANY_MONSTER_DIE_112027" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { 112005, 112006, 112044 },
		gadgets = { 112013, 112014, 112019 },
		regions = { 112028 },
		triggers = { "ENTER_REGION_112028", "ANY_MONSTER_DIE_112050" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 节点3_2,
		monsters = { 112055 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_DIE_112029" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = 节点4,
		monsters = { 112035, 112036, 112051 },
		gadgets = { 112030, 112031, 112032, 112056 },
		regions = { 112033 },
		triggers = { "ENTER_REGION_112033", "ANY_MONSTER_DIE_112034" },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = 节点5,
		monsters = { 112042, 112043, 112052 },
		gadgets = { 112037, 112038, 112039, 112048, 112053, 112054, 112057 },
		regions = { 112040 },
		triggers = { "ENTER_REGION_112040", "ANY_MONSTER_DIE_112041" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_112020(context, evt)
	if 112007 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasStarted"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_112020(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为207的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 207, 90, 4, 888, 8) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 4)
	
	-- 将configid为 112016 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112016, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_112021(context, evt)
	-- 将configid为 112007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 7)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 8)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 9)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 2)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133108112, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_112022(context, evt)
	-- 将configid为 112007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 112016 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112016, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 7)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 8)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 9)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112023(context, evt)
	if evt.param1 ~= 112023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112024(context, evt)
	if evt.param1 ~= 112024 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_112024(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 112010 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112010, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112025(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112025(context, evt)
	-- 将configid为 112010 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112010, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 5)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112026(context, evt)
	if evt.param1 ~= 112026 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_112026(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112011 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112018 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 112012 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112012, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112027(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112027(context, evt)
	-- 将configid为 112012 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112012, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 6)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112028(context, evt)
	if evt.param1 ~= 112028 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_112028(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 112014 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112014, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112029(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112029(context, evt)
	-- 将configid为 112038 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112038, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 2)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 9)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 7)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112033(context, evt)
	if evt.param1 ~= 112033 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_112033(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112030 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112032 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 112031 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112031, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112034(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112034(context, evt)
	-- 将configid为 112031 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112031, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite9的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 9)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 8)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_112040(context, evt)
	if evt.param1 ~= 112040 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_112040(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112037 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 112039 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 112038 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112038, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112041(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112041(context, evt)
	-- 将configid为 112038 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 112038, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 2)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 9)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_112050(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_112050(context, evt)
	-- 改变指定group组133108112中， configid为112014的gadget的state
	if 0 ~= ScriptLib.SetGroupGadgetStateByConfigId(context, 133108112, 112014, GadgetState.Default) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_GroupId_ConfigId")
			return -1
		end 
	
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133108112, 8)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133108112, 6)
	
	return 0
end