-- 基础信息
local base_info = {
	group_id = 133210345
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 345001, monster_id = 20010801, pos = { x = -3917.836, y = 115.183, z = -952.091 }, rot = { x = 0.000, y = 273.634, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345002, monster_id = 20010801, pos = { x = -3918.933, y = 115.075, z = -944.968 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345003, monster_id = 20011001, pos = { x = -3874.000, y = 121.215, z = -967.036 }, rot = { x = 0.000, y = 254.846, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345004, monster_id = 20011001, pos = { x = -3875.314, y = 121.116, z = -970.320 }, rot = { x = 0.000, y = 274.672, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345005, monster_id = 20011401, pos = { x = -3850.677, y = 121.116, z = -982.756 }, rot = { x = 0.000, y = 236.865, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345006, monster_id = 20011401, pos = { x = -3847.950, y = 121.132, z = -987.820 }, rot = { x = 0.000, y = 281.736, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345014, monster_id = 20011401, pos = { x = -3847.120, y = 121.132, z = -984.406 }, rot = { x = 0.000, y = 247.569, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345024, monster_id = 20011001, pos = { x = -3876.366, y = 121.334, z = -964.090 }, rot = { x = 0.000, y = 233.228, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345025, monster_id = 20011201, pos = { x = -3770.538, y = 125.442, z = -932.463 }, rot = { x = 0.000, y = 236.865, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345026, monster_id = 20011201, pos = { x = -3767.811, y = 125.583, z = -937.525 }, rot = { x = 0.000, y = 281.736, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345027, monster_id = 20011201, pos = { x = -3766.981, y = 125.891, z = -934.112 }, rot = { x = 0.000, y = 247.569, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345030, monster_id = 20010801, pos = { x = -3917.549, y = 115.320, z = -948.217 }, rot = { x = 0.000, y = 252.944, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345033, monster_id = 20010401, pos = { x = -3785.534, y = 140.506, z = -978.979 }, rot = { x = 0.000, y = 13.178, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 },
	{ config_id = 345034, monster_id = 20010401, pos = { x = -3778.953, y = 141.421, z = -976.821 }, rot = { x = 0.000, y = 331.420, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 17 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 345007, gadget_id = 70360005, pos = { x = -3942.537, y = 114.727, z = -968.200 }, rot = { x = 0.000, y = 139.780, z = 0.000 }, level = 19, persistent = true, area_id = 17 },
	{ config_id = 345008, gadget_id = 70360025, pos = { x = -3782.697, y = 141.394, z = -978.246 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345009, gadget_id = 70350085, pos = { x = -3919.063, y = 115.114, z = -948.668 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345011, gadget_id = 70350085, pos = { x = -3877.285, y = 121.120, z = -967.811 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345013, gadget_id = 70350085, pos = { x = -3849.935, y = 121.132, z = -985.776 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345015, gadget_id = 70350085, pos = { x = -3782.697, y = 142.559, z = -978.246 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345016, gadget_id = 70350085, pos = { x = -3942.537, y = 115.694, z = -968.200 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345017, gadget_id = 70710126, pos = { x = -3919.063, y = 115.114, z = -948.668 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345018, gadget_id = 70710126, pos = { x = -3877.277, y = 121.120, z = -967.768 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345019, gadget_id = 70710126, pos = { x = -3849.935, y = 121.132, z = -985.776 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 17 },
	{ config_id = 345029, gadget_id = 70350085, pos = { x = -3769.796, y = 125.657, z = -935.482 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345031, gadget_id = 70710126, pos = { x = -3769.796, y = 125.657, z = -935.482 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345035, gadget_id = 70330064, pos = { x = -3841.804, y = 121.132, z = -984.773 }, rot = { x = 0.000, y = 95.271, z = 0.000 }, level = 30, interact_id = 35, area_id = 17 },
	{ config_id = 345036, gadget_id = 70900380, pos = { x = -3840.913, y = 127.314, z = -977.374 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345037, gadget_id = 70900380, pos = { x = -3826.812, y = 132.057, z = -967.216 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345038, gadget_id = 70900380, pos = { x = -3810.515, y = 136.034, z = -955.524 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345039, gadget_id = 70900380, pos = { x = -3791.387, y = 134.365, z = -945.735 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345040, gadget_id = 70330064, pos = { x = -3765.453, y = 125.715, z = -936.910 }, rot = { x = 0.000, y = 26.358, z = 0.000 }, level = 30, interact_id = 35, area_id = 17 },
	{ config_id = 345041, gadget_id = 70900380, pos = { x = -3772.113, y = 131.457, z = -946.602 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 },
	{ config_id = 345042, gadget_id = 70900380, pos = { x = -3776.574, y = 138.951, z = -957.465 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 30, area_id = 17 }
}

-- 区域
regions = {
	{ config_id = 345010, shape = RegionShape.SPHERE, radius = 6, pos = { x = -3919.054, y = 115.114, z = -948.729 }, area_id = 17 },
	{ config_id = 345012, shape = RegionShape.SPHERE, radius = 6, pos = { x = -3877.078, y = 121.120, z = -967.841 }, area_id = 17 },
	{ config_id = 345023, shape = RegionShape.SPHERE, radius = 2, pos = { x = -3782.731, y = 142.561, z = -978.274 }, area_id = 17 },
	{ config_id = 345028, shape = RegionShape.SPHERE, radius = 6, pos = { x = -3849.414, y = 121.132, z = -985.682 }, area_id = 17 },
	{ config_id = 345032, shape = RegionShape.SPHERE, radius = 6, pos = { x = -3769.565, y = 125.468, z = -935.623 }, area_id = 17 }
}

-- 触发器
triggers = {
	{ config_id = 1345010, name = "ENTER_REGION_345010", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_345010", action = "action_EVENT_ENTER_REGION_345010" },
	{ config_id = 1345012, name = "ENTER_REGION_345012", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_345012", action = "action_EVENT_ENTER_REGION_345012" },
	{ config_id = 1345020, name = "GADGET_STATE_CHANGE_345020", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_345020", action = "action_EVENT_GADGET_STATE_CHANGE_345020", trigger_count = 0 },
	{ config_id = 1345021, name = "CHALLENGE_SUCCESS_345021", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_345021", trigger_count = 0 },
	{ config_id = 1345022, name = "CHALLENGE_FAIL_345022", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_345022", trigger_count = 0 },
	{ config_id = 1345023, name = "ENTER_REGION_345023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_345023", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1345028, name = "ENTER_REGION_345028", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_345028", action = "action_EVENT_ENTER_REGION_345028" },
	{ config_id = 1345032, name = "ENTER_REGION_345032", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_345032", action = "action_EVENT_ENTER_REGION_345032" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 345007, 345016 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_345020", "CHALLENGE_SUCCESS_345021", "CHALLENGE_FAIL_345022" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { 345033, 345034 },
		gadgets = { 345008, 345015, 345040, 345041, 345042 },
		regions = { 345023 },
		triggers = { "ENTER_REGION_345023" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { 345001, 345002, 345030 },
		gadgets = { 345009, 345017 },
		regions = { 345010 },
		triggers = { "ENTER_REGION_345010" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { 345003, 345004, 345024 },
		gadgets = { 345011, 345018 },
		regions = { 345012 },
		triggers = { "ENTER_REGION_345012" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { 345005, 345006, 345014 },
		gadgets = { 345013, 345019, 345035, 345036, 345037, 345038, 345039 },
		regions = { 345028 },
		triggers = { "ENTER_REGION_345028" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 节点4,
		monsters = { 345025, 345026, 345027 },
		gadgets = { 345029, 345031 },
		regions = { 345032 },
		triggers = { "ENTER_REGION_345032" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_345010(context, evt)
	if evt.param1 ~= 345010 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_345010(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210345, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_345012(context, evt)
	if evt.param1 ~= 345012 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_345012(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345011 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345018 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210345, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_345020(context, evt)
	if 345007 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasStarted"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_345020(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为207的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 207, 60, 4, 888, 5) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 将configid为 345016 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 345016, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210345, 4)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_345021(context, evt)
	-- 将configid为 345007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 345007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 7)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345015 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 2)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133210345, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_345022(context, evt)
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将configid为 345007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 345007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 345016 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 345016, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 7)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 2)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_345023(context, evt)
	if evt.param1 ~= 345023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_345028(context, evt)
	if evt.param1 ~= 345028 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_345028(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210345, 7)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_345032(context, evt)
	if evt.param1 ~= 345032 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_345032(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345029 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 345031 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210345, 2)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133210345, 6)
	
	return 0
end

require "V2_0/ElectricCore"