-- 基础信息
local base_info = {
	group_id = 133210421
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 421001, monster_id = 21010201, pos = { x = -3555.134, y = 209.192, z = -584.904 }, rot = { x = 0.000, y = 23.413, z = 0.000 }, level = 28, drop_id = 1000100, area_id = 17 },
	{ config_id = 421002, monster_id = 21010201, pos = { x = -3569.279, y = 210.511, z = -579.228 }, rot = { x = 0.000, y = 34.500, z = 0.000 }, level = 28, drop_id = 1000100, area_id = 17 },
	{ config_id = 421003, monster_id = 21011601, pos = { x = -3568.893, y = 213.306, z = -570.320 }, rot = { x = 0.000, y = 31.571, z = 0.000 }, level = 28, drop_id = 1000100, area_id = 17 },
	{ config_id = 421004, monster_id = 21010701, pos = { x = -3565.337, y = 210.045, z = -581.690 }, rot = { x = 0.000, y = 44.714, z = 0.000 }, level = 28, drop_id = 1000100, area_id = 17 },
	{ config_id = 421005, monster_id = 21010701, pos = { x = -3558.517, y = 209.049, z = -584.588 }, rot = { x = 0.000, y = 15.265, z = 0.000 }, level = 28, drop_id = 1000100, area_id = 17 },
	{ config_id = 421006, monster_id = 21020201, pos = { x = -3565.157, y = 210.378, z = -580.121 }, rot = { x = 0.000, y = 39.098, z = 0.000 }, level = 30, drop_id = 1000100, area_id = 17 },
	{ config_id = 421010, monster_id = 21020701, pos = { x = -3559.335, y = 209.622, z = -581.902 }, rot = { x = 0.000, y = 23.413, z = 0.000 }, level = 30, drop_id = 1000100, area_id = 17 },
	{ config_id = 421011, monster_id = 21030601, pos = { x = -3568.871, y = 213.297, z = -570.350 }, rot = { x = 0.000, y = 38.861, z = 0.000 }, level = 30, drop_id = 1000100, area_id = 17 },
	{ config_id = 421013, monster_id = 21030101, pos = { x = -3552.870, y = 210.013, z = -582.043 }, rot = { x = 0.000, y = 343.680, z = 0.000 }, level = 30, drop_id = 1000100, area_id = 17 },
	{ config_id = 421017, monster_id = 21011001, pos = { x = -3562.500, y = 210.253, z = -579.880 }, rot = { x = 0.000, y = 24.133, z = 0.000 }, level = 30, drop_id = 1000100, area_id = 17 },
	{ config_id = 421019, monster_id = 25080201, pos = { x = -3567.836, y = 210.799, z = -578.494 }, rot = { x = 0.000, y = 47.782, z = 0.000 }, level = 31, drop_id = 1000100, pose_id = 1, area_id = 17 },
	{ config_id = 421020, monster_id = 25080201, pos = { x = -3556.475, y = 209.936, z = -581.573 }, rot = { x = 0.000, y = 357.094, z = 0.000 }, level = 31, drop_id = 1000100, pose_id = 1, area_id = 17 },
	{ config_id = 421021, monster_id = 25010501, pos = { x = -3568.923, y = 213.281, z = -570.466 }, rot = { x = 0.000, y = 61.980, z = 0.000 }, level = 31, drop_id = 1000100, area_id = 17 },
	{ config_id = 421022, monster_id = 25010301, pos = { x = -3570.505, y = 211.171, z = -576.478 }, rot = { x = 0.000, y = 49.968, z = 0.000 }, level = 31, drop_id = 1000100, area_id = 17 },
	{ config_id = 421023, monster_id = 25030201, pos = { x = -3564.003, y = 210.115, z = -580.901 }, rot = { x = 0.000, y = 27.926, z = 0.000 }, level = 31, drop_id = 1000100, area_id = 17 },
	{ config_id = 421024, monster_id = 25080101, pos = { x = -3559.498, y = 210.688, z = -578.966 }, rot = { x = 0.000, y = 23.109, z = 0.000 }, level = 28, drop_id = 1000100, pose_id = 1, area_id = 17 },
	{ config_id = 421025, monster_id = 25080101, pos = { x = -3565.026, y = 210.815, z = -577.013 }, rot = { x = 0.000, y = 47.782, z = 0.000 }, level = 28, drop_id = 1000100, pose_id = 1, area_id = 17 },
	{ config_id = 421026, monster_id = 25100101, pos = { x = -3557.536, y = 209.298, z = -583.028 }, rot = { x = 0.000, y = 13.670, z = 0.000 }, level = 32, drop_id = 1000100, pose_id = 1, area_id = 17 },
	{ config_id = 421027, monster_id = 25100201, pos = { x = -3566.125, y = 210.467, z = -579.664 }, rot = { x = 0.000, y = 44.714, z = 0.000 }, level = 32, drop_id = 1000100, pose_id = 1, area_id = 17 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 421007, gadget_id = 70350036, pos = { x = -3554.113, y = 217.082, z = -559.415 }, rot = { x = 356.242, y = 100.828, z = 343.881 }, level = 19, area_id = 17 },
	{ config_id = 421008, gadget_id = 70350023, pos = { x = -3554.088, y = 217.101, z = -559.359 }, rot = { x = 356.242, y = 100.828, z = 343.881 }, level = 19, persistent = true, area_id = 17 },
	{ config_id = 421029, gadget_id = 70330115, pos = { x = -3557.882, y = 215.905, z = -562.066 }, rot = { x = 14.022, y = 168.353, z = 350.344 }, level = 30, area_id = 17 },
	{ config_id = 421031, gadget_id = 70330115, pos = { x = -3563.070, y = 210.967, z = -577.346 }, rot = { x = 354.029, y = 95.038, z = 340.967 }, level = 30, area_id = 17 },
	{ config_id = 421032, gadget_id = 70350023, pos = { x = -3554.088, y = 217.101, z = -559.359 }, rot = { x = 356.242, y = 100.828, z = 343.881 }, level = 30, state = GadgetState.GearAction1, persistent = true, area_id = 17 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	-- 111结束刷222
	{ config_id = 1421009, name = "MONSTER_TIDE_DIE_421009", event = EventType.EVENT_MONSTER_TIDE_DIE, source = "111", condition = "condition_EVENT_MONSTER_TIDE_DIE_421009", action = "action_EVENT_MONSTER_TIDE_DIE_421009", trigger_count = 0 },
	{ config_id = 1421012, name = "ANY_MONSTER_DIE_421012", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "", action = "action_EVENT_ANY_MONSTER_DIE_421012", trigger_count = 0 },
	-- 选择操作台时开启挑战
	{ config_id = 1421014, name = "SELECT_OPTION_421014", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_421014", action = "action_EVENT_SELECT_OPTION_421014", trigger_count = 0 },
	{ config_id = 1421015, name = "CHALLENGE_SUCCESS_421015", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_421015", trigger_count = 0 },
	{ config_id = 1421016, name = "CHALLENGE_FAIL_421016", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_421016", trigger_count = 0 },
	-- 任务03已开始
	{ config_id = 1421018, name = "QUEST_START_421018", event = EventType.EVENT_QUEST_START, source = "7214603", condition = "", action = "action_EVENT_QUEST_START_421018", trigger_count = 0 },
	-- 开启挑战
	{ config_id = 1421028, name = "ANY_MONSTER_LIVE_421028", event = EventType.EVENT_ANY_MONSTER_LIVE, source = "", condition = "condition_EVENT_ANY_MONSTER_LIVE_421028", action = "action_EVENT_ANY_MONSTER_LIVE_421028" },
	-- 任务03开始时加操作台
	{ config_id = 1421033, name = "VARIABLE_CHANGE_421033", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_421033", action = "action_EVENT_VARIABLE_CHANGE_421033" },
	-- group加载时任务03已开始加操作台
	{ config_id = 1421034, name = "GROUP_LOAD_421034", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "condition_EVENT_GROUP_LOAD_421034", action = "action_EVENT_GROUP_LOAD_421034", trigger_count = 0 },
	-- 04开始
	{ config_id = 1421035, name = "QUEST_START_421035", event = EventType.EVENT_QUEST_START, source = "7214604", condition = "", action = "action_EVENT_QUEST_START_421035", trigger_count = 0 },
	-- group加载时如果任务01已开始加载镇石
	{ config_id = 1421036, name = "GROUP_LOAD_421036", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "condition_EVENT_GROUP_LOAD_421036", action = "action_EVENT_GROUP_LOAD_421036", trigger_count = 0 },
	-- 01开始
	{ config_id = 1421039, name = "QUEST_START_421039", event = EventType.EVENT_QUEST_START, source = "7214601", condition = "", action = "action_EVENT_QUEST_START_421039", trigger_count = 0 },
	-- 任务01开始加载镇石
	{ config_id = 1421040, name = "VARIABLE_CHANGE_421040", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_421040", action = "action_EVENT_VARIABLE_CHANGE_421040" },
	-- group加载时如果任务04已开始卸载镇石
	{ config_id = 1421041, name = "GROUP_LOAD_421041", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "condition_EVENT_GROUP_LOAD_421041", action = "action_EVENT_GROUP_LOAD_421041", trigger_count = 0 },
	-- 222结束刷333
	{ config_id = 1421042, name = "MONSTER_TIDE_DIE_421042", event = EventType.EVENT_MONSTER_TIDE_DIE, source = "222", condition = "condition_EVENT_MONSTER_TIDE_DIE_421042", action = "action_EVENT_MONSTER_TIDE_DIE_421042", trigger_count = 0 },
	-- 333结束刷444
	{ config_id = 1421043, name = "MONSTER_TIDE_DIE_421043", event = EventType.EVENT_MONSTER_TIDE_DIE, source = "333", condition = "condition_EVENT_MONSTER_TIDE_DIE_421043", action = "action_EVENT_MONSTER_TIDE_DIE_421043", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "deadMonster", value = 0, no_refresh = false },
	{ config_id = 2, name = "hasFinished", value = 0, no_refresh = false },
	{ config_id = 3, name = "QuestStart", value = 0, no_refresh = true }
}

-- 废弃数据
garbages = {
	gadgets = {
		{ config_id = 421030, gadget_id = 70330116, pos = { x = -3556.274, y = 215.791, z = -563.169 }, rot = { x = 1.556, y = 118.536, z = 343.099 }, level = 30, area_id = 17 }
	}
}

-- 视野组
sight_groups = {
	{ 421026, 421027 }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "MONSTER_TIDE_DIE_421009", "ANY_MONSTER_DIE_421012", "SELECT_OPTION_421014", "CHALLENGE_SUCCESS_421015", "CHALLENGE_FAIL_421016", "QUEST_START_421018", "ANY_MONSTER_LIVE_421028", "VARIABLE_CHANGE_421033", "GROUP_LOAD_421034", "QUEST_START_421035", "GROUP_LOAD_421036", "QUEST_START_421039", "VARIABLE_CHANGE_421040", "GROUP_LOAD_421041", "MONSTER_TIDE_DIE_421042", "MONSTER_TIDE_DIE_421043" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 421007, 421029, 421031 },
		regions = { },
		triggers = { "GROUP_LOAD_421041" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 421008 },
		regions = { },
		triggers = { "GROUP_LOAD_421041" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 421032 },
		regions = { },
		triggers = { "GROUP_LOAD_421041" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_MONSTER_TIDE_DIE_421009(context, evt)
	if 10 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_MONSTER_TIDE_DIE_421009(context, evt)
	-- 创建编号为222（该怪物潮的识别id)的怪物潮，创建怪物总数为10，场上怪物最少1只，最多5只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 222, 133210421, {421006,421010,421011,421013,421017}, 10, 1, 5) then
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_421012(context, evt)
	-- 针对当前group内变量名为 "deadMonster" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "deadMonster", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_421014(context, evt)
	-- 判断是gadgetid 421008 option_id 65
	if 421008 ~= evt.param1 then
		return false	
	end
	
	if 65 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_421014(context, evt)
	-- 将configid为 421008 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421008, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210421, 2)
	
	-- 删除指定group： 133210421 ；指定config：421008；物件身上指定option：65；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133210421, 421008, 65) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
	-- 创建编号为111（该怪物潮的识别id)的怪物潮，创建怪物总数为10，场上怪物最少5只，最多5只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 111, 133210421, {421001,421002,421003,421004,421005}, 10, 5, 5) then
		return -1
	end
	
	-- 调用提示id为 32100105 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 32100105) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_421015(context, evt)
	-- 针对当前group内变量名为 "hasFinished" 的变量，进行修改，变化值为 1
	if 0 ~= ScriptLib.ChangeGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : change_GroupVariable")
	  return -1
	end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "7214603") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	-- 将本组内变量名为 "QuestStart" 的变量设置为 3
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "QuestStart", 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133210421, suite = 4 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_421016(context, evt)
	--销毁编号为111（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133210421, 111) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
	end
	
	--销毁编号为222（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133210421, 222) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
	end
	
	--销毁编号为333（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133210421, 333) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
	end
	
	--销毁编号为444（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133210421, 444) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
	end
	
	
	-- 将configid为 421008 的物件更改为状态 GadgetState.GearAction2
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421008, GadgetState.GearAction2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将本组内变量名为 "deadMonster" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "deadMonster", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133210421, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210421, 3)
	
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133210421, 421008, {65}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_START_421018(context, evt)
	-- 将本组内变量名为 "QuestStart" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "QuestStart", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_LIVE_421028(context, evt)
	if 421001 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_LIVE_421028(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为251的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.StartChallenge(context, 666, 251, {120,133210421,421007,0,5}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_start_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_421033(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"QuestStart"为2
	if ScriptLib.GetGroupVariableValue(context, "QuestStart") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_421033(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133210421, 421008, {65}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GROUP_LOAD_421034(context, evt)
	-- 判断变量"QuestStart"为2
	if ScriptLib.GetGroupVariableValue(context, "QuestStart") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GROUP_LOAD_421034(context, evt)
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133210421, 3)
	
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133210421, 421008, {65}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_START_421035(context, evt)
	-- 将本组内变量名为 "QuestStart" 的变量设置为 3
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "QuestStart", 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GROUP_LOAD_421036(context, evt)
	-- 判断变量"QuestStart"为1
	if ScriptLib.GetGroupVariableValue(context, "QuestStart") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GROUP_LOAD_421036(context, evt)
	-- 创建id为421008的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 421008 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_QUEST_START_421039(context, evt)
	-- 将本组内变量名为 "QuestStart" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "QuestStart", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_421040(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"QuestStart"为1
	if ScriptLib.GetGroupVariableValue(context, "QuestStart") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_421040(context, evt)
	-- 创建id为421008的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 421008 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GROUP_LOAD_421041(context, evt)
	-- 判断变量"QuestStart"为3
	if ScriptLib.GetGroupVariableValue(context, "QuestStart") ~= 3 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GROUP_LOAD_421041(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133210421, suite = 5 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_MONSTER_TIDE_DIE_421042(context, evt)
	if 10 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_MONSTER_TIDE_DIE_421042(context, evt)
	-- 创建编号为333（该怪物潮的识别id)的怪物潮，创建怪物总数为10，场上怪物最少1只，最多5只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 333, 133210421, {421019,421020,421021,421022,421023}, 10, 1, 5) then
		return -1
	end
	
	-- 调用提示id为 32100178 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 32100178) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_MONSTER_TIDE_DIE_421043(context, evt)
	if 10 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_MONSTER_TIDE_DIE_421043(context, evt)
	-- 创建编号为444（该怪物潮的识别id)的怪物潮，创建怪物总数为20，场上怪物最少2只，最多2只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 444, 133210421, {421024,421025,421026,421027}, 20, 2, 2) then
		return -1
	end
	
	-- 调用提示id为 32100179 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 32100179) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end