-- 基础信息
local base_info = {
	group_id = 133212188
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 188001, monster_id = 20011201, pos = { x = -3611.666, y = 208.327, z = -2264.733 }, rot = { x = 0.000, y = 138.726, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188002, monster_id = 20011201, pos = { x = -3609.305, y = 208.031, z = -2264.277 }, rot = { x = 0.000, y = 161.159, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188003, monster_id = 20010501, pos = { x = -3660.939, y = 203.753, z = -2238.089 }, rot = { x = 0.000, y = 176.526, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188004, monster_id = 20010501, pos = { x = -3663.556, y = 203.883, z = -2239.206 }, rot = { x = 0.000, y = 159.631, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188005, monster_id = 20010801, pos = { x = -3681.622, y = 208.678, z = -2138.631 }, rot = { x = 0.000, y = 141.192, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188006, monster_id = 20010801, pos = { x = -3675.414, y = 209.064, z = -2138.681 }, rot = { x = 0.000, y = 212.314, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188030, monster_id = 20011201, pos = { x = -3612.951, y = 208.060, z = -2267.178 }, rot = { x = 0.000, y = 131.714, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188031, monster_id = 20010501, pos = { x = -3667.153, y = 203.859, z = -2240.610 }, rot = { x = 0.000, y = 157.315, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 },
	{ config_id = 188043, monster_id = 20010801, pos = { x = -3678.069, y = 208.266, z = -2143.169 }, rot = { x = 0.000, y = 35.929, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, climate_area_id = 9, area_id = 13 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 188007, gadget_id = 70360005, pos = { x = -3584.832, y = 202.949, z = -2314.451 }, rot = { x = 3.279, y = 67.223, z = 0.197 }, level = 19, persistent = true, area_id = 13 },
	{ config_id = 188008, gadget_id = 70360025, pos = { x = -3688.713, y = 228.262, z = -2093.338 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188009, gadget_id = 70350085, pos = { x = -3609.310, y = 207.560, z = -2267.433 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188010, gadget_id = 70300114, pos = { x = -3609.310, y = 207.560, z = -2267.433 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188011, gadget_id = 70350085, pos = { x = -3661.021, y = 203.694, z = -2241.406 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188012, gadget_id = 70300114, pos = { x = -3661.029, y = 203.695, z = -2241.425 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188013, gadget_id = 70350085, pos = { x = -3678.467, y = 208.579, z = -2141.052 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188014, gadget_id = 70300114, pos = { x = -3678.486, y = 208.579, z = -2141.052 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188015, gadget_id = 70350085, pos = { x = -3688.713, y = 228.957, z = -2093.338 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188016, gadget_id = 70350085, pos = { x = -3584.782, y = 204.781, z = -2314.454 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188017, gadget_id = 70710126, pos = { x = -3609.310, y = 207.560, z = -2267.433 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188018, gadget_id = 70710126, pos = { x = -3661.021, y = 203.694, z = -2241.406 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188019, gadget_id = 70710126, pos = { x = -3678.467, y = 208.579, z = -2141.052 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 188032, gadget_id = 70330064, pos = { x = -3664.086, y = 203.943, z = -2233.777 }, rot = { x = 0.000, y = 350.021, z = 0.000 }, level = 27, interact_id = 35, area_id = 13 },
	{ config_id = 188033, gadget_id = 70900380, pos = { x = -3658.384, y = 213.337, z = -2225.925 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188034, gadget_id = 70900380, pos = { x = -3664.612, y = 216.398, z = -2202.940 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188035, gadget_id = 70900380, pos = { x = -3673.683, y = 219.620, z = -2182.177 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188036, gadget_id = 70900380, pos = { x = -3689.914, y = 233.704, z = -2103.344 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188037, gadget_id = 70900380, pos = { x = -3681.747, y = 216.931, z = -2161.587 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188038, gadget_id = 70900380, pos = { x = -3685.577, y = 226.508, z = -2111.575 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 13 },
	{ config_id = 188039, gadget_id = 70330064, pos = { x = -3671.758, y = 208.569, z = -2140.944 }, rot = { x = 0.000, y = 350.021, z = 0.000 }, level = 27, interact_id = 35, area_id = 13 },
	{ config_id = 188040, gadget_id = 70330064, pos = { x = -3677.049, y = 202.876, z = -2201.654 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 13 },
	{ config_id = 188041, gadget_id = 70330064, pos = { x = -3660.928, y = 201.913, z = -2179.149 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 13 },
	{ config_id = 188042, gadget_id = 70330064, pos = { x = -3667.801, y = 202.947, z = -2159.326 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 13 }
}

-- 区域
regions = {
	{ config_id = 188023, shape = RegionShape.SPHERE, radius = 2, pos = { x = -3688.748, y = 227.637, z = -2093.366 }, area_id = 13 },
	{ config_id = 188024, shape = RegionShape.SPHERE, radius = 7, pos = { x = -3609.222, y = 207.563, z = -2267.290 }, area_id = 13 },
	{ config_id = 188026, shape = RegionShape.SPHERE, radius = 7, pos = { x = -3661.029, y = 203.695, z = -2241.425 }, area_id = 13 },
	{ config_id = 188028, shape = RegionShape.SPHERE, radius = 7, pos = { x = -3678.467, y = 208.579, z = -2141.052 }, area_id = 13 }
}

-- 触发器
triggers = {
	{ config_id = 1188020, name = "GADGET_STATE_CHANGE_188020", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_188020", action = "action_EVENT_GADGET_STATE_CHANGE_188020", trigger_count = 0 },
	{ config_id = 1188021, name = "CHALLENGE_SUCCESS_188021", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_188021", trigger_count = 0 },
	{ config_id = 1188022, name = "CHALLENGE_FAIL_188022", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_188022", trigger_count = 0 },
	{ config_id = 1188023, name = "ENTER_REGION_188023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_188023", action = "action_EVENT_ENTER_REGION_188023", trigger_count = 0, tag = "888" },
	{ config_id = 1188024, name = "ENTER_REGION_188024", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_188024", action = "action_EVENT_ENTER_REGION_188024" },
	{ config_id = 1188025, name = "ANY_MONSTER_DIE_188025", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_188025", action = "" },
	{ config_id = 1188026, name = "ENTER_REGION_188026", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_188026", action = "action_EVENT_ENTER_REGION_188026" },
	{ config_id = 1188027, name = "ANY_MONSTER_DIE_188027", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_188027", action = "" },
	{ config_id = 1188028, name = "ENTER_REGION_188028", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_188028", action = "action_EVENT_ENTER_REGION_188028" },
	{ config_id = 1188029, name = "ANY_MONSTER_DIE_188029", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_188029", action = "" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 188007, 188016 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_188020", "CHALLENGE_SUCCESS_188021", "CHALLENGE_FAIL_188022" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 188008, 188015, 188036, 188038, 188039 },
		regions = { 188023 },
		triggers = { "ENTER_REGION_188023" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { },
		gadgets = { 188009, 188010, 188017 },
		regions = { 188024 },
		triggers = { "ENTER_REGION_188024", "ANY_MONSTER_DIE_188025" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { },
		gadgets = { 188011, 188012, 188018 },
		regions = { 188026 },
		triggers = { "ENTER_REGION_188026", "ANY_MONSTER_DIE_188027" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { },
		gadgets = { 188013, 188014, 188019, 188032, 188033, 188034, 188035, 188037 },
		regions = { 188028 },
		triggers = { "ENTER_REGION_188028", "ANY_MONSTER_DIE_188029" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 埋伏怪1,
		monsters = { 188001, 188002, 188030 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = 埋伏怪2,
		monsters = { 188003, 188004, 188031 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = 埋伏怪3,
		monsters = { 188005, 188006, 188043 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 10,
		-- description = 辅助用雷樱枝条,
		monsters = { },
		gadgets = { 188040, 188041, 188042 },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_188020(context, evt)
	if 188007 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasStarted"为0
	if ScriptLib.GetGroupVariableValue(context, "hasStarted") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_188020(context, evt)
	-- 创建编号为666（该挑战的识别id),挑战内容为207的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 207, 120, 4, 888, 15) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 将configid为 188016 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 188016, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 4)
	
	-- 添加suite10的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 10)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_188021(context, evt)
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133212188, 2)
	
	-- 将configid为 188007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 188007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188015 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 6)
	
	-- 删除suite10的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 10)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133212188, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_188022(context, evt)
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 将configid为 188007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 188007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将configid为 188016 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 188016, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133212188, 4)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133212188, 5)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133212188, 6)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 2)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 7)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 8)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 9)
	
	-- 删除suite10的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 10)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_188023(context, evt)
	if evt.param1 ~= 188023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_188023(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_188024(context, evt)
	if evt.param1 ~= 188024 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_188024(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 188010 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 188010, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 7)
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 5)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_188025(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_188026(context, evt)
	if evt.param1 ~= 188026 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_188026(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188011 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188018 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 8)
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 6)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_188027(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_188028(context, evt)
	if evt.param1 ~= 188028 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_188028(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 188019 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite9的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 9)
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212188, 2)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212188, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_188029(context, evt)
	-- 判断剩余怪物数量是否是0
	if ScriptLib.GetGroupMonsterCount(context) ~= 0 then
		return false
	end
	
	return true
end

require "V2_0/ElectricCore"