-- 基础信息
local base_info = {
	group_id = 133212190
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 190001, gadget_id = 70710126, pos = { x = -3823.485, y = 309.339, z = -2386.843 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190002, gadget_id = 70350085, pos = { x = -3823.485, y = 311.006, z = -2386.843 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190003, gadget_id = 70360005, pos = { x = -3899.657, y = 304.226, z = -2254.597 }, rot = { x = 358.300, y = 246.504, z = 357.200 }, level = 19, area_id = 13 },
	{ config_id = 190004, gadget_id = 70710126, pos = { x = -3861.085, y = 295.550, z = -2326.022 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190005, gadget_id = 70350085, pos = { x = -3861.085, y = 296.235, z = -2326.022 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190006, gadget_id = 70350085, pos = { x = -3899.657, y = 306.893, z = -2254.597 }, rot = { x = 0.000, y = 299.294, z = 0.000 }, level = 19, area_id = 13 },
	{ config_id = 190007, gadget_id = 70710126, pos = { x = -3823.531, y = 282.361, z = -2438.101 }, rot = { x = 0.000, y = 325.738, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190008, gadget_id = 70350085, pos = { x = -3823.531, y = 282.361, z = -2438.101 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190009, gadget_id = 70360025, pos = { x = -3801.635, y = 200.860, z = -2653.853 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190010, gadget_id = 70900380, pos = { x = -3838.697, y = 317.967, z = -2367.784 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190011, gadget_id = 70900380, pos = { x = -3894.449, y = 305.541, z = -2263.265 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190014, gadget_id = 70350085, pos = { x = -3801.635, y = 201.982, z = -2653.853 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 13 },
	{ config_id = 190022, gadget_id = 70900380, pos = { x = -3886.683, y = 305.541, z = -2284.405 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190024, gadget_id = 70330064, pos = { x = -3903.157, y = 305.015, z = -2256.223 }, rot = { x = 0.000, y = 335.323, z = 0.000 }, level = 1, interact_id = 35, area_id = 13 },
	{ config_id = 190026, gadget_id = 70900380, pos = { x = -3878.283, y = 304.870, z = -2306.178 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190029, gadget_id = 70900380, pos = { x = -3857.988, y = 305.979, z = -2333.817 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190031, gadget_id = 70900380, pos = { x = -3853.494, y = 312.863, z = -2344.501 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190033, gadget_id = 70900380, pos = { x = -3847.625, y = 316.555, z = -2357.517 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190037, gadget_id = 70330064, pos = { x = -3838.383, y = 307.018, z = -2381.102 }, rot = { x = 0.000, y = 335.323, z = 0.000 }, level = 1, interact_id = 35, area_id = 13 },
	{ config_id = 190040, gadget_id = 70900380, pos = { x = -3823.180, y = 306.764, z = -2401.461 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190042, gadget_id = 70900380, pos = { x = -3823.421, y = 296.239, z = -2421.583 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190046, gadget_id = 70900380, pos = { x = -3826.221, y = 289.320, z = -2449.407 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190048, gadget_id = 70900380, pos = { x = -3830.505, y = 296.304, z = -2468.223 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190051, gadget_id = 70690001, pos = { x = -3834.011, y = 293.479, z = -2487.726 }, rot = { x = 342.024, y = 11.428, z = 25.636 }, level = 1, area_id = 13 },
	{ config_id = 190053, gadget_id = 70690001, pos = { x = -3839.252, y = 286.641, z = -2507.584 }, rot = { x = 332.895, y = 15.994, z = 23.257 }, level = 1, area_id = 13 },
	{ config_id = 190055, gadget_id = 70690001, pos = { x = -3839.509, y = 277.695, z = -2529.742 }, rot = { x = 333.132, y = 357.426, z = 29.282 }, level = 1, area_id = 13 },
	{ config_id = 190057, gadget_id = 70690001, pos = { x = -3836.416, y = 268.640, z = -2551.811 }, rot = { x = 328.645, y = 344.104, z = 29.683 }, level = 1, area_id = 13 },
	{ config_id = 190059, gadget_id = 70690001, pos = { x = -3826.674, y = 257.180, z = -2578.039 }, rot = { x = 332.292, y = 337.514, z = 34.571 }, level = 1, area_id = 13 },
	{ config_id = 190061, gadget_id = 70690001, pos = { x = -3816.141, y = 245.086, z = -2609.021 }, rot = { x = 329.951, y = 339.346, z = 26.212 }, level = 1, area_id = 13 },
	{ config_id = 190063, gadget_id = 70690001, pos = { x = -3801.693, y = 221.714, z = -2653.866 }, rot = { x = 90.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190064, gadget_id = 70690001, pos = { x = -3801.693, y = 229.411, z = -2653.458 }, rot = { x = 90.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190065, gadget_id = 70690001, pos = { x = -3801.693, y = 213.547, z = -2653.866 }, rot = { x = 90.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 },
	{ config_id = 190066, gadget_id = 70690001, pos = { x = -3801.693, y = 205.598, z = -2653.866 }, rot = { x = 90.000, y = 0.000, z = 0.000 }, level = 1, area_id = 13 }
}

-- 区域
regions = {
	{ config_id = 190016, shape = RegionShape.SPHERE, radius = 5, pos = { x = -3825.834, y = 307.442, z = -2388.601 }, area_id = 13 },
	{ config_id = 190017, shape = RegionShape.SPHERE, radius = 5, pos = { x = -3861.527, y = 297.878, z = -2325.629 }, area_id = 13 },
	{ config_id = 190021, shape = RegionShape.SPHERE, radius = 5, pos = { x = -3823.330, y = 282.361, z = -2438.201 }, area_id = 13 },
	{ config_id = 190023, shape = RegionShape.SPHERE, radius = 3, pos = { x = -3801.635, y = 201.982, z = -2653.853 }, area_id = 13 }
}

-- 触发器
triggers = {
	{ config_id = 1190016, name = "ENTER_REGION_190016", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_190016", action = "action_EVENT_ENTER_REGION_190016", tag = "666" },
	{ config_id = 1190017, name = "ENTER_REGION_190017", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_190017", action = "action_EVENT_ENTER_REGION_190017", tag = "666" },
	{ config_id = 1190018, name = "CHALLENGE_SUCCESS_190018", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_190018", trigger_count = 0 },
	{ config_id = 1190019, name = "CHALLENGE_FAIL_190019", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_190019", trigger_count = 0 },
	{ config_id = 1190020, name = "GADGET_STATE_CHANGE_190020", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_190020", action = "action_EVENT_GADGET_STATE_CHANGE_190020", trigger_count = 0 },
	{ config_id = 1190021, name = "ENTER_REGION_190021", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_190021", action = "action_EVENT_ENTER_REGION_190021", tag = "666" },
	{ config_id = 1190023, name = "ENTER_REGION_190023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_190023", action = "action_EVENT_ENTER_REGION_190023", tag = "666" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 6,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 190003, 190006, 190024 },
		regions = { },
		triggers = { "CHALLENGE_SUCCESS_190018", "CHALLENGE_FAIL_190019", "GADGET_STATE_CHANGE_190020" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = checkpoint 1,
		monsters = { },
		gadgets = { 190004, 190005, 190011, 190022, 190026 },
		regions = { 190017 },
		triggers = { "ENTER_REGION_190017" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = checkpoint 2,
		monsters = { },
		gadgets = { 190001, 190002, 190010, 190029, 190031, 190033, 190037 },
		regions = { 190016 },
		triggers = { "ENTER_REGION_190016" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = checkpoint 3,
		monsters = { },
		gadgets = { 190007, 190008, 190040, 190042 },
		regions = { 190021 },
		triggers = { "ENTER_REGION_190021" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 终点,
		monsters = { },
		gadgets = { 190009, 190014, 190046, 190048, 190051, 190053, 190055, 190057, 190059, 190061, 190063, 190064, 190065, 190066 },
		regions = { 190023 },
		triggers = { "ENTER_REGION_190023" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = end_suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_190016(context, evt)
	if evt.param1 ~= 190016 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_190016(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190001 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190002 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212190, 4)
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212190, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_190017(context, evt)
	if evt.param1 ~= 190017 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_190017(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190004 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190005 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212190, 3)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212190, 2)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_190018(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133212190, 5)
	
	-- 将configid为 190003 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 190003, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133212190, 6) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_190019(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133212190, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_190020(context, evt)
	if 190003 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_190020(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212190, 2)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 创建编号为888（该挑战的识别id),挑战内容为241的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 241, 90, 4, 666, 4) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_190021(context, evt)
	if evt.param1 ~= 190021 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_190021(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133212190, 5)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133212190, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_190023(context, evt)
	if evt.param1 ~= 190023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_190023(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 190009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

require "V2_0/ElectricCore"