-- 基础信息
local base_info = {
	group_id = 133213181
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 181001, gadget_id = 70710126, pos = { x = -3284.131, y = 236.585, z = -3455.270 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181002, gadget_id = 70350085, pos = { x = -3284.131, y = 236.585, z = -3455.270 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181003, gadget_id = 70360005, pos = { x = -3255.208, y = 222.035, z = -3427.790 }, rot = { x = 354.900, y = 299.294, z = 344.850 }, level = 19, area_id = 12 },
	{ config_id = 181004, gadget_id = 70710126, pos = { x = -3249.622, y = 241.003, z = -3442.998 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181005, gadget_id = 70350085, pos = { x = -3249.622, y = 241.003, z = -3442.998 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181006, gadget_id = 70350085, pos = { x = -3255.208, y = 223.039, z = -3427.790 }, rot = { x = 0.000, y = 299.294, z = 0.000 }, level = 19, area_id = 12 },
	{ config_id = 181007, gadget_id = 70710126, pos = { x = -3342.381, y = 254.174, z = -3465.531 }, rot = { x = 0.000, y = 325.738, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181008, gadget_id = 70350085, pos = { x = -3342.381, y = 254.174, z = -3465.531 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181009, gadget_id = 70360025, pos = { x = -3148.066, y = 200.700, z = -3486.120 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181010, gadget_id = 70350085, pos = { x = -3254.135, y = 232.310, z = -3490.346 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181011, gadget_id = 70330064, pos = { x = -3250.162, y = 222.184, z = -3430.238 }, rot = { x = 0.000, y = 299.346, z = 0.000 }, level = 19, interact_id = 35, area_id = 12 },
	{ config_id = 181012, gadget_id = 70900380, pos = { x = -3252.603, y = 241.217, z = -3434.102 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181013, gadget_id = 70330064, pos = { x = -3279.547, y = 228.740, z = -3460.994 }, rot = { x = 0.000, y = 297.437, z = 0.000 }, level = 19, interact_id = 35, area_id = 12 },
	{ config_id = 181014, gadget_id = 70330064, pos = { x = -3349.396, y = 238.533, z = -3471.467 }, rot = { x = 0.000, y = 288.848, z = 0.000 }, level = 19, interact_id = 35, area_id = 12 },
	{ config_id = 181015, gadget_id = 70900380, pos = { x = -3254.700, y = 229.920, z = -3428.282 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181016, gadget_id = 70900380, pos = { x = -3263.871, y = 241.509, z = -3496.144 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181017, gadget_id = 70900380, pos = { x = -3229.479, y = 241.622, z = -3495.599 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181018, gadget_id = 70900380, pos = { x = -3265.658, y = 243.156, z = -3445.235 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181019, gadget_id = 70900380, pos = { x = -3179.289, y = 231.312, z = -3476.918 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181020, gadget_id = 70900380, pos = { x = -3290.650, y = 242.624, z = -3464.429 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181022, gadget_id = 70900380, pos = { x = -3305.649, y = 249.166, z = -3463.083 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181024, gadget_id = 70900380, pos = { x = -3322.875, y = 256.198, z = -3462.002 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181028, gadget_id = 70900380, pos = { x = -3341.129, y = 255.998, z = -3479.477 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181031, gadget_id = 70900380, pos = { x = -3326.428, y = 253.748, z = -3488.915 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181033, gadget_id = 70900380, pos = { x = -3305.573, y = 250.803, z = -3498.026 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181035, gadget_id = 70900380, pos = { x = -3282.097, y = 247.344, z = -3500.841 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181040, gadget_id = 70710126, pos = { x = -3254.135, y = 231.405, z = -3490.346 }, rot = { x = 0.000, y = 325.738, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181041, gadget_id = 70330064, pos = { x = -3231.589, y = 225.941, z = -3518.929 }, rot = { x = 0.000, y = 302.919, z = 0.000 }, level = 19, interact_id = 35, area_id = 12 },
	{ config_id = 181043, gadget_id = 70350085, pos = { x = -3206.243, y = 240.053, z = -3489.718 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181044, gadget_id = 70710126, pos = { x = -3206.243, y = 240.053, z = -3489.718 }, rot = { x = 0.000, y = 325.738, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181046, gadget_id = 70900380, pos = { x = -3243.396, y = 232.944, z = -3492.726 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181047, gadget_id = 70900380, pos = { x = -3217.180, y = 247.114, z = -3496.641 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181049, gadget_id = 70350085, pos = { x = -3148.066, y = 201.363, z = -3486.120 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 12 },
	{ config_id = 181050, gadget_id = 70330064, pos = { x = -3211.823, y = 225.481, z = -3500.470 }, rot = { x = 0.000, y = 259.841, z = 0.000 }, level = 19, interact_id = 35, area_id = 12 },
	{ config_id = 181051, gadget_id = 70900380, pos = { x = -3201.650, y = 239.010, z = -3479.993 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 },
	{ config_id = 181053, gadget_id = 70900380, pos = { x = -3157.888, y = 218.798, z = -3486.188 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 12 }
}

-- 区域
regions = {
	{ config_id = 181057, shape = RegionShape.SPHERE, radius = 4, pos = { x = -3206.351, y = 240.053, z = -3489.997 }, area_id = 12 },
	{ config_id = 181058, shape = RegionShape.SPHERE, radius = 4, pos = { x = -3284.131, y = 236.585, z = -3455.270 }, area_id = 12 },
	{ config_id = 181059, shape = RegionShape.SPHERE, radius = 4, pos = { x = -3249.622, y = 241.003, z = -3442.998 }, area_id = 12 },
	{ config_id = 181063, shape = RegionShape.SPHERE, radius = 4, pos = { x = -3342.381, y = 254.202, z = -3465.531 }, area_id = 12 },
	{ config_id = 181064, shape = RegionShape.SPHERE, radius = 4, pos = { x = -3254.135, y = 231.405, z = -3490.346 }, area_id = 12 },
	{ config_id = 181065, shape = RegionShape.SPHERE, radius = 3, pos = { x = -3148.066, y = 200.700, z = -3486.120 }, area_id = 12 }
}

-- 触发器
triggers = {
	{ config_id = 1181057, name = "ENTER_REGION_181057", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181057", action = "action_EVENT_ENTER_REGION_181057", tag = "666" },
	{ config_id = 1181058, name = "ENTER_REGION_181058", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181058", action = "action_EVENT_ENTER_REGION_181058", tag = "666" },
	{ config_id = 1181059, name = "ENTER_REGION_181059", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181059", action = "action_EVENT_ENTER_REGION_181059", tag = "666" },
	{ config_id = 1181060, name = "CHALLENGE_SUCCESS_181060", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_181060", trigger_count = 0 },
	{ config_id = 1181061, name = "CHALLENGE_FAIL_181061", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_181061", trigger_count = 0 },
	{ config_id = 1181062, name = "GADGET_STATE_CHANGE_181062", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_181062", action = "action_EVENT_GADGET_STATE_CHANGE_181062", trigger_count = 0 },
	{ config_id = 1181063, name = "ENTER_REGION_181063", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181063", action = "action_EVENT_ENTER_REGION_181063", tag = "666" },
	{ config_id = 1181064, name = "ENTER_REGION_181064", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181064", action = "action_EVENT_ENTER_REGION_181064", tag = "666" },
	{ config_id = 1181065, name = "ENTER_REGION_181065", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_181065", action = "action_EVENT_ENTER_REGION_181065", tag = "666" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 8,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 181003, 181006, 181011 },
		regions = { },
		triggers = { "CHALLENGE_SUCCESS_181060", "CHALLENGE_FAIL_181061", "GADGET_STATE_CHANGE_181062" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = checkpoint 1,
		monsters = { },
		gadgets = { 181004, 181005, 181012, 181015 },
		regions = { 181059 },
		triggers = { "ENTER_REGION_181059" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = checkpoint 2,
		monsters = { },
		gadgets = { 181001, 181002, 181013, 181018 },
		regions = { 181058 },
		triggers = { "ENTER_REGION_181058" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = checkpoint 3,
		monsters = { },
		gadgets = { 181007, 181008, 181013, 181014, 181020, 181022, 181024 },
		regions = { 181063 },
		triggers = { "ENTER_REGION_181063" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = checkpoint 4,
		monsters = { },
		gadgets = { 181010, 181014, 181016, 181028, 181031, 181033, 181035, 181040, 181041 },
		regions = { 181064 },
		triggers = { "ENTER_REGION_181064" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = checkpoint 5,
		monsters = { },
		gadgets = { 181017, 181041, 181043, 181044, 181046, 181047, 181050 },
		regions = { 181057 },
		triggers = { "ENTER_REGION_181057" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 终点,
		monsters = { },
		gadgets = { 181009, 181019, 181049, 181050, 181051, 181053 },
		regions = { 181065 },
		triggers = { "ENTER_REGION_181065" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = end_suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_181057(context, evt)
	if evt.param1 ~= 181057 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181057(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181044 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181043 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 7)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133213181, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_181058(context, evt)
	if evt.param1 ~= 181058 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181058(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181001 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181002 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 4)
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133213181, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_181059(context, evt)
	if evt.param1 ~= 181059 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181059(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181004 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181005 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 3)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133213181, 2)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_181060(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133213181, 7)
	
	-- 将configid为 181003 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 181003, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133213181, 8) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_181061(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133213181, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_181062(context, evt)
	if 181003 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_181062(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 2)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 创建编号为888（该挑战的识别id),挑战内容为241的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 241, 90, 4, 666, 6) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_181063(context, evt)
	if evt.param1 ~= 181063 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181063(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 5)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133213181, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_181064(context, evt)
	if evt.param1 ~= 181064 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181064(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181040 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181010 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133213181, 6)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133213181, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_181065(context, evt)
	if evt.param1 ~= 181065 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_181065(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 181009 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

require "V2_0/ElectricCore"