-- 基础信息
local base_info = {
	group_id = 133220053
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 53046, monster_id = 20010501, pos = { x = -2625.595, y = 213.270, z = -4242.546 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53047, monster_id = 20010501, pos = { x = -2626.994, y = 213.014, z = -4244.500 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53048, monster_id = 20010501, pos = { x = -2627.408, y = 212.954, z = -4240.910 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53159, monster_id = 20010501, pos = { x = -2629.031, y = 212.775, z = -4242.482 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53160, monster_id = 20010501, pos = { x = -2578.215, y = 270.471, z = -4360.142 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53161, monster_id = 20010501, pos = { x = -2580.878, y = 271.357, z = -4361.390 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53162, monster_id = 20010501, pos = { x = -2581.344, y = 270.526, z = -4358.887 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 },
	{ config_id = 53163, monster_id = 20010501, pos = { x = -2578.851, y = 270.052, z = -4358.326 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1030 }, area_id = 11 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 53001, gadget_id = 70900380, pos = { x = -2694.751, y = 212.772, z = -4149.515 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53002, gadget_id = 70900380, pos = { x = -2682.181, y = 218.667, z = -4166.505 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53003, gadget_id = 70900380, pos = { x = -2674.202, y = 222.660, z = -4186.747 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53004, gadget_id = 70900380, pos = { x = -2662.198, y = 226.162, z = -4201.792 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53005, gadget_id = 70900380, pos = { x = -2654.802, y = 228.285, z = -4218.656 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53006, gadget_id = 70900380, pos = { x = -2623.844, y = 216.867, z = -4259.835 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53007, gadget_id = 70900380, pos = { x = -2619.592, y = 220.639, z = -4276.688 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53008, gadget_id = 70900380, pos = { x = -2617.586, y = 230.584, z = -4286.838 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53009, gadget_id = 70900380, pos = { x = -2608.107, y = 237.720, z = -4296.432 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53010, gadget_id = 70900380, pos = { x = -2597.729, y = 240.236, z = -4306.883 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53011, gadget_id = 70900380, pos = { x = -2585.806, y = 243.822, z = -4320.578 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53012, gadget_id = 70900380, pos = { x = -2580.801, y = 257.146, z = -4330.539 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53013, gadget_id = 70900380, pos = { x = -2591.339, y = 276.398, z = -4369.493 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53014, gadget_id = 70900380, pos = { x = -2603.478, y = 285.431, z = -4375.667 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53015, gadget_id = 70900380, pos = { x = -2614.210, y = 291.318, z = -4388.513 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53016, gadget_id = 70350085, pos = { x = -2625.928, y = 212.865, z = -4247.407 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53017, gadget_id = 70710126, pos = { x = -2625.999, y = 212.865, z = -4247.351 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53019, gadget_id = 70350085, pos = { x = -2579.846, y = 270.839, z = -4360.762 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53020, gadget_id = 70710126, pos = { x = -2579.674, y = 270.810, z = -4360.733 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53022, gadget_id = 70350085, pos = { x = -2648.921, y = 291.819, z = -4431.902 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53023, gadget_id = 70360025, pos = { x = -2648.584, y = 291.882, z = -4431.794 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53025, gadget_id = 70350083, pos = { x = -2704.150, y = 208.324, z = -4132.347 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, persistent = true, area_id = 11 },
	{ config_id = 53033, gadget_id = 70290150, pos = { x = -2674.692, y = 224.430, z = -4188.424 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53034, gadget_id = 70290150, pos = { x = -2674.205, y = 224.819, z = -4191.359 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53035, gadget_id = 70290150, pos = { x = -2659.092, y = 226.767, z = -4203.278 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53036, gadget_id = 70290150, pos = { x = -2656.828, y = 227.261, z = -4205.026 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53037, gadget_id = 70290150, pos = { x = -2654.960, y = 229.051, z = -4221.312 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53038, gadget_id = 70290150, pos = { x = -2654.416, y = 229.758, z = -4224.276 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53043, gadget_id = 70330064, pos = { x = -2702.648, y = 208.913, z = -4138.726 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 53044, gadget_id = 70330064, pos = { x = -2624.691, y = 212.968, z = -4247.002 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 53045, gadget_id = 70330064, pos = { x = -2577.981, y = 270.920, z = -4363.179 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 53049, gadget_id = 70290150, pos = { x = -2618.685, y = 221.351, z = -4280.849 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53051, gadget_id = 70290150, pos = { x = -2618.309, y = 221.341, z = -4284.234 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53088, gadget_id = 70900380, pos = { x = -2644.646, y = 226.999, z = -4236.284 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53090, gadget_id = 70290150, pos = { x = -2601.083, y = 240.025, z = -4303.186 }, rot = { x = 0.000, y = 332.051, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53092, gadget_id = 70290150, pos = { x = -2588.342, y = 238.823, z = -4316.791 }, rot = { x = 0.000, y = 332.051, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53094, gadget_id = 70290150, pos = { x = -2599.332, y = 240.382, z = -4305.104 }, rot = { x = 0.000, y = 332.051, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53096, gadget_id = 70290150, pos = { x = -2589.632, y = 238.255, z = -4315.309 }, rot = { x = 0.000, y = 332.051, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53114, gadget_id = 70900380, pos = { x = -2630.460, y = 291.668, z = -4392.733 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53115, gadget_id = 70900380, pos = { x = -2581.876, y = 271.890, z = -4334.583 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53116, gadget_id = 70900380, pos = { x = -2585.574, y = 279.818, z = -4346.790 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53117, gadget_id = 70900380, pos = { x = -2638.479, y = 299.594, z = -4396.015 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53118, gadget_id = 70900380, pos = { x = -2644.675, y = 305.535, z = -4410.208 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53119, gadget_id = 70900380, pos = { x = -2645.101, y = 299.207, z = -4424.090 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53122, gadget_id = 70290150, pos = { x = -2585.017, y = 280.299, z = -4349.662 }, rot = { x = 0.000, y = 39.229, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53125, gadget_id = 70290150, pos = { x = -2584.610, y = 280.181, z = -4351.832 }, rot = { x = 0.000, y = 39.229, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53128, gadget_id = 70290150, pos = { x = -2583.972, y = 280.234, z = -4354.135 }, rot = { x = 0.000, y = 39.229, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53134, gadget_id = 70290150, pos = { x = -2610.592, y = 291.414, z = -4382.586 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53137, gadget_id = 70290150, pos = { x = -2611.590, y = 291.410, z = -4384.579 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53140, gadget_id = 70290150, pos = { x = -2612.815, y = 291.444, z = -4386.663 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53144, gadget_id = 70290150, pos = { x = -2627.477, y = 291.995, z = -4393.063 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53147, gadget_id = 70290150, pos = { x = -2625.635, y = 292.055, z = -4393.363 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53150, gadget_id = 70290150, pos = { x = -2623.335, y = 292.120, z = -4393.640 }, rot = { x = 0.000, y = 91.800, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53151, gadget_id = 70290150, pos = { x = -2644.501, y = 306.937, z = -4397.485 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53153, gadget_id = 70290150, pos = { x = -2644.553, y = 306.931, z = -4399.951 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 53155, gadget_id = 70290150, pos = { x = -2645.030, y = 306.587, z = -4402.503 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 }
}

-- 区域
regions = {
	{ config_id = 53018, shape = RegionShape.SPHERE, radius = 5, pos = { x = -2625.787, y = 212.859, z = -4247.463 }, area_id = 11 },
	{ config_id = 53021, shape = RegionShape.SPHERE, radius = 5, pos = { x = -2579.507, y = 270.750, z = -4360.590 }, area_id = 11 },
	{ config_id = 53024, shape = RegionShape.SPHERE, radius = 5, pos = { x = -2649.406, y = 291.725, z = -4431.945 }, area_id = 11 },
	{ config_id = 53031, shape = RegionShape.SPHERE, radius = 5, pos = { x = -2703.980, y = 208.366, z = -4132.360 }, area_id = 11 }
}

-- 触发器
triggers = {
	{ config_id = 1053018, name = "ENTER_REGION_53018", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_53018", action = "action_EVENT_ENTER_REGION_53018" },
	{ config_id = 1053021, name = "ENTER_REGION_53021", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_53021", action = "action_EVENT_ENTER_REGION_53021" },
	{ config_id = 1053024, name = "ENTER_REGION_53024", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_53024", action = "action_EVENT_ENTER_REGION_53024" },
	{ config_id = 1053026, name = "GADGET_CREATE_53026", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_53026", action = "action_EVENT_GADGET_CREATE_53026", trigger_count = 0 },
	{ config_id = 1053027, name = "SELECT_OPTION_53027", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_53027", action = "action_EVENT_SELECT_OPTION_53027", trigger_count = 0 },
	{ config_id = 1053028, name = "ANY_GADGET_DIE_53028", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_53028", action = "action_EVENT_ANY_GADGET_DIE_53028", trigger_count = 0 },
	{ config_id = 1053029, name = "CHALLENGE_SUCCESS_53029", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "101", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_53029" },
	{ config_id = 1053030, name = "CHALLENGE_FAIL_53030", event = EventType.EVENT_CHALLENGE_FAIL, source = "101", condition = "", action = "action_EVENT_CHALLENGE_FAIL_53030", trigger_count = 0 },
	{ config_id = 1053031, name = "ENTER_REGION_53031", event = EventType.EVENT_ENTER_REGION, source = "", condition = "", action = "action_EVENT_ENTER_REGION_53031" },
	{ config_id = 1053039, name = "ANY_MONSTER_DIE_53039", event = EventType.EVENT_ANY_MONSTER_DIE, source = "", condition = "condition_EVENT_ANY_MONSTER_DIE_53039", action = "action_EVENT_ANY_MONSTER_DIE_53039", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "SEED_NUM", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 53025 },
		regions = { 53031 },
		triggers = { "GADGET_CREATE_53026", "SELECT_OPTION_53027", "CHALLENGE_SUCCESS_53029", "CHALLENGE_FAIL_53030", "ENTER_REGION_53031" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 53001, 53002, 53003, 53004, 53005, 53016, 53017, 53033, 53034, 53035, 53036, 53037, 53038, 53043, 53088 },
		regions = { 53018 },
		triggers = { "ENTER_REGION_53018" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 53006, 53007, 53008, 53009, 53010, 53011, 53012, 53019, 53020, 53044, 53049, 53051, 53090, 53092, 53094, 53096, 53115, 53116, 53122, 53125, 53128 },
		regions = { 53021 },
		triggers = { "ENTER_REGION_53021" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 53013, 53014, 53015, 53022, 53023, 53045, 53114, 53117, 53118, 53119, 53134, 53137, 53140, 53144, 53147, 53150, 53151, 53153, 53155 },
		regions = { 53024 },
		triggers = { "ENTER_REGION_53024" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 第一组小怪,
		monsters = { 53046, 53047, 53048, 53159 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 第二组小怪,
		monsters = { 53160, 53161, 53162, 53163 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 疾风微粒统计trigger,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "ANY_GADGET_DIE_53028", "ANY_MONSTER_DIE_53039" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_53018(context, evt)
	if evt.param1 ~= 53018 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_53018(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 53017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 3)
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 6)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220053, 2)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_53021(context, evt)
	if evt.param1 ~= 53021 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_53021(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 53020 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 4)
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220053, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_53024(context, evt)
	if evt.param1 ~= 53024 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_53024(context, evt)
	-- 终止识别id为101的挑战，并判定成功
		ScriptLib.StopChallenge(context, 101, 1)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_53026(context, evt)
	if 53025 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_53026(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133220053, 53025, {175}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_53027(context, evt)
	-- 判断是gadgetid 53025 option_id 175
	if 53025 ~= evt.param1 then
		return false	
	end
	
	if 175 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_53027(context, evt)
	-- 开启操作台时确认当前有没有其他稻妻试炼的飞雷核挑战在进行
	if 0 ~= ScriptLib.GetGroupTempValue(context, "ElectricCorePlayHasStarted", {}) then
	    ScriptLib.ShowReminder(context, 400046)
	    return 0
	end
	
	
	if true == ScriptLib.CheckIsInMpMode(context) then
	    ScriptLib.ShowReminder(context, 400053)
	        return -1
	end
	
	-- 删除指定group： 133220053 ；指定config：53025；物件身上指定option：175；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133220053, 53025, 175) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
	-- 将configid为 53025 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 53025, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 2)
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 5)
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220053, 7)
	
	----------------------------------------------------------------------------------------------------------------------------
	-- 创建编号为111167父挑战，indexID为101
	if 0 ~= ScriptLib.CreateFatherChallenge(context, 101, 111167, 60, {success = 1, fail = 1, fail_on_wipe=true}) then
	        return -1
	end
	
	
	-- 创建编号为201的子挑战：无用子挑战
	if 0 ~= ScriptLib.AttachChildChallenge(context, 101, 201, 111172, {999,4,53024,1},{},{success=0,fail=0}) then
	        return -1
	end
	
	-- 开始父挑战
	if 0 ~= ScriptLib.StartFatherChallenge(context, 101) then
	        return -1
	end
	
	-- 挑战开启将'ElectricCorePlayHasStarted'改为1
	local challenge_groups = {133220053,133220172,133212361,133212185,133212183,133212033}
	    for k,grp_id in pairs(challenge_groups) do
	                ScriptLib.SetGroupTempValue(context, "ElectricCorePlayHasStarted", 1, {group_id = grp_id})
	    end
	
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1332200531") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_53028(context, evt)
	-- 所有物件的List
	local gadget_table = {
	    53033,
	    53034,
	    53035,
	    53036,
	    53037,
	    53038,
	    53049,
	    53051,
	    53090,
	    53092,
	    53094,
	    53096,
	    53122,
	    53125,
	    53128,
	    53134,
	    53137,
	    53140,
	    53144,
	    53147,
	    53150,
	    53151,
	    53153,
	    53155
	}
	
	    for i,gadget_id in ipairs(gadget_table) do
	        if gadget_id == evt.param1 then
	            return true
	        end
	    end
	
	return false
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_53028(context, evt)
	ScriptLib.ModifyFatherChallengeProperty(context, 101, FatherChallengeProperty.DURATION, 5)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_53029(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "133220053") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	-- 挑战结束将'ElectricCorePlayHasStarted'改为0
	local challenge_groups = {133220053,133220172,133212361,133212185,133212183,133212033}
	    for k,grp_id in pairs(challenge_groups) do
	                ScriptLib.SetGroupTempValue(context, "ElectricCorePlayHasStarted", 0, {group_id = grp_id})
	    end
	
	
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220053, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_53030(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1332200532") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	-- 挑战结束将'ElectricCorePlayHasStarted'改为0
	local challenge_groups = {133220053,133220172,133212361,133212185,133212183,133212033}
	    for k,grp_id in pairs(challenge_groups) do
	                ScriptLib.SetGroupTempValue(context, "ElectricCorePlayHasStarted", 0, {group_id = grp_id})
	    end
	
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220053, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_ENTER_REGION_53031(context, evt)
	-- 显示id为139的reminder
	if 0 ~= ScriptLib.AssignPlayerShowTemplateReminder(context,139,{param_uid_vec={},param_vec={},uid_vec={context.uid}}) then
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_DIE_53039(context, evt)
	-- 所有怪物的List
	local monster_table = {
	    53046,
	    53047,
	    53048,
	    53159,
	    53160,
	    53161,
	    53162,
	    53163
	}
	
	    for i,monster_id in ipairs(monster_table) do
	        if monster_id == evt.param1 then
	            return true
	        end
	    end
	
	return false
end

-- 触发操作
function action_EVENT_ANY_MONSTER_DIE_53039(context, evt)
	ScriptLib.ModifyFatherChallengeProperty(context, 101, FatherChallengeProperty.DURATION, 5)
	
	return 0
end

require "V2_0/ElectricCore"