-- 基础信息
local base_info = {
	group_id = 133220189
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 189001, monster_id = 20011201, pos = { x = -2540.288, y = 276.348, z = -4557.701 }, rot = { x = 0.000, y = 213.550, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189002, monster_id = 20011201, pos = { x = -2542.822, y = 276.052, z = -4558.328 }, rot = { x = 0.000, y = 203.822, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189003, monster_id = 20011201, pos = { x = -2543.030, y = 276.241, z = -4556.211 }, rot = { x = 0.000, y = 197.738, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189012, monster_id = 20010501, pos = { x = -2518.556, y = 288.379, z = -4518.961 }, rot = { x = 0.000, y = 213.550, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189013, monster_id = 20010501, pos = { x = -2520.934, y = 288.473, z = -4517.780 }, rot = { x = 0.000, y = 203.822, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189014, monster_id = 20010501, pos = { x = -2519.377, y = 288.825, z = -4517.682 }, rot = { x = 0.000, y = 203.822, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189017, monster_id = 20011401, pos = { x = -2495.250, y = 324.306, z = -4476.748 }, rot = { x = 0.000, y = 213.550, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189018, monster_id = 20011401, pos = { x = -2496.617, y = 324.328, z = -4474.903 }, rot = { x = 0.000, y = 203.822, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189019, monster_id = 20011401, pos = { x = -2493.043, y = 324.198, z = -4476.865 }, rot = { x = 0.000, y = 222.814, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189023, monster_id = 20010501, pos = { x = -2484.947, y = 322.069, z = -4465.265 }, rot = { x = 0.000, y = 213.550, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189024, monster_id = 20010501, pos = { x = -2481.210, y = 321.134, z = -4462.774 }, rot = { x = 0.000, y = 237.312, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189025, monster_id = 20010901, pos = { x = -2458.269, y = 322.825, z = -4400.139 }, rot = { x = 0.000, y = 124.849, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189026, monster_id = 20011101, pos = { x = -2460.097, y = 323.255, z = -4404.431 }, rot = { x = 0.000, y = 107.977, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189030, monster_id = 20010501, pos = { x = -2445.657, y = 315.429, z = -4417.077 }, rot = { x = 0.000, y = 173.281, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189031, monster_id = 20011201, pos = { x = -2444.611, y = 315.378, z = -4418.617 }, rot = { x = 0.000, y = 177.530, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189032, monster_id = 20010501, pos = { x = -2443.675, y = 315.436, z = -4416.930 }, rot = { x = 0.000, y = 173.281, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 },
	{ config_id = 189035, monster_id = 20010501, pos = { x = -2477.507, y = 319.963, z = -4459.841 }, rot = { x = 0.000, y = 222.814, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 11 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 189004, gadget_id = 70360005, pos = { x = -2560.702, y = 273.733, z = -4574.788 }, rot = { x = 0.000, y = 155.299, z = 0.000 }, level = 19, area_id = 11 },
	{ config_id = 189005, gadget_id = 70360025, pos = { x = -2463.428, y = 323.971, z = -4401.208 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 189006, gadget_id = 70350085, pos = { x = -2463.428, y = 323.971, z = -4401.208 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 189007, gadget_id = 70350085, pos = { x = -2560.702, y = 274.684, z = -4574.788 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 11 },
	{ config_id = 189015, gadget_id = 70900380, pos = { x = -2514.403, y = 303.060, z = -4511.171 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 189016, gadget_id = 70900380, pos = { x = -2504.371, y = 323.322, z = -4494.270 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 189020, gadget_id = 70900380, pos = { x = -2509.428, y = 316.721, z = -4503.116 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 189022, gadget_id = 70330064, pos = { x = -2461.974, y = 313.516, z = -4462.171 }, rot = { x = 0.000, y = 137.469, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 189033, gadget_id = 70330064, pos = { x = -2513.896, y = 291.984, z = -4512.928 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 189034, gadget_id = 70330064, pos = { x = -2501.762, y = 310.268, z = -4496.803 }, rot = { x = 0.000, y = 137.469, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 189036, gadget_id = 70900380, pos = { x = -2471.177, y = 324.481, z = -4465.131 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 189037, gadget_id = 70900380, pos = { x = -2454.390, y = 326.225, z = -4459.441 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 189038, gadget_id = 70900380, pos = { x = -2442.021, y = 323.681, z = -4438.308 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 }
}

-- 区域
regions = {
	{ config_id = 189008, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2463.414, y = 323.971, z = -4401.255 }, area_id = 11 }
}

-- 触发器
triggers = {
	{ config_id = 1189008, name = "ENTER_REGION_189008", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_189008", action = "action_EVENT_ENTER_REGION_189008", tag = "666" },
	{ config_id = 1189009, name = "CHALLENGE_SUCCESS_189009", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_189009", trigger_count = 0 },
	{ config_id = 1189010, name = "CHALLENGE_FAIL_189010", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_189010", trigger_count = 0 },
	{ config_id = 1189011, name = "GADGET_STATE_CHANGE_189011", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_189011", action = "action_EVENT_GADGET_STATE_CHANGE_189011", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 189004, 189007 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_189011" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = suite_2,
		monsters = { 189001, 189002, 189003, 189012, 189013, 189014, 189017, 189018, 189019, 189023, 189024, 189025, 189026, 189030, 189031, 189032, 189035 },
		gadgets = { 189005, 189006, 189015, 189016, 189020, 189022, 189033, 189034, 189036, 189037, 189038 },
		regions = { 189008 },
		triggers = { "ENTER_REGION_189008", "CHALLENGE_SUCCESS_189009", "CHALLENGE_FAIL_189010" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = suite_3,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_189008(context, evt)
	if evt.param1 ~= 189008 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_189008(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 189005 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_189009(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 189007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220189, 2)
	
	-- 将configid为 189004 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 189004, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133220189, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_189010(context, evt)
	-- 将configid为 189007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 189007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220189, 2)
	
	-- 将configid为 189004 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 189004, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将本组内变量名为 "hasFinished" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_189011(context, evt)
	if 189004 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_189011(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220189, 2)
	
	-- 将configid为 189007 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 189007, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建编号为888（该挑战的识别id),挑战内容为207的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 207, 30, 4, 666, 5) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

require "V2_0/ElectricCore"