-- 基础信息
local base_info = {
	group_id = 133220192
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 192001, gadget_id = 70710126, pos = { x = -2521.155, y = 350.869, z = -4388.226 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192002, gadget_id = 70350085, pos = { x = -2518.185, y = 350.869, z = -4388.226 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192004, gadget_id = 70360005, pos = { x = -2553.573, y = 285.391, z = -4337.473 }, rot = { x = 0.000, y = 274.747, z = 0.000 }, level = 19, area_id = 11 },
	{ config_id = 192005, gadget_id = 70710126, pos = { x = -2558.627, y = 341.162, z = -4401.809 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192006, gadget_id = 70350085, pos = { x = -2558.627, y = 341.592, z = -4401.809 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192007, gadget_id = 70350085, pos = { x = -2553.573, y = 286.434, z = -4337.473 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 19, area_id = 11 },
	{ config_id = 192012, gadget_id = 70710126, pos = { x = -2536.989, y = 364.109, z = -4431.423 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192013, gadget_id = 70350085, pos = { x = -2536.989, y = 364.109, z = -4431.423 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192015, gadget_id = 70360025, pos = { x = -2487.749, y = 392.759, z = -4438.162 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192016, gadget_id = 70350085, pos = { x = -2487.749, y = 393.471, z = -4438.162 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 18, area_id = 11 },
	{ config_id = 192018, gadget_id = 70330064, pos = { x = -2547.892, y = 285.339, z = -4337.616 }, rot = { x = 0.000, y = 341.346, z = 0.000 }, level = 19, interact_id = 35, area_id = 11 },
	{ config_id = 192019, gadget_id = 70330064, pos = { x = -2559.746, y = 340.856, z = -4403.128 }, rot = { x = 0.000, y = 323.584, z = 0.000 }, level = 19, interact_id = 35, area_id = 11 },
	{ config_id = 192020, gadget_id = 70330064, pos = { x = -2518.281, y = 350.594, z = -4394.226 }, rot = { x = 0.000, y = 297.437, z = 0.000 }, level = 19, interact_id = 35, area_id = 11 },
	{ config_id = 192021, gadget_id = 70330064, pos = { x = -2537.385, y = 364.015, z = -4434.419 }, rot = { x = 0.000, y = 288.848, z = 0.000 }, level = 19, interact_id = 35, area_id = 11 },
	{ config_id = 192022, gadget_id = 70900380, pos = { x = -2559.983, y = 294.233, z = -4345.482 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192027, gadget_id = 70900380, pos = { x = -2570.250, y = 341.547, z = -4402.648 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192029, gadget_id = 70900380, pos = { x = -2571.735, y = 305.429, z = -4360.311 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192030, gadget_id = 70900380, pos = { x = -2580.327, y = 316.027, z = -4371.091 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192031, gadget_id = 70900380, pos = { x = -2583.234, y = 326.250, z = -4380.227 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192032, gadget_id = 70900380, pos = { x = -2579.987, y = 336.007, z = -4394.457 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192033, gadget_id = 70900380, pos = { x = -2552.379, y = 346.726, z = -4396.180 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192034, gadget_id = 70900380, pos = { x = -2537.848, y = 358.432, z = -4387.921 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192036, gadget_id = 70900380, pos = { x = -2529.970, y = 352.553, z = -4401.197 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192038, gadget_id = 70900380, pos = { x = -2541.605, y = 358.552, z = -4414.551 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192039, gadget_id = 70900380, pos = { x = -2545.916, y = 364.373, z = -4429.624 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192045, gadget_id = 70900380, pos = { x = -2529.692, y = 369.568, z = -4435.075 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192046, gadget_id = 70900380, pos = { x = -2518.233, y = 379.246, z = -4432.877 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 192047, gadget_id = 70900380, pos = { x = -2508.732, y = 389.746, z = -4431.575 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 }
}

-- 区域
regions = {
	{ config_id = 192003, shape = RegionShape.SPHERE, radius = 4, pos = { x = -2521.181, y = 350.866, z = -4388.125 }, area_id = 11 },
	{ config_id = 192008, shape = RegionShape.SPHERE, radius = 4, pos = { x = -2558.359, y = 341.167, z = -4401.828 }, area_id = 11 },
	{ config_id = 192014, shape = RegionShape.SPHERE, radius = 4, pos = { x = -2536.975, y = 364.111, z = -4431.470 }, area_id = 11 },
	{ config_id = 192017, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2487.735, y = 392.515, z = -4438.208 }, area_id = 11 }
}

-- 触发器
triggers = {
	{ config_id = 1192003, name = "ENTER_REGION_192003", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_192003", action = "action_EVENT_ENTER_REGION_192003", tag = "666" },
	{ config_id = 1192008, name = "ENTER_REGION_192008", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_192008", action = "action_EVENT_ENTER_REGION_192008", tag = "666" },
	{ config_id = 1192009, name = "CHALLENGE_SUCCESS_192009", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_192009", trigger_count = 0 },
	{ config_id = 1192010, name = "CHALLENGE_FAIL_192010", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_192010", trigger_count = 0 },
	{ config_id = 1192011, name = "GADGET_STATE_CHANGE_192011", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_192011", action = "action_EVENT_GADGET_STATE_CHANGE_192011", trigger_count = 0 },
	{ config_id = 1192014, name = "ENTER_REGION_192014", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_192014", action = "action_EVENT_ENTER_REGION_192014", tag = "666" },
	{ config_id = 1192017, name = "ENTER_REGION_192017", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_192017", action = "action_EVENT_ENTER_REGION_192017", tag = "666" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 6,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 192004, 192007, 192018, 192019, 192020, 192021 },
		regions = { },
		triggers = { "CHALLENGE_SUCCESS_192009", "CHALLENGE_FAIL_192010", "GADGET_STATE_CHANGE_192011" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = checkpoint 1,
		monsters = { },
		gadgets = { 192005, 192006, 192022, 192027, 192029, 192030, 192031, 192032 },
		regions = { 192008 },
		triggers = { "ENTER_REGION_192008" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = checkpoint 2,
		monsters = { },
		gadgets = { 192001, 192002, 192033, 192034 },
		regions = { 192003 },
		triggers = { "ENTER_REGION_192003" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = checkpoint 3,
		monsters = { },
		gadgets = { 192012, 192013, 192036, 192038, 192039 },
		regions = { 192014 },
		triggers = { "ENTER_REGION_192014" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 终点,
		monsters = { },
		gadgets = { 192015, 192016, 192045, 192046, 192047 },
		regions = { 192017 },
		triggers = { "ENTER_REGION_192017" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = end_suite,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_192003(context, evt)
	if evt.param1 ~= 192003 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_192003(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192001 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192002 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220192, 4)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220192, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_192008(context, evt)
	if evt.param1 ~= 192008 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_192008(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192005 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220192, 3)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220192, 2)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_192009(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 192004 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 192004, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133220192, 6) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_192010(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220192, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_192011(context, evt)
	if 192004 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_192011(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220192, 2)
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 创建编号为888（该挑战的识别id),挑战内容为241的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 241, 60, 4, 666, 4) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_192014(context, evt)
	if evt.param1 ~= 192014 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_192014(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192012 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192013 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220192, 5)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220192, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_192017(context, evt)
	if evt.param1 ~= 192017 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_192017(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192015 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 192016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220192, 5)
	
	return 0
end

require "V2_0/ElectricCore"