-- 基础信息
local base_info = {
	group_id = 133220663
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 663001, monster_id = 25020201, pos = { x = -2846.236, y = 200.220, z = -4287.950 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, area_id = 11 },
	{ config_id = 663002, monster_id = 25020201, pos = { x = -2868.312, y = 200.095, z = -4276.960 }, rot = { x = 0.000, y = 11.254, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, pose_id = 3, area_id = 11 },
	{ config_id = 663003, monster_id = 25010401, pos = { x = -2845.768, y = 200.256, z = -4282.803 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, area_id = 11 },
	{ config_id = 663004, monster_id = 25080301, pos = { x = -2873.776, y = 200.000, z = -4264.253 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, pose_id = 1, area_id = 11 },
	{ config_id = 663005, monster_id = 25080301, pos = { x = -2846.236, y = 200.220, z = -4287.950 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, pose_id = 1, area_id = 11 },
	{ config_id = 663006, monster_id = 25020201, pos = { x = -2845.639, y = 200.263, z = -4281.159 }, rot = { x = 0.000, y = 278.785, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, pose_id = 9004, area_id = 11 },
	{ config_id = 663007, monster_id = 25020201, pos = { x = -2849.475, y = 200.014, z = -4285.458 }, rot = { x = 0.000, y = 84.540, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, pose_id = 9004, area_id = 11 },
	{ config_id = 663008, monster_id = 25100101, pos = { x = -2852.865, y = 200.000, z = -4279.521 }, rot = { x = 0.000, y = 133.397, z = 0.000 }, level = 17, drop_id = 1000100, disableWander = true, pose_id = 1, area_id = 11 },
	{ config_id = 663009, monster_id = 25080301, pos = { x = -2867.331, y = 200.000, z = -4274.510 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, affix = { 4131 }, pose_id = 1, area_id = 11 },
	{ config_id = 663010, monster_id = 25020201, pos = { x = -2868.127, y = 200.000, z = -4269.159 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, affix = { 4131 }, area_id = 11 },
	{ config_id = 663011, monster_id = 25020201, pos = { x = -2864.148, y = 200.000, z = -4271.729 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, affix = { 4131 }, area_id = 11 },
	{ config_id = 663012, monster_id = 25080201, pos = { x = -2869.818, y = 200.000, z = -4276.025 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, pose_id = 1, area_id = 11 },
	{ config_id = 663013, monster_id = 25020201, pos = { x = -2864.672, y = 200.000, z = -4273.359 }, rot = { x = 0.000, y = 47.579, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, area_id = 11 },
	{ config_id = 663014, monster_id = 25020201, pos = { x = -2869.939, y = 200.000, z = -4271.708 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, area_id = 11 },
	{ config_id = 663015, monster_id = 25080301, pos = { x = -2859.376, y = 200.000, z = -4269.422 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, pose_id = 1, area_id = 11 },
	{ config_id = 663016, monster_id = 25020201, pos = { x = -2860.565, y = 200.000, z = -4275.317 }, rot = { x = 0.000, y = 36.473, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, area_id = 11 },
	{ config_id = 663017, monster_id = 25020201, pos = { x = -2868.369, y = 200.000, z = -4272.557 }, rot = { x = 0.000, y = 336.213, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 4131 }, area_id = 11 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 663018, gadget_id = 70330064, pos = { x = -2857.902, y = 200.062, z = -4265.731 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, interact_id = 35, area_id = 11 },
	{ config_id = 663019, gadget_id = 70300104, pos = { x = -2840.603, y = 200.860, z = -4287.890 }, rot = { x = 0.000, y = 103.317, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663020, gadget_id = 70300105, pos = { x = -2867.161, y = 200.117, z = -4280.949 }, rot = { x = 0.000, y = 294.386, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663021, gadget_id = 70300104, pos = { x = -2841.629, y = 200.920, z = -4293.141 }, rot = { x = 0.000, y = 103.317, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663022, gadget_id = 70220048, pos = { x = -2871.005, y = 200.000, z = -4282.718 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663023, gadget_id = 70220048, pos = { x = -2840.363, y = 200.929, z = -4290.798 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663024, gadget_id = 70220014, pos = { x = -2876.542, y = 200.000, z = -4277.118 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663025, gadget_id = 70220014, pos = { x = -2871.956, y = 200.000, z = -4281.178 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663026, gadget_id = 70220014, pos = { x = -2839.835, y = 201.061, z = -4285.956 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663027, gadget_id = 70220014, pos = { x = -2849.192, y = 200.922, z = -4297.793 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663028, gadget_id = 70220014, pos = { x = -2847.984, y = 200.827, z = -4296.119 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663029, gadget_id = 70220014, pos = { x = -2839.710, y = 200.533, z = -4268.941 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663030, gadget_id = 70220048, pos = { x = -2838.264, y = 200.778, z = -4269.133 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663031, gadget_id = 70220048, pos = { x = -2838.940, y = 200.523, z = -4267.425 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663032, gadget_id = 70310006, pos = { x = -2904.701, y = 200.104, z = -4269.937 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663033, gadget_id = 70310009, pos = { x = -2842.481, y = 200.496, z = -4287.031 }, rot = { x = 0.000, y = 275.833, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663034, gadget_id = 70220014, pos = { x = -2904.149, y = 200.084, z = -4271.542 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663035, gadget_id = 70220014, pos = { x = -2905.285, y = 200.102, z = -4271.542 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663036, gadget_id = 70310004, pos = { x = -2864.213, y = 200.399, z = -4276.225 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 11 },
	{ config_id = 663037, gadget_id = 70900380, pos = { x = -2866.570, y = 207.095, z = -4275.670 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 663038, gadget_id = 70900380, pos = { x = -2865.706, y = 207.007, z = -4264.263 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 663039, gadget_id = 70900380, pos = { x = -2855.655, y = 207.007, z = -4270.418 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 }
}

-- 区域
regions = {
	{ config_id = 663040, shape = RegionShape.SPHERE, radius = 70, pos = { x = -2869.258, y = 200.000, z = -4275.479 }, area_id = 11 },
	{ config_id = 663045, shape = RegionShape.SPHERE, radius = 50, pos = { x = -2867.883, y = 200.000, z = -4268.654 }, area_id = 11 },
	-- 傀儡机制特殊提示
	{ config_id = 663050, shape = RegionShape.SPHERE, radius = 70, pos = { x = -2872.420, y = 200.000, z = -4275.498 }, area_id = 11 }
}

-- 触发器
triggers = {
	{ config_id = 1663040, name = "ENTER_REGION_663040", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_663040", action = "action_EVENT_ENTER_REGION_663040", forbid_guest = false },
	{ config_id = 1663041, name = "ANY_MONSTER_LIVE_663041", event = EventType.EVENT_ANY_MONSTER_LIVE, source = "", condition = "condition_EVENT_ANY_MONSTER_LIVE_663041", action = "action_EVENT_ANY_MONSTER_LIVE_663041" },
	{ config_id = 1663042, name = "TIME_AXIS_PASS_663042", event = EventType.EVENT_TIME_AXIS_PASS, source = "T1", condition = "condition_EVENT_TIME_AXIS_PASS_663042", action = "action_EVENT_TIME_AXIS_PASS_663042" },
	{ config_id = 1663043, name = "ANY_MONSTER_LIVE_663043", event = EventType.EVENT_ANY_MONSTER_LIVE, source = "", condition = "condition_EVENT_ANY_MONSTER_LIVE_663043", action = "action_EVENT_ANY_MONSTER_LIVE_663043" },
	{ config_id = 1663044, name = "TIME_AXIS_PASS_663044", event = EventType.EVENT_TIME_AXIS_PASS, source = "T2", condition = "condition_EVENT_TIME_AXIS_PASS_663044", action = "action_EVENT_TIME_AXIS_PASS_663044" },
	{ config_id = 1663045, name = "ENTER_REGION_663045", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_663045", action = "action_EVENT_ENTER_REGION_663045", forbid_guest = false },
	{ config_id = 1663046, name = "GROUP_LOAD_663046", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_EVENT_GROUP_LOAD_663046", trigger_count = 0 },
	-- 悬赏结束改参数
	{ config_id = 1663047, name = "HUNTING_FINISH_FINAL_663047", event = EventType.EVENT_HUNTING_FINISH_FINAL, source = "", condition = "", action = "action_EVENT_HUNTING_FINISH_FINAL_663047" },
	{ config_id = 1663048, name = "ANY_MONSTER_LIVE_663048", event = EventType.EVENT_ANY_MONSTER_LIVE, source = "", condition = "condition_EVENT_ANY_MONSTER_LIVE_663048", action = "action_EVENT_ANY_MONSTER_LIVE_663048" },
	{ config_id = 1663049, name = "TIME_AXIS_PASS_663049", event = EventType.EVENT_TIME_AXIS_PASS, source = "T3", condition = "condition_EVENT_TIME_AXIS_PASS_663049", action = "action_EVENT_TIME_AXIS_PASS_663049" },
	-- 傀儡机制特殊提示
	{ config_id = 1663050, name = "ENTER_REGION_663050", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_663050", action = "action_EVENT_ENTER_REGION_663050", forbid_guest = false },
	-- IS_BOSS_DEAD变量变动之后，干掉所有怪物潮
	{ config_id = 1663051, name = "VARIABLE_CHANGE_663051", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_663051", action = "action_EVENT_VARIABLE_CHANGE_663051", trigger_count = 0 },
	{ config_id = 1663052, name = "VARIABLE_CHANGE_663052", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_663052", action = "action_EVENT_VARIABLE_CHANGE_663052", trigger_count = 0 },
	{ config_id = 1663053, name = "VARIABLE_CHANGE_663053", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_663053", action = "action_EVENT_VARIABLE_CHANGE_663053", trigger_count = 0 },
	{ config_id = 1663054, name = "VARIABLE_CHANGE_663054", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_663054", action = "action_EVENT_VARIABLE_CHANGE_663054", trigger_count = 0 },
	{ config_id = 1663055, name = "VARIABLE_CHANGE_663055", event = EventType.EVENT_VARIABLE_CHANGE, source = "", condition = "condition_EVENT_VARIABLE_CHANGE_663055", action = "action_EVENT_VARIABLE_CHANGE_663055", trigger_count = 0 }
}

-- 点位
points = {
	-- 首领出生点
	{ config_id = 663056, pos = { x = -2865.494, y = 200.196, z = -4277.744 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, area_id = 11 }
}

-- 变量
variables = {
	{ config_id = 1, name = "IS_BOSS_DEAD", value = 0, no_refresh = true }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "GROUP_LOAD_663046", "HUNTING_FINISH_FINAL_663047" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 营地增幅器,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 海乱鬼火-机关/傀儡-小怪组,
		monsters = { },
		gadgets = { },
		regions = { 663040, 663050 },
		triggers = { "ENTER_REGION_663040", "ENTER_REGION_663050", "VARIABLE_CHANGE_663051" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 海乱鬼火-营地-物件组,
		monsters = { },
		gadgets = { 663019, 663020, 663021, 663022, 663023, 663024, 663025, 663026, 663027, 663028, 663029, 663030, 663031, 663032, 663033, 663034, 663035, 663036 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 海乱鬼火-双子-怪物组,
		monsters = { 663005, 663006, 663007, 663008 },
		gadgets = { },
		regions = { },
		triggers = { "VARIABLE_CHANGE_663052" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 海乱鬼火-链接-怪物组1,
		monsters = { 663009, 663010, 663011 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_LIVE_663041", "TIME_AXIS_PASS_663042", "VARIABLE_CHANGE_663053" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = 海乱鬼火-链接-怪物组2,
		monsters = { 663012, 663013, 663014 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_LIVE_663043", "TIME_AXIS_PASS_663044", "VARIABLE_CHANGE_663054" },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = 海乱鬼火-链接-怪物组3,
		monsters = { 663015, 663016, 663017 },
		gadgets = { },
		regions = { },
		triggers = { "ANY_MONSTER_LIVE_663048", "TIME_AXIS_PASS_663049", "VARIABLE_CHANGE_663055" },
		rand_weight = 100
	},
	{
		-- suite_id = 10,
		-- description = 海乱鬼火-双子-高伤炸药桶,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 11,
		-- description = 海乱鬼火-链接-飞雷核,
		monsters = { },
		gadgets = { 663018, 663037, 663038, 663039 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 12,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 13,
		-- description = 链接刷新小怪reminder,
		monsters = { },
		gadgets = { },
		regions = { 663045 },
		triggers = { "ENTER_REGION_663045" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_663040(context, evt)
	if evt.param1 ~= 663040 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_663040(context, evt)
	-- 创建编号为1（该怪物潮的识别id)的怪物潮，创建怪物总数为50，场上怪物最少1只，最多1只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 1, 133220663, {663001}, 50, 1, 1) then
		return -1
	end
	
	-- 创建编号为2（该怪物潮的识别id)的怪物潮，创建怪物总数为50，场上怪物最少1只，最多1只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 2, 133220663, {663002}, 50, 1, 1) then
		return -1
	end
	
	-- 创建编号为3（该怪物潮的识别id)的怪物潮，创建怪物总数为50，场上怪物最少1只，最多1只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 3, 133220663, {663003}, 50, 1, 1) then
		return -1
	end
	
	-- 创建编号为4（该怪物潮的识别id)的怪物潮，创建怪物总数为50，场上怪物最少1只，最多1只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 4, 133220663, {663004}, 50, 1, 1) then
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_LIVE_663041(context, evt)
	if 663009 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_LIVE_663041(context, evt)
	-- 创建标识为"T1"，时间节点为{60}的时间轴，false用于控制该时间轴是否循环
	ScriptLib.InitTimeAxis(context, "T1", {60}, false)
	
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_663042(context, evt)
	-- 判断变量"IS_BOSS_DEAD"为0
	if ScriptLib.GetGroupVariableValue(context, "IS_BOSS_DEAD") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_663042(context, evt)
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 8)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220663, 7)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 7)
	
	-- 添加suite13的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 13)
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_LIVE_663043(context, evt)
	if 663012 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_LIVE_663043(context, evt)
	-- 创建标识为"T2"，时间节点为{60}的时间轴，false用于控制该时间轴是否循环
	ScriptLib.InitTimeAxis(context, "T2", {60}, false)
	
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_663044(context, evt)
	-- 判断变量"IS_BOSS_DEAD"为0
	if ScriptLib.GetGroupVariableValue(context, "IS_BOSS_DEAD") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_663044(context, evt)
	-- 添加suite9的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 9)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220663, 8)
	
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 8)
	
	-- 添加suite13的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 13)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_663045(context, evt)
	if evt.param1 ~= 663045 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_663045(context, evt)
	-- 调用提示id为 500070 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 500070) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 删除suite13的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 13)
	
	return 0
end

-- 触发操作
function action_EVENT_GROUP_LOAD_663046(context, evt)
	-- 初始化table
	    local suite_table = {}
	
	-- 需要在group创建时调用，该函数会通过context的groupid读取HuntingData表，来创建entity填充points
	    if 0~= ScriptLib.RefreshHuntingClueGroup(context) then
	        ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_hunting_clue_group")
	        return -1
	    end
	
	-- 根据HuntingData表的配置来激活对应的suite
	    if 0~= ScriptLib.GetHuntingMonsterExtraSuiteIndexVec(context) then
	        suite_table = ScriptLib.GetHuntingMonsterExtraSuiteIndexVec(context)
	        for i,suite_id in ipairs (suite_table) do
	            ScriptLib.AddExtraGroupSuite(context, 133220663, suite_id)
	        end
	    end
	
	return 0
end

-- 触发操作
function action_EVENT_HUNTING_FINISH_FINAL_663047(context, evt)
	-- 将本组内变量名为 "IS_BOSS_DEAD" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "IS_BOSS_DEAD", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_MONSTER_LIVE_663048(context, evt)
	if 663015 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_MONSTER_LIVE_663048(context, evt)
	-- 创建标识为"T3"，时间节点为{60}的时间轴，false用于控制该时间轴是否循环
	ScriptLib.InitTimeAxis(context, "T3", {60}, false)
	
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_663049(context, evt)
	-- 判断变量"IS_BOSS_DEAD"为0
	if ScriptLib.GetGroupVariableValue(context, "IS_BOSS_DEAD") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_663049(context, evt)
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 8)
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133220663, 9)
	
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 9)
	
	-- 添加suite13的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220663, 13)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_663050(context, evt)
	if evt.param1 ~= 663050 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_663050(context, evt)
	-- 调用提示id为 500072 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 500072) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_663051(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"IS_BOSS_DEAD"为1
	if ScriptLib.GetGroupVariableValueByGroup(context, "IS_BOSS_DEAD", 133220663) ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_663051(context, evt)
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133220663, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	--销毁编号为2（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133220663, 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	--销毁编号为3（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133220663, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	--销毁编号为4（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133220663, 4) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	-- 杀死Group内所有monster
		if 0 ~= ScriptLib.KillGroupEntity(context, { group_id = 133220663, kill_policy = GroupKillPolicy.GROUP_KILL_MONSTER }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_by_group")
			return -1
		end
		
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_663052(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"IS_BOSS_DEAD"为1
	if ScriptLib.GetGroupVariableValueByGroup(context, "IS_BOSS_DEAD", 133220663) ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_663052(context, evt)
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_663053(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"IS_BOSS_DEAD"为1
	if ScriptLib.GetGroupVariableValueByGroup(context, "IS_BOSS_DEAD", 133220663) ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_663053(context, evt)
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 7)
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_663054(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"IS_BOSS_DEAD"为1
	if ScriptLib.GetGroupVariableValueByGroup(context, "IS_BOSS_DEAD", 133220663) ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_663054(context, evt)
	-- 删除suite8的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 8)
	
	return 0
end

-- 触发条件
function condition_EVENT_VARIABLE_CHANGE_663055(context, evt)
	if evt.param1 == evt.param2 then return false end
	
	-- 判断变量"IS_BOSS_DEAD"为1
	if ScriptLib.GetGroupVariableValueByGroup(context, "IS_BOSS_DEAD", 133220663) ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_VARIABLE_CHANGE_663055(context, evt)
	-- 删除suite9的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220663, 9)
	
	return 0
end

require "V2_0/ElectricCore"