-- 基础信息
local base_info = {
	group_id = 133220674
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 674028, monster_id = 20010901, pos = { x = -2744.536, y = 225.320, z = -4465.666 }, rot = { x = 0.000, y = 236.612, z = 0.000 }, level = 26, drop_id = 1000100, area_id = 11 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 674001, gadget_id = 70220020, pos = { x = -2782.576, y = 223.107, z = -4444.572 }, rot = { x = 0.000, y = 30.834, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674002, gadget_id = 70220020, pos = { x = -2779.270, y = 222.898, z = -4447.405 }, rot = { x = 0.000, y = 50.953, z = 3.392 }, level = 1, area_id = 11 },
	{ config_id = 674003, gadget_id = 70220020, pos = { x = -2786.715, y = 223.111, z = -4442.584 }, rot = { x = 0.000, y = 16.390, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674004, gadget_id = 70220020, pos = { x = -2786.287, y = 223.109, z = -4456.089 }, rot = { x = 0.000, y = 68.650, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674005, gadget_id = 70220020, pos = { x = -2762.277, y = 226.759, z = -4465.865 }, rot = { x = 0.000, y = 196.055, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674006, gadget_id = 70220020, pos = { x = -2763.580, y = 226.073, z = -4479.410 }, rot = { x = 0.000, y = 11.561, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674007, gadget_id = 70220020, pos = { x = -2740.554, y = 226.635, z = -4466.530 }, rot = { x = 0.000, y = 317.819, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674008, gadget_id = 70220020, pos = { x = -2743.188, y = 226.279, z = -4460.745 }, rot = { x = 0.000, y = 160.628, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674009, gadget_id = 70220020, pos = { x = -2723.144, y = 226.755, z = -4456.687 }, rot = { x = 0.000, y = 354.045, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674010, gadget_id = 70220020, pos = { x = -2788.767, y = 223.248, z = -4451.673 }, rot = { x = 8.758, y = 62.676, z = 359.810 }, level = 1, area_id = 11 },
	{ config_id = 674011, gadget_id = 70220020, pos = { x = -2776.175, y = 224.015, z = -4451.725 }, rot = { x = 359.785, y = 254.175, z = 352.655 }, level = 1, area_id = 11 },
	{ config_id = 674012, gadget_id = 70360093, pos = { x = -2762.167, y = 226.500, z = -4477.583 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000217, area_id = 11 },
	{ config_id = 674013, gadget_id = 70220020, pos = { x = -2719.200, y = 226.515, z = -4457.227 }, rot = { x = 0.000, y = 357.687, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674014, gadget_id = 70220020, pos = { x = -2753.751, y = 225.910, z = -4465.467 }, rot = { x = 0.000, y = 138.693, z = 13.963 }, level = 1, area_id = 11 },
	{ config_id = 674015, gadget_id = 70220020, pos = { x = -2754.662, y = 226.157, z = -4481.156 }, rot = { x = 357.984, y = 164.755, z = 2.005 }, level = 1, area_id = 11 },
	{ config_id = 674016, gadget_id = 70220020, pos = { x = -2757.365, y = 226.648, z = -4466.857 }, rot = { x = 0.000, y = 190.539, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674018, gadget_id = 70360093, pos = { x = -2781.718, y = 223.800, z = -4452.340 }, rot = { x = 0.000, y = 355.008, z = 0.000 }, level = 1, route_id = 322000226, area_id = 11 },
	{ config_id = 674021, gadget_id = 70360093, pos = { x = -2754.073, y = 226.500, z = -4467.326 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000221, area_id = 11 },
	{ config_id = 674024, gadget_id = 70360093, pos = { x = -2784.613, y = 223.800, z = -4453.173 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000227, area_id = 11 },
	{ config_id = 674025, gadget_id = 70360093, pos = { x = -2770.652, y = 228.300, z = -4465.276 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000216, area_id = 11 },
	{ config_id = 674026, gadget_id = 70360093, pos = { x = -2735.850, y = 226.500, z = -4455.895 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000220, area_id = 11 },
	{ config_id = 674027, gadget_id = 70220020, pos = { x = -2759.135, y = 226.070, z = -4481.605 }, rot = { x = 358.020, y = 199.101, z = 350.311 }, level = 1, area_id = 11 },
	{ config_id = 674030, gadget_id = 70360093, pos = { x = -2725.286, y = 226.500, z = -4452.483 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000223, area_id = 11 },
	{ config_id = 674031, gadget_id = 70710126, pos = { x = -2779.140, y = 222.800, z = -4457.425 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674032, gadget_id = 70710126, pos = { x = -2756.742, y = 225.474, z = -4471.312 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674033, gadget_id = 70360093, pos = { x = -2778.630, y = 228.300, z = -4461.260 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000229, area_id = 11 },
	{ config_id = 674040, gadget_id = 70360093, pos = { x = -2781.526, y = 228.300, z = -4462.093 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000230, area_id = 11 },
	{ config_id = 674043, gadget_id = 70710126, pos = { x = -2773.858, y = 222.800, z = -4467.634 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674047, gadget_id = 70360093, pos = { x = -2775.334, y = 228.300, z = -4460.314 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000228, area_id = 11 },
	{ config_id = 674048, gadget_id = 70710126, pos = { x = -2740.336, y = 225.320, z = -4462.732 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674049, gadget_id = 70360025, pos = { x = -2714.551, y = 225.320, z = -4450.324 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674050, gadget_id = 70360093, pos = { x = -2770.641, y = 223.800, z = -4465.293 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000216, area_id = 11 },
	{ config_id = 674051, gadget_id = 70360093, pos = { x = -2789.899, y = 223.300, z = -4446.333 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000218, area_id = 11 },
	{ config_id = 674052, gadget_id = 70360093, pos = { x = -2778.421, y = 223.800, z = -4451.395 }, rot = { x = 0.000, y = 355.008, z = 0.000 }, level = 1, route_id = 322000219, area_id = 11 },
	{ config_id = 674053, gadget_id = 70220020, pos = { x = -2739.805, y = 226.609, z = -4458.304 }, rot = { x = 0.000, y = 128.723, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674054, gadget_id = 70220020, pos = { x = -2737.112, y = 226.500, z = -4463.410 }, rot = { x = 0.000, y = 309.931, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674055, gadget_id = 70360093, pos = { x = -2717.779, y = 226.500, z = -4451.038 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000234, area_id = 11 },
	{ config_id = 674056, gadget_id = 70710126, pos = { x = -2784.206, y = 222.800, z = -4448.696 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674057, gadget_id = 70360093, pos = { x = -2778.756, y = 223.800, z = -4470.611 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000237, area_id = 11 },
	{ config_id = 674058, gadget_id = 70360093, pos = { x = -2778.756, y = 228.300, z = -4470.611 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000237, area_id = 11 },
	{ config_id = 674059, gadget_id = 70220020, pos = { x = -2773.288, y = 223.784, z = -4458.670 }, rot = { x = 0.000, y = 238.858, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674060, gadget_id = 70220020, pos = { x = -2784.000, y = 223.027, z = -4460.905 }, rot = { x = 0.000, y = 52.549, z = 0.000 }, level = 1, area_id = 11 },
	{ config_id = 674061, gadget_id = 70360093, pos = { x = -2753.413, y = 226.500, z = -4471.174 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000221, area_id = 11 },
	{ config_id = 674062, gadget_id = 70360093, pos = { x = -2752.720, y = 226.500, z = -4475.237 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000221, area_id = 11 },
	{ config_id = 674063, gadget_id = 70360093, pos = { x = -2752.120, y = 226.500, z = -4478.824 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000221, area_id = 11 },
	{ config_id = 674064, gadget_id = 70360093, pos = { x = -2733.600, y = 229.000, z = -4458.146 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000232, area_id = 11 },
	{ config_id = 674065, gadget_id = 70360093, pos = { x = -2731.968, y = 231.500, z = -4460.372 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000233, area_id = 11 },
	{ config_id = 674066, gadget_id = 70360093, pos = { x = -2720.273, y = 231.000, z = -4454.849 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000235, area_id = 11 },
	{ config_id = 674067, gadget_id = 70360093, pos = { x = -2722.728, y = 231.000, z = -4448.781 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 322000236, area_id = 11 }
}

-- 区域
regions = {
	-- 加载路径点3，加载顶部环境配置
	{ config_id = 674019, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2779.140, y = 222.800, z = -4457.425 }, area_id = 11 },
	-- 加载顶部怪物组配置2
	{ config_id = 674020, shape = RegionShape.SPHERE, radius = 5, pos = { x = -2734.597, y = 225.320, z = -4457.939 }, area_id = 11 },
	{ config_id = 674022, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2784.206, y = 222.800, z = -4448.696 }, area_id = 11 },
	{ config_id = 674023, shape = RegionShape.SPHERE, radius = 4, pos = { x = -2756.742, y = 225.474, z = -4471.313 }, area_id = 11 },
	-- 出现终点
	{ config_id = 674029, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2740.336, y = 225.320, z = -4462.732 }, area_id = 11 },
	-- 终点——完成挑战
	{ config_id = 674042, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2714.551, y = 225.320, z = -4450.324 }, area_id = 11 },
	{ config_id = 674045, shape = RegionShape.SPHERE, radius = 3, pos = { x = -2773.858, y = 222.800, z = -4467.634 }, area_id = 11 }
}

-- 触发器
triggers = {
	-- 开启闯关
	{ config_id = 1674017, name = "QUEST_START_674017", event = EventType.EVENT_QUEST_START, source = "1901502", condition = "", action = "action_EVENT_QUEST_START_674017", trigger_count = 0 },
	-- 加载路径点3，加载顶部环境配置
	{ config_id = 1674019, name = "ENTER_REGION_674019", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674019", action = "action_EVENT_ENTER_REGION_674019" },
	-- 加载顶部怪物组配置2
	{ config_id = 1674020, name = "ENTER_REGION_674020", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674020", action = "action_EVENT_ENTER_REGION_674020" },
	{ config_id = 1674022, name = "ENTER_REGION_674022", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674022", action = "action_EVENT_ENTER_REGION_674022" },
	{ config_id = 1674023, name = "ENTER_REGION_674023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674023", action = "action_EVENT_ENTER_REGION_674023" },
	-- 出现终点
	{ config_id = 1674029, name = "ENTER_REGION_674029", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674029", action = "action_EVENT_ENTER_REGION_674029" },
	-- 终点_好
	{ config_id = 1674034, name = "CHALLENGE_SUCCESS_674034", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "111", condition = "condition_EVENT_CHALLENGE_SUCCESS_674034", action = "action_EVENT_CHALLENGE_SUCCESS_674034", trigger_count = 0 },
	-- 好评价
	{ config_id = 1674035, name = "TIME_AXIS_PASS_674035", event = EventType.EVENT_TIME_AXIS_PASS, source = "", condition = "condition_EVENT_TIME_AXIS_PASS_674035", action = "action_EVENT_TIME_AXIS_PASS_674035", trigger_count = 0 },
	-- 中评价
	{ config_id = 1674036, name = "TIME_AXIS_PASS_674036", event = EventType.EVENT_TIME_AXIS_PASS, source = "", condition = "condition_EVENT_TIME_AXIS_PASS_674036", action = "action_EVENT_TIME_AXIS_PASS_674036", trigger_count = 0 },
	-- 差评价
	{ config_id = 1674037, name = "TIME_AXIS_PASS_674037", event = EventType.EVENT_TIME_AXIS_PASS, source = "", condition = "condition_EVENT_TIME_AXIS_PASS_674037", action = "action_EVENT_TIME_AXIS_PASS_674037", trigger_count = 0 },
	-- 终点_中
	{ config_id = 1674038, name = "CHALLENGE_SUCCESS_674038", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "111", condition = "condition_EVENT_CHALLENGE_SUCCESS_674038", action = "action_EVENT_CHALLENGE_SUCCESS_674038", trigger_count = 0 },
	-- 终点_差
	{ config_id = 1674039, name = "CHALLENGE_SUCCESS_674039", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "111", condition = "condition_EVENT_CHALLENGE_SUCCESS_674039", action = "action_EVENT_CHALLENGE_SUCCESS_674039", trigger_count = 0 },
	-- 发消息回退任务
	{ config_id = 1674041, name = "CHALLENGE_FAIL_674041", event = EventType.EVENT_CHALLENGE_FAIL, source = "111", condition = "", action = "action_EVENT_CHALLENGE_FAIL_674041", trigger_count = 0 },
	-- 终点——完成挑战
	{ config_id = 1674042, name = "ENTER_REGION_674042", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674042", action = "action_EVENT_ENTER_REGION_674042" },
	{ config_id = 1674045, name = "ENTER_REGION_674045", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_674045", action = "action_EVENT_ENTER_REGION_674045" }
}

-- 变量
variables = {
	{ config_id = 1, name = "Time_Var", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 5,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "QUEST_START_674017", "CHALLENGE_SUCCESS_674034", "TIME_AXIS_PASS_674035", "TIME_AXIS_PASS_674036", "TIME_AXIS_PASS_674037", "CHALLENGE_SUCCESS_674038", "CHALLENGE_SUCCESS_674039", "CHALLENGE_FAIL_674041" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 底部环境配置,
		monsters = { },
		gadgets = { 674005, 674006, 674025, 674050, 674057, 674058 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 顶部环境配置,
		monsters = { },
		gadgets = { 674007, 674008, 674009, 674013, 674026, 674030, 674053, 674054, 674055, 674064, 674065, 674066, 674067 },
		regions = { 674020 },
		triggers = { "ENTER_REGION_674020" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 出现途径点3.5,
		monsters = { },
		gadgets = { 674043 },
		regions = { 674045 },
		triggers = { "ENTER_REGION_674045" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 顶部怪物组1,
		monsters = { 674028 },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 底部环境配置2,
		monsters = { },
		gadgets = { 674001, 674002, 674003, 674004, 674010, 674011, 674018, 674024, 674033, 674040, 674047, 674051, 674052, 674059, 674060 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = 清空配置用,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = 出现途径点2,
		monsters = { },
		gadgets = { 674056 },
		regions = { 674022 },
		triggers = { "ENTER_REGION_674022" },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = 出现途径点3,
		monsters = { },
		gadgets = { 674031 },
		regions = { 674019 },
		triggers = { "ENTER_REGION_674019" },
		rand_weight = 100
	},
	{
		-- suite_id = 10,
		-- description = 出现途径点4,
		monsters = { },
		gadgets = { 674032 },
		regions = { 674023 },
		triggers = { "ENTER_REGION_674023" },
		rand_weight = 100
	},
	{
		-- suite_id = 11,
		-- description = 出现终点,
		monsters = { },
		gadgets = { 674048 },
		regions = { 674029 },
		triggers = { "ENTER_REGION_674029" },
		rand_weight = 100
	},
	{
		-- suite_id = 12,
		-- description = 挑战完成,
		monsters = { },
		gadgets = { 674049 },
		regions = { 674042 },
		triggers = { "ENTER_REGION_674042" },
		rand_weight = 100
	},
	{
		-- suite_id = 13,
		-- description = 顶部环境配置2,
		monsters = { },
		gadgets = { 674012, 674014, 674015, 674016, 674021, 674027, 674061, 674062, 674063 },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发操作
function action_EVENT_QUEST_START_674017(context, evt)
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 2)
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 6)
	
	-- 添加suite8的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 8)
	
	-- 创建编号为111（该挑战的识别id),挑战内容为2001006的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 111, 2001006, 90, 4, 999, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 创建标识为"133220674"，时间节点为{1,35,60}的时间轴，false用于控制该时间轴是否循环
	ScriptLib.InitTimeAxis(context, "133220674", {1,35,60}, false)
	
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674019(context, evt)
	if evt.param1 ~= 674019 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674019(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674031 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 3)
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674020(context, evt)
	if evt.param1 ~= 674020 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674020(context, evt)
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674022(context, evt)
	if evt.param1 ~= 674022 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674022(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674056 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 添加suite9的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 9)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674023(context, evt)
	if evt.param1 ~= 674023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674023(context, evt)
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220674, 2)
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 5)
	
	-- 添加suite11的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 11)
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674032 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674029(context, evt)
	if evt.param1 ~= 674029 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674029(context, evt)
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674048 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 添加suite12的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 12)
	
	-- 删除suite13的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220674, 13)
	
	return 0
end

-- 触发条件
function condition_EVENT_CHALLENGE_SUCCESS_674034(context, evt)
	-- 判断变量"Time_Var"为0
	if ScriptLib.GetGroupVariableValue(context, "Time_Var") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_674034(context, evt)
	-- 停止标识为"133220674"的时间轴
	ScriptLib.EndTimeAxis(context, "133220674")
	
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1901503") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220674, suite = 7 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_674035(context, evt)
	if "133220674" ~= evt.source_name or 1 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_674035(context, evt)
	-- 将本组内变量名为 "Time_Var" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "Time_Var", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_674036(context, evt)
	if "133220674" ~= evt.source_name or 2 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_674036(context, evt)
	-- 将本组内变量名为 "Time_Var" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "Time_Var", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_674037(context, evt)
	if "133220674" ~= evt.source_name or 3 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_674037(context, evt)
	-- 将本组内变量名为 "Time_Var" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "Time_Var", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_CHALLENGE_SUCCESS_674038(context, evt)
	-- 判断变量"Time_Var"为1
	if ScriptLib.GetGroupVariableValue(context, "Time_Var") ~= 1 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_674038(context, evt)
	-- 停止标识为"133220674"的时间轴
	ScriptLib.EndTimeAxis(context, "133220674")
	
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1901508") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220674, suite = 7 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_CHALLENGE_SUCCESS_674039(context, evt)
	-- 判断变量"Time_Var"为2
	if ScriptLib.GetGroupVariableValue(context, "Time_Var") ~= 2 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_674039(context, evt)
	-- 停止标识为"133220674"的时间轴
	ScriptLib.EndTimeAxis(context, "133220674")
	
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1901509") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220674, suite = 7 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_674041(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133220674, suite = 7 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "1332206740") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674042(context, evt)
	if evt.param1 ~= 674042 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674042(context, evt)
	-- 终止识别id为111的挑战，并判定成功
		ScriptLib.StopChallenge(context, 111, 1)
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674049 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_674045(context, evt)
	if evt.param1 ~= 674045 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_674045(context, evt)
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133220674, 6)
	
		-- 卸载指定gadget
		if 0 ~= ScriptLib.RemoveEntityByConfigId(context, 133220674, EntityType.GADGET, 674043 ) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : remove_gadget_by_configid")
			return -1
		end
	
	-- 添加suite13的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 13)
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 3)
	
	-- 添加suite10的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133220674, 10)
	
	return 0
end