-- 基础信息
local base_info = {
	group_id = 133301506
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 506001, monster_id = 26090201, pos = { x = -105.129, y = 53.858, z = 3886.641 }, rot = { x = 0.000, y = 227.409, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506002, monster_id = 26090201, pos = { x = -108.220, y = 53.929, z = 3885.874 }, rot = { x = 0.000, y = 295.844, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506003, monster_id = 26090801, pos = { x = -112.532, y = 57.789, z = 3920.379 }, rot = { x = 0.000, y = 219.262, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 },
	{ config_id = 506004, monster_id = 26090101, pos = { x = -120.476, y = 53.400, z = 3899.911 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506005, monster_id = 26090401, pos = { x = -126.379, y = 54.662, z = 3860.070 }, rot = { x = 0.000, y = 86.426, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506006, monster_id = 26090401, pos = { x = -122.170, y = 53.876, z = 3857.730 }, rot = { x = 0.000, y = 323.719, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506007, monster_id = 26090901, pos = { x = -97.202, y = 54.133, z = 3905.177 }, rot = { x = 0.000, y = 216.720, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 },
	{ config_id = 506008, monster_id = 26090101, pos = { x = -125.805, y = 53.400, z = 3886.866 }, rot = { x = 0.000, y = 73.404, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506010, monster_id = 26090101, pos = { x = -127.803, y = 53.400, z = 3894.332 }, rot = { x = 0.000, y = 353.575, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506011, monster_id = 26090501, pos = { x = -95.930, y = 53.400, z = 3857.953 }, rot = { x = 0.000, y = 82.743, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 },
	{ config_id = 506012, monster_id = 26090701, pos = { x = -80.013, y = 55.228, z = 3890.001 }, rot = { x = 0.000, y = 204.229, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 102, area_id = 22 },
	{ config_id = 506013, monster_id = 26090701, pos = { x = -77.471, y = 55.840, z = 3886.435 }, rot = { x = 0.000, y = 37.084, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506014, monster_id = 26090701, pos = { x = -72.966, y = 58.071, z = 3886.995 }, rot = { x = 0.000, y = 50.810, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 103, area_id = 22 },
	{ config_id = 506015, monster_id = 26090501, pos = { x = -90.624, y = 53.816, z = 3854.242 }, rot = { x = 0.000, y = 295.504, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506018, monster_id = 26090901, pos = { x = -100.396, y = 53.795, z = 3907.031 }, rot = { x = 0.000, y = 157.198, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506019, monster_id = 26090101, pos = { x = -123.318, y = 53.400, z = 3894.446 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, drop_tag = "蕈兽", disableWander = true, pose_id = 104, area_id = 22 },
	{ config_id = 506020, monster_id = 26090801, pos = { x = -112.764, y = 66.428, z = 3914.148 }, rot = { x = 0.000, y = 219.262, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 },
	{ config_id = 506021, monster_id = 26090801, pos = { x = -105.258, y = 66.461, z = 3915.142 }, rot = { x = 0.000, y = 219.262, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 },
	{ config_id = 506022, monster_id = 26090801, pos = { x = -107.467, y = 64.812, z = 3919.507 }, rot = { x = 0.000, y = 219.262, z = 0.000 }, level = 27, drop_tag = "蕈兽", pose_id = 104, area_id = 22 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 506030, gadget_id = 70211111, pos = { x = -85.832, y = 54.489, z = 3874.564 }, rot = { x = 339.010, y = 75.785, z = 9.511 }, level = 26, drop_tag = "解谜中级须弥", isOneoff = true, persistent = true, explore = { name = "chest", exp = 10 }, area_id = 22 }
}

-- 区域
regions = {
	{ config_id = 506017, shape = RegionShape.SPHERE, radius = 5, pos = { x = -113.023, y = 58.220, z = 3920.908 }, area_id = 22 }
}

-- 触发器
triggers = {
	{ config_id = 1506017, name = "ENTER_REGION_506017", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_506017", action = "action_EVENT_ENTER_REGION_506017" }
}

-- 变量
variables = {
}

-- 废弃数据
garbages = {
	gadgets = {
		{ config_id = 506009, gadget_id = 70500000, pos = { x = -95.550, y = 54.147, z = 3904.588 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, point_type = 1002, area_id = 22 },
		{ config_id = 506016, gadget_id = 70500000, pos = { x = -97.001, y = 54.880, z = 3908.137 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, point_type = 1001, area_id = 22 },
		{ config_id = 506023, gadget_id = 70500000, pos = { x = -106.457, y = 55.482, z = 3882.149 }, rot = { x = 0.000, y = 294.077, z = 0.000 }, level = 27, point_type = 2046, area_id = 22 },
		{ config_id = 506024, gadget_id = 70500000, pos = { x = -119.321, y = 54.331, z = 3913.077 }, rot = { x = 9.622, y = 227.158, z = 357.452 }, level = 27, point_type = 2045, area_id = 22 },
		{ config_id = 506025, gadget_id = 70500000, pos = { x = -130.682, y = 53.630, z = 3889.352 }, rot = { x = 19.805, y = 60.075, z = 1.769 }, level = 27, point_type = 2045, area_id = 22 },
		{ config_id = 506026, gadget_id = 70500000, pos = { x = -90.012, y = 54.424, z = 3852.422 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, point_type = 2045, area_id = 22 },
		{ config_id = 506027, gadget_id = 70500000, pos = { x = -90.791, y = 53.617, z = 3897.547 }, rot = { x = 10.302, y = 206.676, z = 2.829 }, level = 27, point_type = 2045, area_id = 22 },
		{ config_id = 506028, gadget_id = 70500000, pos = { x = -89.899, y = 54.892, z = 3902.521 }, rot = { x = 0.000, y = 271.536, z = 18.943 }, level = 27, point_type = 2045, area_id = 22 },
		{ config_id = 506029, gadget_id = 70500000, pos = { x = -124.313, y = 54.167, z = 3858.631 }, rot = { x = 7.003, y = 39.848, z = 0.000 }, level = 27, point_type = 2045, area_id = 22 }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { 506001, 506002, 506003, 506004, 506005, 506006, 506007, 506008, 506010, 506011, 506012, 506013, 506014, 506015, 506018, 506019 },
		gadgets = { 506030 },
		regions = { 506017 },
		triggers = { "ENTER_REGION_506017" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_506017(context, evt)
	if evt.param1 ~= 506017 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_506017(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 506020, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 506021, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 506022, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end