-- 基础信息
local base_info = {
	group_id = 133301519
}

-- Trigger变量
local defs = {
	duration = 90,
	group_id = 133301519,
	collectable_sum = 15
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 519001, gadget_id = 70211101, pos = { x = -155.517, y = 308.769, z = 3500.302 }, rot = { x = 358.648, y = 171.618, z = 352.307 }, level = 26, drop_tag = "解谜低级须弥", isOneoff = true, persistent = true, explore = { name = "chest", exp = 10 }, area_id = 29 },
	{ config_id = 519002, gadget_id = 70350093, pos = { x = -218.320, y = 255.936, z = 3633.404 }, rot = { x = 0.000, y = 110.177, z = 0.000 }, level = 27, persistent = true, area_id = 29 },
	{ config_id = 519003, gadget_id = 70360001, pos = { x = -218.326, y = 256.901, z = 3633.406 }, rot = { x = 0.000, y = 110.177, z = 0.000 }, level = 27, persistent = true, area_id = 29 },
	{ config_id = 519004, gadget_id = 70290501, pos = { x = -207.501, y = 258.400, z = 3616.142 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519005, gadget_id = 70290501, pos = { x = -187.971, y = 245.482, z = 3596.045 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519006, gadget_id = 70290501, pos = { x = -173.142, y = 249.649, z = 3568.702 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519007, gadget_id = 70290501, pos = { x = -174.402, y = 254.563, z = 3551.160 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519008, gadget_id = 70290501, pos = { x = -151.019, y = 296.113, z = 3453.520 }, rot = { x = 0.000, y = 35.673, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519009, gadget_id = 70290501, pos = { x = -172.123, y = 297.563, z = 3439.762 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519010, gadget_id = 70290501, pos = { x = -173.848, y = 276.371, z = 3473.465 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519011, gadget_id = 70290501, pos = { x = -198.863, y = 287.692, z = 3469.399 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519019, gadget_id = 70290501, pos = { x = -185.690, y = 296.916, z = 3438.907 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519020, gadget_id = 70290501, pos = { x = -155.110, y = 293.614, z = 3447.125 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519022, gadget_id = 70220103, pos = { x = -173.133, y = 247.848, z = 3568.713 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519024, gadget_id = 70290501, pos = { x = -159.566, y = 267.595, z = 3516.629 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519025, gadget_id = 70290501, pos = { x = -161.747, y = 263.918, z = 3497.628 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519026, gadget_id = 70220103, pos = { x = -173.848, y = 273.150, z = 3473.465 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519027, gadget_id = 70220103, pos = { x = -155.110, y = 291.614, z = 3447.125 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519028, gadget_id = 70220103, pos = { x = -140.472, y = 303.108, z = 3476.411 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519029, gadget_id = 70290501, pos = { x = -140.472, y = 306.119, z = 3476.411 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519030, gadget_id = 70290501, pos = { x = -155.329, y = 314.672, z = 3490.831 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 },
	{ config_id = 519031, gadget_id = 70290501, pos = { x = -197.099, y = 251.372, z = 3604.375 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 27, area_id = 29 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	{ config_id = 1519012, name = "CHALLENGE_SUCCESS_519012", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "666", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_519012", trigger_count = 0 },
	{ config_id = 1519013, name = "CHALLENGE_FAIL_519013", event = EventType.EVENT_CHALLENGE_FAIL, source = "666", condition = "", action = "action_EVENT_CHALLENGE_FAIL_519013", trigger_count = 0 },
	{ config_id = 1519014, name = "GADGET_STATE_CHANGE_519014", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_519014", action = "action_EVENT_GADGET_STATE_CHANGE_519014", trigger_count = 0 },
	{ config_id = 1519015, name = "ANY_GADGET_DIE_519015", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "", action = "", trigger_count = 0, tag = "218" },
	{ config_id = 1519016, name = "GADGET_CREATE_519016", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_519016", action = "action_EVENT_GADGET_CREATE_519016", trigger_count = 0 },
	{ config_id = 1519017, name = "SELECT_OPTION_519017", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_519017", action = "action_EVENT_SELECT_OPTION_519017", trigger_count = 0 },
	-- 2.0rel加的保底，如果group在挑战中间被卸载了，需要在加载时加个保底置回初始状态
	{ config_id = 1519018, name = "GROUP_LOAD_519018", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_EVENT_GROUP_LOAD_519018", trigger_count = 0 }
}

-- 变量
variables = {
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 519002, 519003 },
		regions = { },
		triggers = { "CHALLENGE_SUCCESS_519012", "CHALLENGE_FAIL_519013", "GADGET_STATE_CHANGE_519014", "ANY_GADGET_DIE_519015", "GADGET_CREATE_519016", "SELECT_OPTION_519017", "GROUP_LOAD_519018" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 519004, 519005, 519006, 519007, 519008, 519009, 519010, 519011, 519019, 519020, 519022, 519024, 519025, 519026, 519027, 519028, 519029, 519030, 519031 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 519002 },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_519012(context, evt)
	-- 将configid为 519002 的物件更改为状态 GadgetState.GearStop
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 519002, GadgetState.GearStop) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	    -- 杀死指定group内的gadget和monster,移除其它东西
	    ScriptLib.KillExtraGroupSuite(context, 133301519, 2)
	
	-- 运营数据埋点，匹配LD定义的规则使用
	    if 0 ~= ScriptLib.MarkPlayerAction(context, 3002, 3, 1) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : mark_playerAction")
	      return -1
	    end
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133301519, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	-- 创建id为519001的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 519001 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_519013(context, evt)
	-- 将configid为 519002 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 519002, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为519003的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 519003 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133301519, 2)
	
	-- 运营数据埋点，匹配LD定义的规则使用
	    if 0 ~= ScriptLib.MarkPlayerAction(context, 3002, 4, 1) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : mark_playerAction")
	      return -1
	    end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_519014(context, evt)
	if 519002 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_519014(context, evt)
	-- 247号挑战,duration内开启宝箱
	if 0 ~= ScriptLib.ActiveChallenge(context, 666, 271, defs.duration, 2, 218, defs.collectable_sum) then
	return -1
	end
	
	-- 添加suite2的新内容
	ScriptLib.AddExtraGroupSuite(context, defs.group_id, 2)
	
	-- 运营数据埋点，匹配LD定义的规则使用
	if 0 ~= ScriptLib.MarkPlayerAction(context, 3002, 1, 1) then
	return -1
	end
	
	return 0
	
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_519016(context, evt)
	if 519003 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_519016(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133301519, 519003, {177}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_519017(context, evt)
	-- 判断是gadgetid 519003 option_id 177
	if 519003 ~= evt.param1 then
		return false	
	end
	
	if 177 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_519017(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 519003 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 519002 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 519002, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 触发镜头注目，注目位置为坐标{x=-208.4516, y=259.314, z=3615.676}，持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=-208.4516, y=259.314, z=3615.676}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	return 0
end

-- 触发操作
function action_EVENT_GROUP_LOAD_519018(context, evt)
	-- 将configid为 519002 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 519002, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为519003的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 519003 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133301519, 2)
	
	-- 运营数据埋点，匹配LD定义的规则使用
	    if 0 ~= ScriptLib.MarkPlayerAction(context, 3002, 4, 1) then
	      ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : mark_playerAction")
	      return -1
	    end
	
	return 0
end