-- 基础信息
local base_info = {
	group_id = 133307102
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 102001, monster_id = 28020604, pos = { x = -2010.065, y = 154.700, z = 5828.872 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, drop_tag = "走兽", area_id = 27 },
	{ config_id = 102002, monster_id = 26090901, pos = { x = -2010.133, y = 154.721, z = 5828.639 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, drop_tag = "蕈兽", pose_id = 101, area_id = 27 },
	{ config_id = 102003, monster_id = 28050106, pos = { x = -2010.304, y = 154.746, z = 5828.621 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, drop_tag = "魔法生物", area_id = 27 },
	{ config_id = 102005, monster_id = 28060401, pos = { x = -2010.077, y = 154.572, z = 5828.708 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, drop_tag = "走兽", pose_id = 1, area_id = 27 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 102006, gadget_id = 70330266, pos = { x = -2010.142, y = 154.376, z = 5828.681 }, rot = { x = 352.875, y = 0.000, z = 0.000 }, level = 32, area_id = 27 },
	{ config_id = 102007, gadget_id = 70210101, pos = { x = -2010.326, y = 154.595, z = 5828.843 }, rot = { x = 337.605, y = 2.984, z = 345.011 }, level = 26, drop_tag = "搜刮点解谜破损须弥", persistent = true, area_id = 27 }
}

-- 区域
regions = {
	-- 需要伏击怪食用这个
	{ config_id = 102013, shape = RegionShape.SPHERE, radius = 2.35, pos = { x = -2009.850, y = 154.718, z = 5828.954 }, area_id = 27 }
}

-- 触发器
triggers = {
	-- 刷调查点
	{ config_id = 1102008, name = "ANY_GADGET_DIE_102008", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_102008", action = "action_EVENT_ANY_GADGET_DIE_102008" },
	-- 刷面具鼬
	{ config_id = 1102009, name = "ANY_GADGET_DIE_102009", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_102009", action = "action_EVENT_ANY_GADGET_DIE_102009" },
	-- 刷岩蕈兽
	{ config_id = 1102010, name = "ANY_GADGET_DIE_102010", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_102010", action = "action_EVENT_ANY_GADGET_DIE_102010" },
	-- 刷草晶蝶
	{ config_id = 1102011, name = "ANY_GADGET_DIE_102011", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_102011", action = "action_EVENT_ANY_GADGET_DIE_102011" },
	-- 刷蝎子
	{ config_id = 1102012, name = "ANY_GADGET_DIE_102012", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_102012", action = "action_EVENT_ANY_GADGET_DIE_102012" },
	-- 需要伏击怪食用这个
	{ config_id = 1102013, name = "ENTER_REGION_102013", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_102013", action = "action_EVENT_ENTER_REGION_102013" }
}

-- 变量
variables = {
}

-- 废弃数据
garbages = {
	monsters = {
		{ config_id = 102004, monster_id = 28050106, pos = { x = -2009.826, y = 154.799, z = 5828.750 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, drop_tag = "魔法生物", area_id = 27 }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = true
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_102008" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_102009" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { 102013 },
		triggers = { "ANY_GADGET_DIE_102010", "ENTER_REGION_102013" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_102011" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { },
		gadgets = { 102006 },
		regions = { 102013 },
		triggers = { "ANY_GADGET_DIE_102012", "ENTER_REGION_102013" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_102008(context, evt)
	if 102006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_102008(context, evt)
	-- 创建id为102007的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 102007 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_102009(context, evt)
	if 102006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_102009(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 102001, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_102010(context, evt)
	if 102006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_102010(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 102002, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_102011(context, evt)
	if 102006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_102011(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 102003, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_102012(context, evt)
	if 102006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_102012(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 102005, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_102013(context, evt)
	if evt.param1 ~= 102013 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_102013(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 102006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end