-- 基础信息
local base_info = {
	group_id = 133308303
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	-- 1
	{ config_id = 303005, gadget_id = 70330323, pos = { x = -1493.574, y = 190.000, z = 4422.747 }, rot = { x = 271.282, y = -0.001, z = 9.216 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	-- 2
	{ config_id = 303009, gadget_id = 70330323, pos = { x = -1503.068, y = 161.528, z = 4366.768 }, rot = { x = 270.000, y = 188.775, z = 0.000 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	-- a
	{ config_id = 303011, gadget_id = 70330323, pos = { x = -1516.428, y = 140.000, z = 4447.729 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	-- b
	{ config_id = 303012, gadget_id = 70330323, pos = { x = -1522.428, y = 140.000, z = 4409.849 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	-- c
	{ config_id = 303013, gadget_id = 70330323, pos = { x = -1528.146, y = 140.000, z = 4373.748 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	-- d
	{ config_id = 303014, gadget_id = 70330323, pos = { x = -1441.698, y = 140.000, z = 4433.292 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 32, start_route = false, is_use_point_array = true, area_id = 26 },
	{ config_id = 303025, gadget_id = 70330392, pos = { x = -1488.490, y = 125.000, z = 4426.795 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303026, gadget_id = 70330392, pos = { x = -1486.760, y = 125.000, z = 4436.644 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303027, gadget_id = 70330392, pos = { x = -1496.609, y = 125.000, z = 4438.375 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303028, gadget_id = 70330392, pos = { x = -1498.339, y = 125.000, z = 4428.526 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303029, gadget_id = 70330392, pos = { x = -1497.858, y = 115.000, z = 4417.930 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303030, gadget_id = 70330392, pos = { x = -1496.129, y = 115.000, z = 4427.771 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303031, gadget_id = 70330392, pos = { x = -1494.398, y = 115.000, z = 4437.621 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303032, gadget_id = 70330392, pos = { x = -1504.247, y = 115.000, z = 4439.351 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303033, gadget_id = 70330392, pos = { x = -1484.549, y = 115.000, z = 4435.890 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303034, gadget_id = 70330392, pos = { x = -1499.562, y = 115.000, z = 4448.681 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303035, gadget_id = 70330392, pos = { x = -1489.713, y = 115.000, z = 4446.951 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303036, gadget_id = 70330392, pos = { x = -1479.864, y = 115.000, z = 4445.220 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303037, gadget_id = 70330392, pos = { x = -1488.009, y = 115.000, z = 4416.199 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303038, gadget_id = 70330392, pos = { x = -1496.993, y = 105.000, z = 4422.854 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303039, gadget_id = 70330392, pos = { x = -1488.874, y = 105.000, z = 4411.274 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303040, gadget_id = 70330392, pos = { x = -1508.572, y = 105.000, z = 4414.735 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 303047, gadget_id = 70330392, pos = { x = -1496.733, y = 154.027, z = 4405.949 }, rot = { x = 270.000, y = 8.946, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303048, gadget_id = 70330392, pos = { x = -1500.273, y = 154.027, z = 4415.618 }, rot = { x = 270.000, y = 8.946, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303049, gadget_id = 70330392, pos = { x = -1490.604, y = 105.000, z = 4401.425 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303050, gadget_id = 70330392, pos = { x = -1474.700, y = 115.000, z = 4434.160 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303051, gadget_id = 70330392, pos = { x = -1478.160, y = 115.000, z = 4414.469 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303052, gadget_id = 70330392, pos = { x = -1485.586, y = 105.000, z = 4429.987 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303053, gadget_id = 70330392, pos = { x = -1483.856, y = 105.000, z = 4439.836 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303054, gadget_id = 70330392, pos = { x = -1474.007, y = 105.000, z = 4438.105 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303055, gadget_id = 70330392, pos = { x = -1475.737, y = 105.000, z = 4428.256 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303056, gadget_id = 70330392, pos = { x = -1506.842, y = 105.000, z = 4424.584 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303057, gadget_id = 70330392, pos = { x = -1505.112, y = 105.000, z = 4434.433 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303058, gadget_id = 70330392, pos = { x = -1503.382, y = 105.000, z = 4444.282 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303059, gadget_id = 70330392, pos = { x = -1493.533, y = 105.000, z = 4442.552 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303060, gadget_id = 70330392, pos = { x = -1500.453, y = 105.000, z = 4403.156 }, rot = { x = 0.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303061, gadget_id = 70330392, pos = { x = -1498.723, y = 120.000, z = 4413.005 }, rot = { x = 270.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303062, gadget_id = 70330392, pos = { x = -1497.594, y = 93.002, z = 4436.216 }, rot = { x = 270.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303063, gadget_id = 70330392, pos = { x = -1483.555, y = 93.002, z = 4440.316 }, rot = { x = 270.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303064, gadget_id = 70330392, pos = { x = -1482.219, y = 120.000, z = 4420.258 }, rot = { x = 270.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303065, gadget_id = 70330392, pos = { x = -1500.879, y = 120.000, z = 4429.628 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303066, gadget_id = 70330392, pos = { x = -1479.109, y = 93.002, z = 4425.090 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303067, gadget_id = 70330392, pos = { x = -1507.672, y = 93.002, z = 4430.108 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303068, gadget_id = 70330392, pos = { x = -1506.789, y = 120.000, z = 4430.666 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303069, gadget_id = 70330392, pos = { x = -1500.187, y = 110.000, z = 4433.567 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303070, gadget_id = 70330392, pos = { x = -1493.799, y = 110.000, z = 4412.138 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303071, gadget_id = 70330392, pos = { x = -1488.009, y = 110.000, z = 4416.198 }, rot = { x = 270.000, y = 9.965, z = 0.000 }, level = 30, area_id = 26 },
	{ config_id = 303072, gadget_id = 70330392, pos = { x = -1506.789, y = 120.000, z = 4430.666 }, rot = { x = 270.000, y = 99.965, z = 0.000 }, level = 30, area_id = 26 },
	-- e
	{ config_id = 303073, gadget_id = 70330323, pos = { x = -1477.669, y = 140.000, z = 4438.990 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 30, start_route = false, is_use_point_array = true, area_id = 26 },
	-- f
	{ config_id = 303074, gadget_id = 70330323, pos = { x = -1483.669, y = 140.000, z = 4401.110 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 30, start_route = false, is_use_point_array = true, area_id = 26 },
	-- g
	{ config_id = 303075, gadget_id = 70330323, pos = { x = -1489.387, y = 140.000, z = 4365.009 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 30, start_route = false, is_use_point_array = true, area_id = 26 },
	-- h
	{ config_id = 303076, gadget_id = 70330323, pos = { x = -1447.254, y = 140.000, z = 4398.214 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 30, start_route = false, is_use_point_array = true, area_id = 26 },
	-- i
	{ config_id = 303077, gadget_id = 70330323, pos = { x = -1452.902, y = 140.000, z = 4362.556 }, rot = { x = 0.000, y = 189.000, z = 180.000 }, level = 30, start_route = false, is_use_point_array = true, area_id = 26 },
	{ config_id = 303093, gadget_id = 70330392, pos = { x = -1493.129, y = 131.000, z = 4428.961 }, rot = { x = 0.000, y = 188.790, z = 0.000 }, level = 30, area_id = 26 }
}

-- 区域
regions = {
	{ config_id = 303002, shape = RegionShape.POLYGON, pos = { x = -1490.851, y = 88.926, z = 4459.391 }, height = 46.148, point_array = { { x = -1512.000, y = 4446.316 }, { x = -1474.348, y = 4440.635 }, { x = -1469.703, y = 4473.249 }, { x = -1500.363, y = 4478.146 } }, area_id = 26 },
	{ config_id = 303010, shape = RegionShape.CUBIC, size = { x = 30.000, y = 15.000, z = 10.000 }, pos = { x = -1501.787, y = 156.861, z = 4370.474 }, area_id = 26 },
	{ config_id = 303018, shape = RegionShape.CUBIC, size = { x = 100.000, y = 10.000, z = 100.000 }, pos = { x = -1493.190, y = 132.287, z = 4426.559 }, area_id = 26 }
}

-- 触发器
triggers = {
	{ config_id = 1303001, name = "QUEST_START_303001", event = EventType.EVENT_QUEST_START, source = "7305544", condition = "", action = "action_EVENT_QUEST_START_303001", trigger_count = 0 },
	{ config_id = 1303002, name = "ENTER_REGION_303002", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_303002", action = "action_EVENT_ENTER_REGION_303002", trigger_count = 0, tag = "303002" },
	-- 挑战成功事件
	{ config_id = 1303003, name = "CHALLENGE_SUCCESS_303003", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "133308303", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_303003", trigger_count = 0 },
	-- 挑战失败事件
	{ config_id = 1303004, name = "CHALLENGE_FAIL_303004", event = EventType.EVENT_CHALLENGE_FAIL, source = "133308303", condition = "", action = "action_EVENT_CHALLENGE_FAIL_303004", trigger_count = 0 },
	-- 1
	{ config_id = 1303006, name = "GADGET_STATE_CHANGE_303006", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303006", action = "action_EVENT_GADGET_STATE_CHANGE_303006", trigger_count = 0 },
	-- 2
	{ config_id = 1303007, name = "GADGET_STATE_CHANGE_303007", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303007", action = "action_EVENT_GADGET_STATE_CHANGE_303007", trigger_count = 0 },
	-- a
	{ config_id = 1303008, name = "GADGET_STATE_CHANGE_303008", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303008", action = "action_EVENT_GADGET_STATE_CHANGE_303008", trigger_count = 0 },
	{ config_id = 1303010, name = "ENTER_REGION_303010", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_303010", action = "action_EVENT_ENTER_REGION_303010" },
	-- b
	{ config_id = 1303015, name = "GADGET_STATE_CHANGE_303015", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303015", action = "action_EVENT_GADGET_STATE_CHANGE_303015", trigger_count = 0 },
	-- c
	{ config_id = 1303016, name = "GADGET_STATE_CHANGE_303016", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303016", action = "action_EVENT_GADGET_STATE_CHANGE_303016", trigger_count = 0 },
	-- d
	{ config_id = 1303017, name = "GADGET_STATE_CHANGE_303017", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303017", action = "action_EVENT_GADGET_STATE_CHANGE_303017", trigger_count = 0 },
	{ config_id = 1303018, name = "ENTER_REGION_303018", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_303018", action = "action_EVENT_ENTER_REGION_303018" },
	{ config_id = 1303019, name = "GADGET_CREATE_303019", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303019", action = "action_EVENT_GADGET_CREATE_303019" },
	{ config_id = 1303020, name = "GADGET_CREATE_303020", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303020", action = "action_EVENT_GADGET_CREATE_303020" },
	-- a
	{ config_id = 1303021, name = "GADGET_CREATE_303021", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303021", action = "action_EVENT_GADGET_CREATE_303021", trigger_count = 0 },
	-- b
	{ config_id = 1303022, name = "GADGET_CREATE_303022", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303022", action = "action_EVENT_GADGET_CREATE_303022", trigger_count = 0 },
	-- c
	{ config_id = 1303023, name = "GADGET_CREATE_303023", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303023", action = "action_EVENT_GADGET_CREATE_303023", trigger_count = 0 },
	-- d
	{ config_id = 1303024, name = "GADGET_CREATE_303024", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303024", action = "action_EVENT_GADGET_CREATE_303024", trigger_count = 0 },
	{ config_id = 1303041, name = "PLATFORM_ARRIVAL_303041", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303041", action = "action_EVENT_PLATFORM_ARRIVAL_303041" },
	{ config_id = 1303042, name = "PLATFORM_ARRIVAL_303042", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303042", action = "action_EVENT_PLATFORM_ARRIVAL_303042" },
	{ config_id = 1303043, name = "PLATFORM_ARRIVAL_303043", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303043", action = "action_EVENT_PLATFORM_ARRIVAL_303043", trigger_count = 0 },
	{ config_id = 1303044, name = "PLATFORM_ARRIVAL_303044", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303044", action = "action_EVENT_PLATFORM_ARRIVAL_303044", trigger_count = 0 },
	{ config_id = 1303045, name = "PLATFORM_ARRIVAL_303045", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303045", action = "action_EVENT_PLATFORM_ARRIVAL_303045", trigger_count = 0 },
	{ config_id = 1303046, name = "PLATFORM_ARRIVAL_303046", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303046", action = "action_EVENT_PLATFORM_ARRIVAL_303046", trigger_count = 0 },
	-- e
	{ config_id = 1303078, name = "GADGET_STATE_CHANGE_303078", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303078", action = "action_EVENT_GADGET_STATE_CHANGE_303078", trigger_count = 0 },
	-- f
	{ config_id = 1303079, name = "GADGET_STATE_CHANGE_303079", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303079", action = "action_EVENT_GADGET_STATE_CHANGE_303079", trigger_count = 0 },
	-- g
	{ config_id = 1303080, name = "GADGET_STATE_CHANGE_303080", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303080", action = "action_EVENT_GADGET_STATE_CHANGE_303080", trigger_count = 0 },
	-- h
	{ config_id = 1303081, name = "GADGET_STATE_CHANGE_303081", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303081", action = "action_EVENT_GADGET_STATE_CHANGE_303081", trigger_count = 0 },
	-- i
	{ config_id = 1303082, name = "GADGET_STATE_CHANGE_303082", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_303082", action = "action_EVENT_GADGET_STATE_CHANGE_303082", trigger_count = 0 },
	-- e
	{ config_id = 1303083, name = "GADGET_CREATE_303083", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303083", action = "action_EVENT_GADGET_CREATE_303083", trigger_count = 0 },
	-- f
	{ config_id = 1303084, name = "GADGET_CREATE_303084", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303084", action = "action_EVENT_GADGET_CREATE_303084", trigger_count = 0 },
	-- g
	{ config_id = 1303085, name = "GADGET_CREATE_303085", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303085", action = "action_EVENT_GADGET_CREATE_303085", trigger_count = 0 },
	-- h
	{ config_id = 1303086, name = "GADGET_CREATE_303086", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303086", action = "action_EVENT_GADGET_CREATE_303086", trigger_count = 0 },
	-- i
	{ config_id = 1303087, name = "GADGET_CREATE_303087", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_303087", action = "action_EVENT_GADGET_CREATE_303087", trigger_count = 0 },
	{ config_id = 1303088, name = "PLATFORM_ARRIVAL_303088", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303088", action = "action_EVENT_PLATFORM_ARRIVAL_303088", trigger_count = 0 },
	{ config_id = 1303089, name = "PLATFORM_ARRIVAL_303089", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303089", action = "action_EVENT_PLATFORM_ARRIVAL_303089", trigger_count = 0 },
	{ config_id = 1303090, name = "PLATFORM_ARRIVAL_303090", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303090", action = "action_EVENT_PLATFORM_ARRIVAL_303090", trigger_count = 0 },
	{ config_id = 1303091, name = "PLATFORM_ARRIVAL_303091", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303091", action = "action_EVENT_PLATFORM_ARRIVAL_303091", trigger_count = 0 },
	{ config_id = 1303092, name = "PLATFORM_ARRIVAL_303092", event = EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "condition_EVENT_PLATFORM_ARRIVAL_303092", action = "action_EVENT_PLATFORM_ARRIVAL_303092", trigger_count = 0 }
}

-- 变量
variables = {
}

-- 废弃数据
garbages = {
	regions = {
		{ config_id = 303094, shape = RegionShape.CYLINDER, radius = 105, pos = { x = -1493.000, y = 124.317, z = 4432.000 }, height = 350.000, area_id = 26 }
	},
	triggers = {
		{ config_id = 1303094, name = "LEAVE_REGION_303094", event = EventType.EVENT_LEAVE_REGION, source = "", condition = "condition_EVENT_LEAVE_REGION_303094", action = "action_EVENT_LEAVE_REGION_303094", trigger_count = 0 }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { 303002 },
		triggers = { "QUEST_START_303001", "ENTER_REGION_303002", "CHALLENGE_SUCCESS_303003", "CHALLENGE_FAIL_303004" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 303005 },
		regions = { 303010 },
		triggers = { "GADGET_STATE_CHANGE_303006", "ENTER_REGION_303010", "GADGET_CREATE_303019", "PLATFORM_ARRIVAL_303041" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 303009, 303047, 303048 },
		regions = { 303018 },
		triggers = { "GADGET_STATE_CHANGE_303007", "ENTER_REGION_303018", "GADGET_CREATE_303020", "PLATFORM_ARRIVAL_303042" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 303011, 303012, 303013, 303014, 303025, 303026, 303027, 303028, 303029, 303030, 303031, 303032, 303033, 303034, 303035, 303036, 303037, 303038, 303039, 303040, 303049, 303050, 303051, 303052, 303053, 303054, 303055, 303056, 303057, 303058, 303059, 303060, 303061, 303062, 303063, 303064, 303065, 303066, 303067, 303068, 303069, 303070, 303071, 303072, 303073, 303074, 303075, 303076, 303077 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_303008", "GADGET_STATE_CHANGE_303015", "GADGET_STATE_CHANGE_303016", "GADGET_STATE_CHANGE_303017", "GADGET_CREATE_303021", "GADGET_CREATE_303022", "GADGET_CREATE_303023", "GADGET_CREATE_303024", "PLATFORM_ARRIVAL_303043", "PLATFORM_ARRIVAL_303044", "PLATFORM_ARRIVAL_303045", "PLATFORM_ARRIVAL_303046", "GADGET_STATE_CHANGE_303078", "GADGET_STATE_CHANGE_303079", "GADGET_STATE_CHANGE_303080", "GADGET_STATE_CHANGE_303081", "GADGET_STATE_CHANGE_303082", "GADGET_CREATE_303083", "GADGET_CREATE_303084", "GADGET_CREATE_303085", "GADGET_CREATE_303086", "GADGET_CREATE_303087", "PLATFORM_ARRIVAL_303088", "PLATFORM_ARRIVAL_303089", "PLATFORM_ARRIVAL_303090", "PLATFORM_ARRIVAL_303091", "PLATFORM_ARRIVAL_303092" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { },
		gadgets = { 303093 },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发操作
function action_EVENT_QUEST_START_303001(context, evt)
	-- 创建编号为133308303（该挑战的识别id),挑战内容为275的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 133308303, 275, 4, 303002, 1, 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 调用提示id为 730551101 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 730551101) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133308303, 2)
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133308303, 6)
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308606, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308597, suite = 2 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308120, suite = 2 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308243, suite = 3 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_303002(context, evt)
	if evt.param1 ~= 303002 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_303002(context, evt)
	-- 终止识别id为133308303的挑战，并判定成功
		ScriptLib.StopChallenge(context, 133308303, 1)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_303003(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "WQ7305544") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308606, suite = 3 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308303, suite = 5 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_303004(context, evt)
	-- 通知任务系统完成条件类型"LUA通知"，复杂参数为quest_param的进度+1
	if 0 ~= ScriptLib.AddQuestProgress(context, "WQ7305544_Fail") then
		ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : add_quest_progress")
	  return -1
	end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308303, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133308606, suite = 2 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 2)
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 3)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303006(context, evt)
	if 303005 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303006(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303007(context, evt)
	if 303009 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303007(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303008(context, evt)
	if 303011 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303008(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_303010(context, evt)
	if evt.param1 ~= 303010 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_303010(context, evt)
	-- 调用提示id为 730551201 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 730551201) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133308303, 3)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 2)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303015(context, evt)
	if 303012 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303015(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303016(context, evt)
	if 303013 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303016(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303017(context, evt)
	if 303014 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303017(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_303018(context, evt)
	if evt.param1 ~= 303018 then return false end
	
	-- 判断角色数量不少于0
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 0 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_303018(context, evt)
	-- 调用提示id为 730551301 的提示UI，会显示在屏幕中央偏下位置，id索引自 ReminderData表格
	if 0 ~= ScriptLib.ShowReminder(context, 730551301) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_reminder_ui")
		return -1
	end
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133308303, 4)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 2)
	
	-- 删除suite3的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133308303, 3)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303019(context, evt)
	if 303005 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303019(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303005, 330800044, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303020(context, evt)
	if 303009 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303020(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303009, 330800045, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303021(context, evt)
	if 303011 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303021(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303011, 330800046, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303022(context, evt)
	if 303012 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303022(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303012, 330800047, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303023(context, evt)
	if 303013 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303023(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303013, 330800048, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303024(context, evt)
	if 303014 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303024(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303014, 330800049, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303041(context, evt)
	-- 判断是gadgetid 为 303005的移动平台，是否到达了330800044 的点集中的 2 点
	
	if 303005 ~= evt.param1 then
	  return false
	end
	
	if 330800044 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303041(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303042(context, evt)
	-- 判断是gadgetid 为 303009的移动平台，是否到达了330800045 的点集中的 2 点
	
	if 303009 ~= evt.param1 then
	  return false
	end
	
	if 330800045 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303042(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303043(context, evt)
	-- 判断是gadgetid 为 303011的移动平台，是否到达了330800046 的点集中的 2 点
	
	if 303011 ~= evt.param1 then
	  return false
	end
	
	if 330800046 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303043(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303044(context, evt)
	-- 判断是gadgetid 为 303012的移动平台，是否到达了330800047 的点集中的 2 点
	
	if 303012 ~= evt.param1 then
	  return false
	end
	
	if 330800047 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303044(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303045(context, evt)
	-- 判断是gadgetid 为 303013的移动平台，是否到达了330800048 的点集中的 2 点
	
	if 303013 ~= evt.param1 then
	  return false
	end
	
	if 330800048 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303045(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303046(context, evt)
	-- 判断是gadgetid 为 303014的移动平台，是否到达了330800049 的点集中的 2 点
	
	if 303014 ~= evt.param1 then
	  return false
	end
	
	if 330800049 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303046(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303078(context, evt)
	if 303073 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303078(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303079(context, evt)
	if 303074 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303079(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303080(context, evt)
	if 303075 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303080(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303081(context, evt)
	if 303076 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303081(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_303082(context, evt)
	if 303077 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_303082(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303083(context, evt)
	if 303073 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303083(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303073, 330800059, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303084(context, evt)
	if 303074 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303084(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303074, 330800060, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303085(context, evt)
	if 303075 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303085(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303075, 330800061, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303086(context, evt)
	if 303076 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303086(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303076, 330800062, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_CREATE_303087(context, evt)
	if 303077 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_303087(context, evt)
	-- 设置移动平台点阵,点阵id为point_array_id
	-- route_type = 0,1,2 [OneWay 单向/Reciprocate 往复/Loop 循环]
	-- turn_mode = true/false 开启/关闭
	local tempParam = {route_type = 0, turn_mode = false}
	if 0 ~= ScriptLib.SetPlatformPointArray(context, 303077, 330800063, {1,2}, tempParam) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_platform_pointArray")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303088(context, evt)
	-- 判断是gadgetid 为 303073的移动平台，是否到达了330800059 的点集中的 2 点
	
	if 303073 ~= evt.param1 then
	  return false
	end
	
	if 330800059 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303088(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303089(context, evt)
	-- 判断是gadgetid 为 303074的移动平台，是否到达了330800060 的点集中的 2 点
	
	if 303074 ~= evt.param1 then
	  return false
	end
	
	if 330800060 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303089(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303090(context, evt)
	-- 判断是gadgetid 为 303075的移动平台，是否到达了330800061 的点集中的 2 点
	
	if 303075 ~= evt.param1 then
	  return false
	end
	
	if 330800061 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303090(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303091(context, evt)
	-- 判断是gadgetid 为 303076的移动平台，是否到达了330800062 的点集中的 2 点
	
	if 303076 ~= evt.param1 then
	  return false
	end
	
	if 330800062 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303091(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end

-- 触发条件
function condition_EVENT_PLATFORM_ARRIVAL_303092(context, evt)
	-- 判断是gadgetid 为 303077的移动平台，是否到达了330800063 的点集中的 2 点
	
	if 303077 ~= evt.param1 then
	  return false
	end
	
	if 330800063 ~= evt.param2 then
	  return false
	end
	
	if 2 ~= evt.param3 then
	  return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_PLATFORM_ARRIVAL_303092(context, evt)
	-- 终止识别id为133308303的挑战，并判定失败
		ScriptLib.StopChallenge(context, 133308303, 0)
	
	return 0
end