-- 基础信息
local base_info = {
	group_id = 133308550
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 550001, monster_id = 28020604, pos = { x = -2443.958, y = 25.779, z = 4351.066 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, drop_tag = "走兽", area_id = 26 },
	{ config_id = 550002, monster_id = 26090901, pos = { x = -2443.771, y = 25.202, z = 4350.911 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, drop_tag = "蕈兽", pose_id = 101, area_id = 26 },
	{ config_id = 550003, monster_id = 28050106, pos = { x = -2443.823, y = 26.050, z = 4350.746 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, drop_tag = "魔法生物", area_id = 26 },
	{ config_id = 550005, monster_id = 28060401, pos = { x = -2443.811, y = 25.191, z = 4350.989 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, drop_tag = "走兽", pose_id = 1, area_id = 26 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 550006, gadget_id = 70330266, pos = { x = -2443.811, y = 25.569, z = 4350.918 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, area_id = 26 },
	{ config_id = 550007, gadget_id = 70210101, pos = { x = -2443.662, y = 25.272, z = 4350.872 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 26, drop_tag = "搜刮点解谜破损须弥", persistent = true, area_id = 26 }
}

-- 区域
regions = {
	-- 需要伏击怪食用这个
	{ config_id = 550013, shape = RegionShape.SPHERE, radius = 2.35, pos = { x = -2443.947, y = 25.912, z = 4351.296 }, area_id = 26 }
}

-- 触发器
triggers = {
	-- 刷调查点
	{ config_id = 1550008, name = "ANY_GADGET_DIE_550008", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_550008", action = "action_EVENT_ANY_GADGET_DIE_550008" },
	-- 刷面具鼬
	{ config_id = 1550009, name = "ANY_GADGET_DIE_550009", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_550009", action = "action_EVENT_ANY_GADGET_DIE_550009" },
	-- 刷岩蕈兽
	{ config_id = 1550010, name = "ANY_GADGET_DIE_550010", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_550010", action = "action_EVENT_ANY_GADGET_DIE_550010" },
	-- 刷草晶蝶
	{ config_id = 1550011, name = "ANY_GADGET_DIE_550011", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_550011", action = "action_EVENT_ANY_GADGET_DIE_550011" },
	-- 刷蝎子
	{ config_id = 1550012, name = "ANY_GADGET_DIE_550012", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_550012", action = "action_EVENT_ANY_GADGET_DIE_550012" },
	-- 需要伏击怪食用这个
	{ config_id = 1550013, name = "ENTER_REGION_550013", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_550013", action = "action_EVENT_ENTER_REGION_550013" }
}

-- 变量
variables = {
}

-- 废弃数据
garbages = {
	monsters = {
		{ config_id = 550004, monster_id = 28050106, pos = { x = -2443.749, y = 26.083, z = 4351.236 }, rot = { x = 0.000, y = 293.632, z = 0.000 }, level = 32, drop_tag = "魔法生物", area_id = 26 }
	}
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = true
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_550008" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_550009" },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { 550013 },
		triggers = { "ANY_GADGET_DIE_550010", "ENTER_REGION_550013" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { },
		triggers = { "ANY_GADGET_DIE_550011" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { },
		gadgets = { 550006 },
		regions = { 550013 },
		triggers = { "ANY_GADGET_DIE_550012", "ENTER_REGION_550013" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_550008(context, evt)
	if 550006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_550008(context, evt)
	-- 创建id为550007的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 550007 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_550009(context, evt)
	if 550006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_550009(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 550001, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_550010(context, evt)
	if 550006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_550010(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 550002, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_550011(context, evt)
	if 550006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_550011(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 550003, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_550012(context, evt)
	if 550006 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ANY_GADGET_DIE_550012(context, evt)
	-- 延迟0秒刷怪
	if 0 ~= ScriptLib.CreateMonster(context, { config_id = 550005, delay_time = 0 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_monster")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_550013(context, evt)
	if evt.param1 ~= 550013 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_550013(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 550006 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end