-- 基础信息
local base_info = {
	group_id = 133309624
}

-- Trigger变量
local defs = {
	gadget_door = 624002,
	gadget_switch = 624001,
	group_id = 133309624,
	point_camera = 624006,
	gadget_lookEntity = 624002,
	look_duration = 4
}

-- DEFS_MISCS
local CameraLookSetting = {
    blend_type = 0,
  --镜头的移动路径，球面0，直线1
    blend_duration = 1,
 --镜头的移动时间
    is_force_walk = false,
 --强制玩家行走
    is_allow_input = false,
 --允许输入
    delay = 0,
 --触发延迟
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	[624001] = { config_id = 624001, gadget_id = 70330341, pos = { x = -2821.102, y = 206.113, z = 5964.094 }, rot = { x = 90.000, y = 90.000, z = 0.000 }, level = 32, persistent = true, worktop_config = { is_persistent = true, init_options = { 1 } }, area_id = 27 },
	[624002] = { config_id = 624002, gadget_id = 70330416, pos = { x = -2816.798, y = 203.579, z = 5960.218 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 32, persistent = true, vision_level = VisionLevelType.VISION_LEVEL_NORMAL, area_id = 27 }
}

-- 区域
regions = {
}

-- 触发器
triggers = {
	-- 延迟1秒开门
	{ config_id = 1624003, name = "TIME_AXIS_PASS_624003", event = EventType.EVENT_TIME_AXIS_PASS, source = "", condition = "condition_EVENT_TIME_AXIS_PASS_624003", action = "action_EVENT_TIME_AXIS_PASS_624003", trigger_count = 0 },
	-- 交互开门
	{ config_id = 1624004, name = "SELECT_OPTION_624004", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_624004", action = "action_EVENT_SELECT_OPTION_624004", trigger_count = 0 },
	-- 保底开门
	{ config_id = 1624005, name = "GROUP_LOAD_624005", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "condition_EVENT_GROUP_LOAD_624005", action = "action_EVENT_GROUP_LOAD_624005", trigger_count = 0 }
}

-- 点位
points = {
	[624006] = { config_id = 624006, pos = { x = -2785.103, y = 137.536, z = 6551.225 }, rot = { x = 0.000, y = 0.000, z = 0.000 } }
}

-- 变量
variables = {
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 624001, 624002 },
		regions = { },
		triggers = { "TIME_AXIS_PASS_624003", "SELECT_OPTION_624004", "GROUP_LOAD_624005" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_TIME_AXIS_PASS_624003(context, evt)
	if "open_door" ~= evt.source_name or 1 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_TIME_AXIS_PASS_624003(context, evt)
	
	-- 将configid为 defs.gadget_door 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_door, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_624004(context, evt)
	-- 判断是gadgetid 624001 option_id 1
	if 624001 ~= evt.param1 then
		return false	
	end
	
	if 1 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_624004(context, evt)
	-- 将configid为 624001 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 624001, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建标识为"open_door"，时间节点为{1}的时间轴，false用于控制该时间轴是否循环
	ScriptLib.InitTimeAxis(context, "open_door", {1}, false)
	
	
	return 0
end

-- 触发条件
function condition_EVENT_GROUP_LOAD_624005(context, evt)
	if GadgetState.GearStart ~= ScriptLib.GetGadgetStateByConfigId(context, 133309624, 624001) then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GROUP_LOAD_624005(context, evt)
	-- 将configid为 624002 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 624002, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除指定group： 133309624 ；指定config：624001；物件身上指定option：1；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133309624, 624001, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
	return 0
end